﻿/* =========================================================================================================
  Script Sauvegarde Armes : revive_armements.sqf
  Version: 1.52
  Auteur: The-KiLLeR (www.clan-ado.fr / killouze@hotmail.fr)
========================================================================================================= */
private ["_armes","_munitions","_items","_sac","_armesSac","_munitionsSac"];

// Récupération des armes, munitions et sac à dos
_armes = weapons player;
_munitions = magazines player;
_items = items player;
_sac = unitBackpack player;
_respawn = false;

if (!isNull _sac) then {

	_armesSac = getWeaponCargo _sac;
	_munitionsSac = getMagazineCargo _sac;
	
	// Si le joueur était dans l'eau
	_JoueurPos = getPosATL player;
	if (surfaceIsWater _JoueurPos) then {

		_posCentre = getMarkerPos "ADO_REVIVE_centre";
		_pos1 = ((_posCentre select 0) - (_JoueurPos select 0))/30;
		_pos2 = ((_posCentre select 1) - (_JoueurPos select 1))/30;
		_i = 1;
		
		while {true} do {

			if (!surfaceIsWater [(_JoueurPos select 0) + (_pos1 * _i), (_JoueurPos select 1) + (_pos2 * _i),0]) exitWith {
				_JoueurPos = [(_JoueurPos select 0) + (_pos1 * _i), (_JoueurPos select 1) + (_pos2 * _i),0];
			};
			_i = _i + 1;
			sleep 0.1;
		};
	};
	
	if (ADO_REVIVE_sac_joueur1 == player) then {
		ADO_REVIVE_sac_statut = [3,1,_JoueurPos];
		publicVariable "ADO_REVIVE_sac_statut";
		_respawn = true;
	};
	if (ADO_REVIVE_sac_joueur2 == player) then {
		ADO_REVIVE_sac_statut = [3,2,_JoueurPos];
		publicVariable "ADO_REVIVE_sac_statut";
		_respawn = true;
	};
};

// En attente de réapparition
waitUntil { alive player };

// On retire toutes les armes/munitions/sac d'origine
removeAllWeapons player;
removeAllItems player;
removeBackpack player;

// Ajout des munitions
{
	player addMagazine _x;
} foreach _munitions;

// Ajout des armes
{
	player addWeapon _x;
} foreach _armes;

// Ajout des items
{
	player addWeapon _x;
} foreach _items;

// Si le joueur avait un sac à dos
if (!isNull _sac && !_respawn) then {

	private ["_type","_nbMunitionsSac","_nbArmesSac"];

	// Ajout du sac à dos
	_type = typeOf _sac;
	player addBackpack _type;
	_nouveauSac = unitBackpack player;
	
	// Nombre de munitions et d'armes dans le sac à dos
	_nbMunitionsSac = count(_munitionsSac select 0);
	_nbArmesSac = count(_armesSac select 0);
	
	// Ajout des munitions dans le sac à dos
	if (_nbMunitionsSac > 0) then {
		for [{_i = 0},{_i < _nbMunitionsSac},{_i = _i + 1}] do {
		   _nouveauSac addMagazineCargo [(_munitionsSac select 0) select _i,(_munitionsSac select 1) select _i];
		};
	};
	
	// Ajout des armes dans le sac à dos
	if (_nbArmesSac > 0) then {
		for [{_i = 0},{_i < _nbArmesSac},{_i = _i + 1}] do {
		   _nouveauSac addMagazineCargo [(_armesSac select 0) select _i,(_armesSac select 1) select _i];
		};
	};
};

// Arme principale sélectionnée
player selectWeapon (primaryWeapon player);
//player action ["SWITCHWEAPON", vehicle player, vehicle player, 0];

if (true) exitWith {};