/* =========================================================================================================
  Script Revive ADO : revive_respawn.sqf
  Version: 1.52
  Auteur: The-KiLLeR (www.clan-ado.fr / killouze@hotmail.fr)
========================================================================================================= */
/*
	ADO_REVIVE_statut
	ADO_REVIVE_joueur_%1

	0 = Rien
	1 = Attente réanimation
	2 = Réanimer
	3 = Trainer
	4 = Porter
*/

// Informations sur le cadavre
private ["_cadavre","_JoueurPos","_JoueurDir","_joueur"];
_cadavre = player;
_JoueurPos = getPosATL player;
_JoueurDir = getDir player;
_joueurCamp = playerSide;

cutText ["", "BLACK"];

// Attente de la réapparition du joueur
waitUntil { alive player };
_joueur = player;

// Vérification que tous le monde est mort
if (!ADO_REVIVE_zone && !ADO_REVIVE_mobile_respawn && !ADO_REVIVE_sac && !ADO_REVIVE_caisse) then {
	[] spawn {
		_liste = [];

		if (isMultiplayer) then {
			_liste = playableUnits;
		} else {
			_liste = allUnits;
		};
		_status = true;
		
		{
			if (call compile format["ADO_REVIVE_joueur_%1",_x] != 1) then {
				_status = false;
			};
		} forEach _liste;
		
		if (_status) then {
			ADO_REVIVE_tous_morts = true;
			publicVariable "ADO_REVIVE_tous_morts";	
		};
	};
};

// Si le joueur n'a plus de vie
if (ADO_REVIVE_vies_nb == 0) exitWith {

	private ["_corps","_croix","_camera"];

	ADO_REVIVE_morts = ADO_REVIVE_morts + [format["%1",_joueur]];
	publicVariable "ADO_REVIVE_morts";
	
	deleteVehicle _cadavre;
	_joueur setPos (getMarkerPos "ADO_REVIVE_zone_morts");
	sleep 0.5;
	_corps = "Grave" createVehicle _JoueurPos;
	_croix = "GraveCross1" createVehicle _JoueurPos;
	_corps setDir _JoueurDir;
	_croix attachTo [_corps,[0,0.9,0.3]];
	
	// Caméra sur la tombe
	_camera = "camera" camCreate (getPos _corps);
	_camera camSetTarget _corps;
	_camera cameraEffect ["internal","FRONT"];
	_camera camCommit 0;
	_camera attachTo [_corps, [0,-2.5,1]];
	cutText ["", "PLAIN"];
	
	player groupChat "Vous êtes mort";
};

// Si le joueur était dans l'eau
if (surfaceIsWater _JoueurPos) then {

	_posCentre = getMarkerPos "ADO_REVIVE_centre";
	_pos1 = ((_posCentre select 0) - (_JoueurPos select 0))/30;
	_pos2 = ((_posCentre select 1) - (_JoueurPos select 1))/30;
	_i = 1;
	
	while {true} do {

		if (!surfaceIsWater [(_JoueurPos select 0) + (_pos1 * _i), (_JoueurPos select 1) + (_pos2 * _i),0]) exitWith {
			player setPos [(_JoueurPos select 0) + (_pos1 * _i), (_JoueurPos select 1) + (_pos2 * _i),0];
		};
		_i = _i + 1;
		sleep 0.1;
	};

	_JoueurPos = getPosATL player;
};

// Animation blessé
_joueur switchMove "AinjPpneMstpSnonWrflDnon";
_joueur setDamage 0.5;
call compile format["ADO_REVIVE_joueur_%1 = 1; publicVariable 'ADO_REVIVE_joueur_%1'",player];

// Actions sur le joueur
call compile format ["%1 setVehicleInit '%1 = this; %1_action_reanimer = this addAction [''<t color=''''#e56b11''''>Réanimer</a>'',''ADO_revive\revive_actions.sqf'',2,1,false,true,'''',''call compile format[''''ADO_REVIVE_joueur_%1'''',%1] == 1'']; %1_action_trainer = this addAction [''<t color=''''#e5ac11''''>Trainer le corps</t>'',''ADO_revive\revive_actions.sqf'',3,1,false,true,'''',''call compile format[''''ADO_REVIVE_joueur_%1'''',%1] == 1'']; %1_action_porter = this addAction [''<t color=''''#e5ac11''''>Porter le corps</t>'',''ADO_revive\revive_actions.sqf'',4,1,false,true,'''',''call compile format[''''ADO_REVIVE_joueur_%1'''',%1] == 1'']; this allowDamage false; this setCaptive true;'",_joueur];
processInitCommands;

call compile format["%1 removeAction %1_action_reanimer; %1 removeAction %1_action_trainer; %1 removeAction %1_action_porter;",_joueur];
processInitCommands;

sleep 2;
deleteVehicle _cadavre;
sleep 0.1;
_joueur setPos _JoueurPos;
_joueur setDir _JoueurDir;

cutText ["", "PLAIN"];
_joueur groupChat "Vous êtes en attente de réanimation";

// Temps avant d'activer les boutons
if (ADO_REVIVE_zone || (ADO_REVIVE_mobile_respawn && ADO_REVIVE_mobile_respawn_nb > 0) || (ADO_REVIVE_sac && ADO_REVIVE_sac_nb > 0) || (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb > 0)) then {
	[] spawn
	{
		for [{_i = ADO_REVIVE_temps_bouton},{_i > 0},{_i = _i - 1}] do {
		
			if (call compile format["ADO_REVIVE_joueur_%1",player] == 0 || !alive player) exitWith {closeDialog 0;};

			hintSilent parseText format["Temps d'attente :<br/><t size='1.5' color='#ffe400'>%1s</t>",_i];
			sleep 1;
		};
		hintSilent format["",_i];
		
		if (call compile format["ADO_REVIVE_joueur_%1",player] == 0 || !alive player) exitWith {closeDialog 0;};
		
		ADO_REVIVE_dialog = true;
		closeDialog 0;
	};
};

_boutonBase = objNull;
_boutonMobile1 = objNull;
_boutonMobile2 = objNull;
_boutonSac1 = objNull;
_boutonSac2 = objNull;
_boutonCamp1 = objNull;
_boutonCamp2 = objNull;

// En attente de réanimation
while {call compile format["ADO_REVIVE_joueur_%1",_joueur] != 0} do {
	
	_joueurStatut = call compile format["ADO_REVIVE_joueur_%1",_joueur];
	if (_joueurStatut == 0 || ADO_REVIVE_bouton_base || ADO_REVIVE_bouton_mobile1 || ADO_REVIVE_bouton_mobile2 || ADO_REVIVE_bouton_sac1 || ADO_REVIVE_bouton_sac2 || ADO_REVIVE_bouton_camp1 || ADO_REVIVE_bouton_camp2 || !alive _joueur) exitWith {
		_boutonBase ctrlEnable false;
		_boutonMobile1 ctrlEnable false;
		_boutonMobile2 ctrlEnable false;
		_boutonSac1 ctrlEnable false;
		_boutonSac2 ctrlEnable false;
		_boutonCamp1 ctrlEnable false;
		_boutonCamp2 ctrlEnable false;
	};

	if ((ADO_REVIVE_zone || ADO_REVIVE_mobile_respawn || ADO_REVIVE_sac || ADO_REVIVE_caisse) && !dialog) then {
		_dialog = createDialog "ADO_REVIVE_dialog";
		
		disableSerialization;
		_dialog = findDisplay 68300;
		
		_boutonBase = _dialog displayCtrl 68330;
		_boutonMobile1 = _dialog displayCtrl 68340;
		_boutonMobile2 = _dialog displayCtrl 68350;
		_boutonSac1 = _dialog displayCtrl 68360;
		_boutonSac2 = _dialog displayCtrl 68370;
		_boutonCamp1 = _dialog displayCtrl 68380;
		_boutonCamp2 = _dialog displayCtrl 68390;
		
		if (!ADO_REVIVE_mobile_respawn || ADO_REVIVE_mobile_respawn_nb == 0) then {
			
			if (!ADO_REVIVE_sac || ADO_REVIVE_sac_nb == 0) then {
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.78];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.78];
					_boutonCamp2 ctrlSetPosition [0.8, 0.84];
				};
			};
			if (ADO_REVIVE_sac && ADO_REVIVE_sac_nb == 1) then {
				_boutonSac1 ctrlSetPosition [0.8, 0.78];
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.84];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.84];
					_boutonCamp2 ctrlSetPosition [0.8, 0.9];
				};
			};
			if (ADO_REVIVE_sac && ADO_REVIVE_sac_nb == 2) then {
				_boutonSac1 ctrlSetPosition [0.8, 0.78];
				_boutonSac2 ctrlSetPosition [0.8, 0.84];
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.9];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.9];
					_boutonCamp2 ctrlSetPosition [0.8, 0.96];
				};
			};
			_boutonSac1 ctrlCommit 0;
			_boutonSac2 ctrlCommit 0;
			_boutonCamp1 ctrlCommit 0;
			_boutonCamp2 ctrlCommit 0;
		};
		if (ADO_REVIVE_mobile_respawn && ADO_REVIVE_mobile_respawn_nb == 1) then {
			if (!ADO_REVIVE_sac || ADO_REVIVE_sac_nb == 0) then {
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.84];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.84];
					_boutonCamp2 ctrlSetPosition [0.8, 0.9];
				};
			};
			if (ADO_REVIVE_sac && ADO_REVIVE_sac_nb == 1) then {
				_boutonSac1 ctrlSetPosition [0.8, 0.84];
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.9];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.9];
					_boutonCamp2 ctrlSetPosition [0.8, 0.96];
				};
			};
			if (ADO_REVIVE_sac && ADO_REVIVE_sac_nb == 2) then {
				_boutonSac1 ctrlSetPosition [0.8, 0.84];
				_boutonSac2 ctrlSetPosition [0.8, 0.9];
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.96];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.96];
					_boutonCamp2 ctrlSetPosition [0.8, 1.02];
				};
			};
			_boutonCamp1 ctrlCommit 0;
			_boutonCamp2 ctrlCommit 0;
			_boutonSac1 ctrlCommit 0;
			_boutonSac2 ctrlCommit 0;
		};
		if (ADO_REVIVE_mobile_respawn && ADO_REVIVE_mobile_respawn_nb == 2) then {
			if (!ADO_REVIVE_sac || ADO_REVIVE_sac_nb == 0) then {
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.9];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.9];
					_boutonCamp2 ctrlSetPosition [0.8, 0.96];
				};
			};
			if (ADO_REVIVE_sac && ADO_REVIVE_sac_nb == 1) then {
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 1) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.96];
				};
				if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb == 2) then {
					_boutonCamp1 ctrlSetPosition [0.8, 0.96];
					_boutonCamp2 ctrlSetPosition [0.8, 1.02];
				};
			};
			_boutonCamp1 ctrlCommit 0;
			_boutonCamp2 ctrlCommit 0;
		};
		
		if (ADO_REVIVE_dialog && (ADO_REVIVE_vies_nb != 0)) then {
			_boutonBase ctrlEnable true;
			_boutonMobile1 ctrlEnable true;
			_boutonMobile2 ctrlEnable true;
			_boutonSac1 ctrlEnable true;
			_boutonSac2 ctrlEnable true;
			_boutonCamp1 ctrlEnable true;
			_boutonCamp2 ctrlEnable true;
		} else {
			_boutonBase ctrlEnable false;
			_boutonMobile1 ctrlEnable false;
			_boutonMobile2 ctrlEnable false;
			_boutonSac1 ctrlEnable false;
			_boutonSac2 ctrlEnable false;
			_boutonCamp1 ctrlEnable false;
			_boutonCamp2 ctrlEnable false;
		};

		if (!ADO_REVIVE_zone) then {
			_boutonBase ctrlShow false;
		};	
		if (!ADO_REVIVE_mobile_respawn || ADO_REVIVE_mobile_respawn_nb == 0) then {
			_boutonMobile1 ctrlShow false;
			_boutonMobile2 ctrlShow false;
		} else {
			if (ADO_REVIVE_mobile_respawn_nb == 1) then {
				_boutonMobile2 ctrlShow false;
			};
		};
		if (!ADO_REVIVE_sac || ADO_REVIVE_sac_nb == 0) then {
			_boutonSac1 ctrlShow false;
			_boutonSac2 ctrlShow false;
		} else {
			if (ADO_REVIVE_sac_nb == 1) then {
				_boutonSac2 ctrlShow false;
			};
		};
		if (!ADO_REVIVE_caisse || ADO_REVIVE_caisse_nb == 0) then {
			_boutonCamp1 ctrlShow false;
			_boutonCamp2 ctrlShow false;
		} else {
			if (ADO_REVIVE_caisse_nb == 1) then {
				_boutonCamp2 ctrlShow false;
			};
		};
	};
	
	switch (_joueurStatut) do {
		// Attente de réanimation
		case 1 : {
			if (animationState _joueur != "AinjPpneMstpSnonWrflDnon") then {
				_joueur playMove "AinjPpneMstpSnonWrflDnon";
			};
			if (ADO_REVIVE_dialog && (ADO_REVIVE_vies_nb != 0)) then {
				_boutonBase ctrlEnable true;
				_boutonMobile1 ctrlEnable true;
				_boutonMobile2 ctrlEnable true;
				_boutonSac1 ctrlEnable true;
				_boutonSac2 ctrlEnable true;
				_boutonCamp1 ctrlEnable true;
				_boutonCamp2 ctrlEnable true;
			};
		};
		// Réanimer
		case 2 : {
			if (animationState _joueur != "AinjPpneMstpSnonWrflDnon") then {
				_joueur playMove "AinjPpneMstpSnonWrflDnon";
			};
			if (ADO_REVIVE_dialog) then {
				_boutonBase ctrlEnable false;
				_boutonMobile1 ctrlEnable false;
				_boutonMobile2 ctrlEnable false;
				_boutonSac1 ctrlEnable false;
				_boutonSac2 ctrlEnable false;
				_boutonCamp1 ctrlEnable false;
				_boutonCamp2 ctrlEnable false;
			};
		};
		// Trainer
		case 3 : {
			if (animationState _joueur != "ainjppnemstpsnonwrfldb_still") then {
				_joueur switchMove "ainjppnemstpsnonwrfldb_still";
			};
			if (ADO_REVIVE_dialog) then {
				_boutonBase ctrlEnable false;
				_boutonMobile1 ctrlEnable false;
				_boutonMobile2 ctrlEnable false;
				_boutonSac1 ctrlEnable false;
				_boutonSac2 ctrlEnable false;
				_boutonCamp1 ctrlEnable false;
				_boutonCamp2 ctrlEnable false;
			};
		};
		// Porter
		case 4 : {
			if (animationState _joueur != "ainjpfalmstpsnonwrfldnon_carried_up" && animationState _joueur != "AinjPfalMstpSnonWrflDnon_carried_still") then {
				_joueur switchMove "AinjPfalMstpSnonWrflDnon_carried_still";
			};
			if (ADO_REVIVE_dialog) then {
				_boutonBase ctrlEnable false;
				_boutonMobile1 ctrlEnable false;
				_boutonMobile2 ctrlEnable false;
				_boutonSac1 ctrlEnable false;
				_boutonSac2 ctrlEnable false;
				_boutonCamp1 ctrlEnable false;
				_boutonCamp2 ctrlEnable false;
			};
		};
	};
	
	// Si mobile détruit
	if (ADO_REVIVE_mobile_respawn && ADO_REVIVE_mobile_respawn_nb != 0 && ADO_REVIVE_dialog && _joueurStatut == 1) then {
		
		if (!alive ado_mobile_respawn_1) then {
			_boutonMobile1 ctrlEnable false;
		} else {
			if (ADO_REVIVE_vies_nb != 0) then {_boutonMobile1 ctrlEnable true;};
		};
		
		if (ADO_REVIVE_mobile_respawn_nb == 2) then {
			if (!alive ado_mobile_respawn_2) then {
				_boutonMobile2 ctrlEnable false;
			} else {
				if (ADO_REVIVE_vies_nb != 0) then {_boutonMobile2 ctrlEnable true;};		
			};
		};
	};
	
	// Si sac détruit
	if (ADO_REVIVE_sac && ADO_REVIVE_sac_nb != 0 && ADO_REVIVE_dialog && _joueurStatut == 1) then {
		
		if (!alive ado_sac_respawn_1 || typeOf ado_sac_respawn_1 == ADO_REVIVE_sac_type1) then {
			_boutonSac1 ctrlEnable false;
		} else {
			if (ADO_REVIVE_vies_nb != 0) then {_boutonSac1 ctrlEnable true;};	
		};
		
		if (ADO_REVIVE_sac_nb == 2) then {
			if (!alive ado_sac_respawn_2 || typeOf ado_sac_respawn_2 == ADO_REVIVE_sac_type2) then {
				_boutonSac2 ctrlEnable false;
			} else {
				if (ADO_REVIVE_vies_nb != 0) then {_boutonSac2 ctrlEnable true;};	
			};
		};
	};
	
		// Si caisse détruit
	if (ADO_REVIVE_caisse && ADO_REVIVE_caisse_nb != 0 && ADO_REVIVE_dialog && _joueurStatut == 1) then {
		
		if (!alive ado_caisse_respawn_1 || ADO_REVIVE_caisse_statut1 != 3) then {
			_boutonCamp1 ctrlEnable false;
		} else {
			if (ADO_REVIVE_vies_nb != 0) then {_boutonCamp1 ctrlEnable true;};	
		};
		
		if (ADO_REVIVE_caisse_nb == 2) then {
			if (!alive ado_caisse_respawn_2 || ADO_REVIVE_caisse_statut2 != 3) then {
				_boutonCamp2 ctrlEnable false;
			} else {
				if (ADO_REVIVE_vies_nb != 0) then {_boutonCamp2 ctrlEnable true;};	
			};
		};
	};	

	sleep 1;
};

call compile format["%1 setVehicleInit '%1 = this; this removeAction %1_action_reanimer; this removeAction %1_action_trainer; this removeAction %1_action_porter; this removeAction %1_action_lacher;'",_joueur];
processInitCommands;

if (!alive _joueur) exitWith {
	closeDialog 0;
	call compile format["ADO_REVIVE_joueur_%1 = 0; publicVariable 'ADO_REVIVE_joueur_%1'",player];
	call compile format["ADO_REVIVE_medic_%1 = 0; publicVariable 'ADO_REVIVE_medic_%1'",player];
	ADO_REVIVE_bouton_base = false;
	ADO_REVIVE_bouton_mobile1 = false;
	ADO_REVIVE_bouton_mobile2 = false;
	ADO_REVIVE_bouton_sac1 = false;
	ADO_REVIVE_bouton_sac2 = false;
	ADO_REVIVE_bouton_camp1 = false;
	ADO_REVIVE_bouton_camp2 = false;
	ADO_REVIVE_dialog = false;
	ADO_REVIVE_annulerAction = false;
};

// Si réapparition à la base
if (ADO_REVIVE_bouton_base) then {

	cutText ["", "BLACK"];
	sleep 5;
	
	if (ADO_REVIVE_vies_nb != -1) then {
		ADO_REVIVE_vies_nb = ADO_REVIVE_vies_nb - 1;
		hint parseText format["Vies restantes : <t color='#ffe400'>%1</t>",ADO_REVIVE_vies_nb];
	};

	_joueur switchMove "";
	_joueur setDamage 0;

	_zone = switch (_joueurCamp) do {
		case WEST : {ADO_REVIVE_zone_ouest};
		case EAST : {ADO_REVIVE_zone_est};
		case RESISTANCE : {ADO_REVIVE_zone_independant};
		case CIV : {ADO_REVIVE_zone_civil};
	};
	
	if (ADO_REVIVE_zone_hauteur != 0) then {
		_joueur setPos [(getMarkerPos _zone) select 0,(getMarkerPos _zone) select 1,ADO_REVIVE_zone_hauteur];
	} else {
		_joueur setPos (getMarkerPos _zone);
	};
	
	_joueur groupChat "Vous avez réapparu à la base";

	cutText ["", "PLAIN"];
};

// Si réapparition au mobile respawn
if (ADO_REVIVE_bouton_mobile1 || ADO_REVIVE_bouton_mobile2) then {
	
	cutText ["", "BLACK"];
	sleep 5;
	
	if (ADO_REVIVE_vies_nb != -1) then {
		ADO_REVIVE_vies_nb = ADO_REVIVE_vies_nb - 1;
		hint parseText format["Vies restantes : <t color='#ffe400'>%1</t>",ADO_REVIVE_vies_nb];
	};
	
	if (call compile format["ADO_REVIVE_medic_%1",player] == 1) then {
		_joueur setDamage 0;
	} else {
		_joueur setDamage 0.5;
		_joueur setHit ["hands", 1];
		_joueur setHit ["legs", 0.6];
	};
	
	_mobilePos = [];
	_mobileDir = 0;
	
	if (ADO_REVIVE_bouton_mobile1) then {
		_mobilePos = getPosATL ado_mobile_respawn_1;
		_mobileDir = getDir ado_mobile_respawn_1;
		_joueur groupChat "Vous avez réapparu au mobile respawn 1";
	};
	if (ADO_REVIVE_bouton_mobile2) then {
		_mobilePos = getPosATL ado_mobile_respawn_2;
		_mobileDir = getDir ado_mobile_respawn_2;
		player groupChat "Vous avez réapparu au mobile respawn 2";
	};
	
	_joueur setPos [(_mobilePos select 0)+(-5*sin _mobileDir), (_mobilePos select 1)+(-5*cos _mobileDir), 0];
	_joueur switchMove "";
	
	cutText ["", "PLAIN"];
};

// Si réapparition à la tente
if (ADO_REVIVE_bouton_sac1 || ADO_REVIVE_bouton_sac2) then {
	
	cutText ["", "BLACK"];
	sleep 5;
	
	if (ADO_REVIVE_vies_nb != -1) then {
		ADO_REVIVE_vies_nb = ADO_REVIVE_vies_nb - 1;
		hint parseText format["Vies restantes : <t color='#ffe400'>%1</t>",ADO_REVIVE_vies_nb];
	};
	
	if (call compile format["ADO_REVIVE_medic_%1",player] == 1) then {
		_joueur setDamage 0;
	} else {
		_joueur setDamage 0.5;
		_joueur setHit ["hands", 1];
		_joueur setHit ["legs", 0.6];
	};
	
	_mobilePos = [];
	_mobileDir = 0;
	
	if (ADO_REVIVE_bouton_sac1) then {
		_mobilePos = getPosATL ado_sac_respawn_1;
		_mobileDir = getDir ado_sac_respawn_1;
		_joueur groupChat "Vous avez réapparu à la tente 1";
	};
	if (ADO_REVIVE_bouton_sac2) then {
		_mobilePos = getPosATL ado_sac_respawn_2;
		_mobileDir = getDir ado_sac_respawn_2;
		player groupChat "Vous avez réapparu à la tente 2";
	};
	
	_joueur setPos [(_mobilePos select 0)+(2*sin _mobileDir), (_mobilePos select 1)+(2*cos _mobileDir), _mobilePos select 2];
	_joueur switchMove "";
	
	cutText ["", "PLAIN"];
};

// Si réapparition au camp
if (ADO_REVIVE_bouton_camp1 || ADO_REVIVE_bouton_camp2) then {
	
	cutText ["", "BLACK"];
	sleep 5;
	
	if (ADO_REVIVE_vies_nb != -1) then {
		ADO_REVIVE_vies_nb = ADO_REVIVE_vies_nb - 1;
		hint parseText format["Vies restantes : <t color='#ffe400'>%1</t>",ADO_REVIVE_vies_nb];
	};
	
	if (call compile format["ADO_REVIVE_medic_%1",player] == 1) then {
		_joueur setDamage 0;
	} else {
		_joueur setDamage 0.5;
		_joueur setHit ["hands", 1];
		_joueur setHit ["legs", 0.6];
	};
	
	_mobilePos = [];
	_mobileDir = 0;
	
	if (ADO_REVIVE_bouton_camp1) then {
		_mobilePos = getPosATL ado_caisse_respawn_1;
		_mobileDir = getDir ado_caisse_respawn_1;
		_joueur groupChat "Vous avez réapparu au camp 1";
	};
	if (ADO_REVIVE_bouton_camp2) then {
		_mobilePos = getPosATL ado_caisse_respawn_2;
		_mobileDir = getDir ado_caisse_respawn_2;
		player groupChat "Vous avez réapparu au camp 2";
	};
	
	_joueur setPos [(_mobilePos select 0)+(4*sin _mobileDir)+(2*cos _mobileDir), (_mobilePos select 1)+(4*cos _mobileDir)-(2*sin _mobileDir), _mobilePos select 2];
	_joueur switchMove "";
	
	cutText ["", "PLAIN"];
};

// Si réapparition sur place
if (!ADO_REVIVE_bouton_base && !ADO_REVIVE_bouton_mobile1 && !ADO_REVIVE_bouton_mobile2 && !ADO_REVIVE_bouton_sac1 && !ADO_REVIVE_bouton_sac2) then {
	
	if (ADO_REVIVE_vies_nb != -1 && ADO_REVIVE_vies_reanimer) then {
		ADO_REVIVE_vies_nb = ADO_REVIVE_vies_nb - 1;
		hint parseText format["Vies restantes : <t color='#ffe400'>%1</t>",ADO_REVIVE_vies_nb];
	};
	
	_joueur playMove "amovppnemstpsraswrfldnon";
	
	if (call compile format["ADO_REVIVE_medic_%1",player] == 1) then {
		_joueur setDamage 0;
	} else {
		_joueur setDamage 0.5;
		_joueur setHit ["hands", 1];
		_joueur setHit ["legs", 0.6];
	};
};

call compile format["%1 setVehicleInit '%1 = this; this allowDamage true; this setCaptive false;'",_joueur];
processInitCommands;

// Initalisation des variables
closeDialog 0;
call compile format["ADO_REVIVE_joueur_%1 = 0; publicVariable 'ADO_REVIVE_joueur_%1'",player];
call compile format["ADO_REVIVE_medic_%1 = 0; publicVariable 'ADO_REVIVE_medic_%1'",player];
ADO_REVIVE_bouton_base = false;
ADO_REVIVE_bouton_mobile1 = false;
ADO_REVIVE_bouton_mobile2 = false;
ADO_REVIVE_bouton_sac1 = false;
ADO_REVIVE_bouton_sac2 = false;
ADO_REVIVE_bouton_camp1 = false;
ADO_REVIVE_bouton_camp2 = false;
ADO_REVIVE_dialog = false;
ADO_REVIVE_annulerAction = false;

if (true) exitWith {};