// 18:29:50 08/12/10 
// Kamil Kornowski
// kkamelot@wp.pl
// ver 1.0
// NO radar in vehicles

class CfgPatches {
	class B9_noradar {
		units[] = {};
		weapons[] = {};
		requiredVersion = 1.14;
		requiredAddons[] = {"CAData", "CATracked", "CAWheeled", "CAWheeled3", "CAAir", "CAAir3", "CAA10", "CAAir3_Su34", "CAWeapons", "CAWeapons3", "CASounds", "CA_Hotfix"};
	};
};


class CfgAISkill {
	aimingAccuracy[] = {0, 0, 1, 0.8};
	aimingShake[] = {0, 0, 1, 0.7};
	aimingSpeed[] = {0, 0.4, 1, 0.8};
	endurance[] = {0, 0, 1, 1};
	spotDistance[] = {0, 0.6, 1, 0.8};
	spotTime[] = {0, 0.5, 1, 1};
	courage[] = {0, 0, 1, 1};
	reloadSpeed[] = {0, 0, 1, 1};
	commanding[] = {0, 0, 1, 1};
	general[] = {0, 0, 1, 1};
};

class CfgVehicles {
	class All{
	};	// External class reference
	
	class AllVehicles : All {
		class NewTurret {
			maxHorizontalRotSpeed = 0.8;
			maxVerticalRotSpeed = 0.8;
		}	
	}
	
	class Land;
	
	class LandVehicle : Land {
	};
	
	class Tank: LandVehicle {
		// #define CanSeeEye 2
		// #define CanSeeOptics 4
		// #define CanSeeEar 8
		// #define CanSeeCompass 16 
		// #define CanSeeAll 31
		commanderCanSee=2+4+8+16;
		gunnerCanSee=2+4+8+16;
		driverCanSee=2+8+16;
		sensitivity=4;
	};
	
	class car: LandVehicle {		
	};
	class HMMWV50 : Car {};
	class HMMWVTOW : HMMWV50 {
		commanderCanSee = 30;
		gunnerCanSee = 30;
	}
	class StrykerBase : Car {
		commanderCanSee = 30;
		gunnerCanSee = 30;
		sensitivity=3;
	}	
	class BRDM2 : Car {
		commanderCanSee = 30;
		gunnerCanSee = 30;
		sensitivity=3;
	}	
};