//////////////////////////////////////////////////////////////////
// AWACS System for Project RACS
// Created by: [GLT]Myke
//////////////////////////////////////////////////////////////////
if (isnil "PRACS_AWACS_MAX_RANGE") then {PRACS_AWACS_MAX_RANGE = 5000};
if (isnil "PRACS_AWACS_RECON_RANGE") then {PRACS_AWACS_RECON_RANGE = PRACS_AWACS_MAX_RANGE / 2};
if (isnil "PRACS_AWACS_MIN_FLIGHTLEVEL") then {PRACS_AWACS_MIN_FLIGHTLEVEL = 500};
if (isnil "PRACS_AWACS_SCAN_FREQ") then {PRACS_AWACS_SCAN_FREQ = PRACS_AWACS_RECON_RANGE / 500};
if (isnil "PRACS_AWACS_SHOW_FRIENDLY") then {PRACS_AWACS_SHOW_FRIENDLY = true};
if (isnil "PRACS_AWACS_SHOW_NEUTRALS") then {PRACS_AWACS_SHOW_NEUTRALS = true};
if (isnil "PRACS_AWACS_SHOW_STATIONARY") then {PRACS_AWACS_SHOW_STATIONARY = true};
if (isnil "PRACS_AWACS_ENEMY_SIDES") then {PRACS_AWACS_ENEMY_SIDES = [WEST, EAST]};
if (isnil "PRACS_AWACS_NEUTRAL_SIDES") then {PRACS_AWACS_NEUTRAL_SIDES = [Resistance, Civilian]};
if (isnil "PRACS_AWACS_SHOW_STATS") then {PRACS_AWACS_SHOW_STATS = true};
if (isnil "PRACS_AWACS_STATE") then {PRACS_AWACS_STATE = false};
if (isnil "PRACS_AWACS_DATA_UPLINK") then {PRACS_AWACS_DATA_UPLINK = true};
_PRACS_AWACS_PLANE = _this select 0;
_PRACS_AWACS_TOTAL_COUNT = 0;
_PRACS_AWACS_UNKNOWN_COUNT = 0;
_PRACS_AWACS_ENEMY_COUNT = 0;
_PRACS_AWACS_FRIENDLY_COUNT = 0;
_PRACS_AWACS_NEUTRAL_COUNT = 0;
_PRACS_AST = "";
_PRACS_AET = "";
_PRACS_AFT = "";
_PRACS_ANT = "";
_PRACS_AUT = "";
_PRACS_ATT = "";
while {!isnull _PRACS_AWACS_PLANE} do {
	_PRACS_AWACS_UNKNOWN_CONTACTS = [];
	_PRACS_AWACS_ENEMY_CONTACTS = [];
	_PRACS_AWACS_NEUTRAL_CONTACTS = [];
	_PRACS_AWACS_FRIENDLY_CONTACTS = [];
	_PRACS_AWACS_DRIVERSTATE = (isPlayer (driver _PRACS_AWACS_PLANE));
	_PRACS_AWACS_ENGINESTATE = (isEngineOn _PRACS_AWACS_PLANE);
	_PRACS_AWACS_FLIGHTLEVEL = (getposASL _PRACS_AWACS_PLANE select 2 > PRACS_AWACS_MIN_FLIGHTLEVEL);
	if (_PRACS_AWACS_DRIVERSTATE && _PRACS_AWACS_ENGINESTATE && _PRACS_AWACS_FLIGHTLEVEL && PRACS_AWACS_STATE) then {
		_PRACS_ENEMY_SIDES = PRACS_AWACS_ENEMY_SIDES - [side (driver _PRACS_AWACS_PLANE)];
		_PRACS_NEUTRAL_SIDES = PRACS_AWACS_NEUTRAL_SIDES - [side (driver _PRACS_AWACS_PLANE)];
		_PRACS_AWACS_MARKERS = [];
		_PRACS_AWACS_CONTACTS = nearestObjects [_PRACS_AWACS_PLANE, ["Air", "LandVehicle", "Ship"], PRACS_AWACS_MAX_RANGE];
		_PRACS_AWACS_CONTACTS = _PRACS_AWACS_CONTACTS - [_PRACS_AWACS_PLANE];
		{
			if (!isengineon _x) then {_PRACS_AWACS_CONTACTS = _PRACS_AWACS_CONTACTS - [_x]};
		}
		foreach _PRACS_AWACS_CONTACTS;
		if (!PRACS_AWACS_SHOW_STATIONARY) then {
			{
				if (speed _x == 0) then {_PRACS_AWACS_CONTACTS = _PRACS_AWACS_CONTACTS - [_x]};
			}
			foreach _PRACS_AWACS_CONTACTS;
		};
		_PRACS_AWACS_TOTAL_COUNT = count _PRACS_AWACS_CONTACTS;
		{
			if ((_x distance [getPos _PRACS_AWACS_PLANE select 0, getPos _PRACS_AWACS_PLANE select 1, 0]) > PRACS_AWACS_RECON_RANGE) then {
				_PRACS_AWACS_UNKNOWN_CONTACTS = _PRACS_AWACS_UNKNOWN_CONTACTS + [_x];
				_PRACS_AWACS_CONTACTS = _PRACS_AWACS_CONTACTS - [_x];
			};
		}
		foreach _PRACS_AWACS_CONTACTS;
		{
			if ((side _x) in _PRACS_ENEMY_SIDES) then {
				_PRACS_AWACS_ENEMY_CONTACTS = _PRACS_AWACS_ENEMY_CONTACTS + [_x];
				_PRACS_AWACS_CONTACTS = _PRACS_AWACS_CONTACTS - [_x];
			};
		}
		foreach _PRACS_AWACS_CONTACTS;
		{
			if ((side _x) in _PRACS_NEUTRAL_SIDES) then {
				_PRACS_AWACS_NEUTRAL_CONTACTS = _PRACS_AWACS_NEUTRAL_CONTACTS + [_x];
				_PRACS_AWACS_CONTACTS = _PRACS_AWACS_CONTACTS - [_x];
			};
		}
		foreach _PRACS_AWACS_CONTACTS;
		_PRACS_AWACS_FRIENDLY_CONTACTS = _PRACS_AWACS_CONTACTS;
		_PRACS_AWACS_UNKNOWN_COUNT = count _PRACS_AWACS_UNKNOWN_CONTACTS;
		_PRACS_AWACS_ENEMY_COUNT = count _PRACS_AWACS_ENEMY_CONTACTS;
		_PRACS_AWACS_FRIENDLY_COUNT = count _PRACS_AWACS_FRIENDLY_CONTACTS;
		_PRACS_AWACS_NEUTRAL_COUNT = count _PRACS_AWACS_NEUTRAL_CONTACTS;
		{
			_PRACS_AWACS_MARKERNAME = format ["%1", _x];
			_PRACS_AWACS_MARKER = createMarker [_PRACS_AWACS_MARKERNAME,(position _x)];
			_PRACS_AWACS_MARKER setMarkerShape "ICON";
			_PRACS_AWACS_MARKERNAME setMarkerSize [0.5, 0.5];
			_PRACS_AWACS_MARKERNAME setMarkerType "Vehicle";
			_PRACS_AWACS_MARKERNAME setMarkerColor "ColorBlue";
			_PRACS_AWACS_MARKERNAME setMarkerText "";
			_PRACS_AWACS_MARKERS = _PRACS_AWACS_MARKERS + [_PRACS_AWACS_MARKERNAME];
		}
		foreach _PRACS_AWACS_UNKNOWN_CONTACTS;
		{
			_PRACS_AWACS_MARKERNAME = format ["%1", _x];
			_PRACS_AWACS_MARKER = createMarker [_PRACS_AWACS_MARKERNAME,(position _x)];
			_PRACS_AWACS_MARKER setMarkerShape "ICON";
			_PRACS_AWACS_MARKERNAME setMarkerSize [0.5, 0.5];
			_PRACS_AWACS_MARKERNAME setMarkerType "Vehicle";
			_PRACS_AWACS_MARKERNAME setMarkerColor "ColorRed";
			_PRACS_AWACS_MARKERNAME setMarkerText format ["%1", typeof _x];
			_PRACS_AWACS_MARKERS = _PRACS_AWACS_MARKERS + [_PRACS_AWACS_MARKERNAME];
		}
		foreach _PRACS_AWACS_ENEMY_CONTACTS;
		if (PRACS_AWACS_SHOW_NEUTRALS) then {
			{
				_PRACS_AWACS_MARKERNAME = format ["%1", _x];
				_PRACS_AWACS_MARKER = createMarker [_PRACS_AWACS_MARKERNAME,(position _x)];
				_PRACS_AWACS_MARKER setMarkerShape "ICON";
				_PRACS_AWACS_MARKERNAME setMarkerSize [0.5, 0.5];
				_PRACS_AWACS_MARKERNAME setMarkerType "Vehicle";
				_PRACS_AWACS_MARKERNAME setMarkerColor "ColorYellow";
				_PRACS_AWACS_MARKERNAME setMarkerText format ["%1", typeof _x];
				_PRACS_AWACS_MARKERS = _PRACS_AWACS_MARKERS + [_PRACS_AWACS_MARKERNAME];
			}
			foreach _PRACS_AWACS_NEUTRAL_CONTACTS;
		};
		if (PRACS_AWACS_SHOW_FRIENDLY) then {
			{
				_PRACS_AWACS_MARKERNAME = format ["%1", _x];
				_PRACS_AWACS_MARKER = createMarker [_PRACS_AWACS_MARKERNAME,(position _x)];
				_PRACS_AWACS_MARKER setMarkerShape "ICON";
				_PRACS_AWACS_MARKERNAME setMarkerSize [0.5, 0.5];
				_PRACS_AWACS_MARKERNAME setMarkerType "Vehicle";
				_PRACS_AWACS_MARKERNAME setMarkerColor "ColorGreen";
				_PRACS_AWACS_MARKERNAME setMarkerText format ["%1", typeof _x];
				_PRACS_AWACS_MARKERS = _PRACS_AWACS_MARKERS + [_PRACS_AWACS_MARKERNAME];
			}
			foreach _PRACS_AWACS_FRIENDLY_CONTACTS;
		};
		
		if (PRACS_AWACS_DATA_UPLINK) then {
			{
				_PRACS_TEMP_VAR = _x;
				{
					_x reveal _PRACS_TEMP_VAR;
				}
				foreach _PRACS_AWACS_FRIENDLY_CONTACTS;
			}
			foreach _PRACS_AWACS_ENEMY_CONTACTS;
		};
		
		if (PRACS_AWACS_SHOW_STATS) then {
			_PRACS_AST = "AWACS SYSTEM ACTIVE";
			if (_PRACS_AWACS_ENEMY_COUNT == 0) then {_PRACS_AET = "NO HOSTILE CONTACTS."} else {_PRACS_AET = format ["HOSTILE CONTACTS: %1", _PRACS_AWACS_ENEMY_COUNT]};
			if (_PRACS_AWACS_FRIENDLY_COUNT == 0) then {_PRACS_AFT = "NO FRIENDLY CONTACTS."} else {_PRACS_AFT = format ["FRIENDLY CONTACTS: %1", _PRACS_AWACS_FRIENDLY_COUNT]};
			if (_PRACS_AWACS_NEUTRAL_COUNT == 0) then {_PRACS_ANT = "NO NEUTRAL CONTACTS."} else {_PRACS_ANT = format ["NEUTRAL CONTACTS: %1", _PRACS_AWACS_NEUTRAL_COUNT]};
			if (_PRACS_AWACS_UNKNOWN_COUNT == 0) then {_PRACS_AUT = "NO UNKNOWN CONTACTS."} else {_PRACS_AUT = format ["UNKNOWN CONTACTS: %1", _PRACS_AWACS_UNKNOWN_COUNT]};
			if (_PRACS_AWACS_TOTAL_COUNT == 0) then {_PRACS_ATT = "NO CONTACTS."} else {_PRACS_ATT = format ["TOTAL CONTACTS: %1", _PRACS_AWACS_TOTAL_COUNT]};
			_PRACS_AWACS_STATS_TEXT = format ["%1\n\n%2\n%3\n%4\n%5\n\n%6", _PRACS_AST, _PRACS_AET, _PRACS_AFT, _PRACS_ANT, _PRACS_AUT, _PRACS_ATT];
			hint _PRACS_AWACS_STATS_TEXT;
		};
		sleep PRACS_AWACS_SCAN_FREQ;
		{deletemarker _x}	foreach _PRACS_AWACS_MARKERS;
	} else {
		if (PRACS_AWACS_SHOW_STATS) then {
			_PRACS_AST = "AWACS SYSTEM INACTIVE";
			if (_PRACS_AWACS_DRIVERSTATE) then {_PRACS_AET = "PILOT IS PLAYER: OK."} else {_PRACS_AET = "PILOT IS PLAYER: FAILED!"};
			if (_PRACS_AWACS_ENGINESTATE) then {_PRACS_AFT = "ENGINE STATUS: OK."} else {_PRACS_AFT = "ENGINE STATUS: FAILED!"};
			if (_PRACS_AWACS_FLIGHTLEVEL) then {_PRACS_ANT = format ["FLIGHT LEVEL %1: OK.", PRACS_AWACS_MIN_FLIGHTLEVEL]} else {_PRACS_ANT = format ["FLIGHT LEVEL %1: FAILED!", PRACS_AWACS_MIN_FLIGHTLEVEL]};
			if (PRACS_AWACS_STATE) then {_PRACS_AUT = "AWACS SYSTEM ENABLED!"} else {_PRACS_AUT = "AWACS SYSTEM DISABLED!"};
			_PRACS_AWACS_STATS_TEXT = format ["%1\n\n%2\n%3\n%4\n%5", _PRACS_AST, _PRACS_AET, _PRACS_AFT, _PRACS_ANT, _PRACS_AUT];
			hint _PRACS_AWACS_STATS_TEXT;
		};
		sleep PRACS_AWACS_SCAN_FREQ;
	};
};