//Handy Tools Rope System. Rope attach configuration relative to vehicle

_veh = _this select 0;
_type = _this select 1;

_dir = getdir _veh;

_off1 = [0,0,0];
_inv1 = false;
_off2 = [0,0,0];
_inv2 = false;
_ropes = 1;

_dir1 = "front";
_dir2 = "front";

switch (_type) do {

////////////////////////////////////// BIS //////////////////////////////////////

	case "hawk_1c": {
	//blackhawk 1 rope cargo
		_off1 = [0, 1.45, -2.15];
		_dir1 = "front";
		_inv1 = true;

		_ropes = 1;

	};

	case "hawk_1l": {
	//blackhawk 1 rope left door
		_off1 = [-1.75, 2, -0.5];
		_dir1 = "left";
		_inv1 = false;

		_ropes = 1;

	};

	case "hawk_1r": {
	//blackhawk 1 rope right door

		_off1 = [1.75, 2, -0.5];
		_dir1 = "right";
		_inv1 = false;

		_ropes = 1;

	};

	case "hawk_2": {
	//blackhawk 2 ropes both doors

		_off1 = [-1.75, 2, -0.5];
		_dir1 = "left";
		_inv1 = false;

		_off2 = [1.75, 2, -0.5];
		_dir2 = "right";
		_inv2 = false;

		_ropes = 2;

	};

////////////////////////////////////// HWM Mod ///////////////////////////////////

	case "huey_1c": {
	//huey 1 rope cargo
		_off1 = [-0.22, 1.3, -1.8];
		_dir1 = "front";
		_inv1 = true;

		_ropes = 1;

	};

	case "huey_1l": {
	//huey 1 rope left door
		_off1 = [-1.9, 2.1, 0.09];
		_dir1 = "left";
		_inv1 = false;

		_ropes = 1;

	};

	case "huey_1r": {
	//huey 1 rope right door
		_off1 = [1.4, 2.1, 0.09];
		_dir1 = "right";
		_inv1 = false;

		_ropes = 1;

	};

	case "huey_2": {
	//huey 2 ropes both doors
		_off1 = [-1.9, 2.1, 0.09];
		_dir1 = "left";
		_inv1 = false;

		_off2 = [1.4, 2.1, 0.09];
		_dir2 = "right";
		_inv2 = false;

		_ropes = 2;

	};

////////////////////////////////////// FFAA Mod /////////////////////////////////

	case "chinook_1c": {
	//FAMET chinook 1 rope cargo
		_off1 = [0.15, 0, -2.1];
		_dir1 = "front";
		_inv1 = true;

		_ropes = 1;

	};

	case "chinook_2c": {
	//FAMET chinook 2 ropes cargo
		_off1 = [0.15, 2.37, -2.2];
		_dir1 = "front";
		_inv1 = true;

		_off2 = [0.15, -1.75, -2.41];
		_dir2 = "front";
		_inv2 = true;

		_ropes = 2;

	};

	case "chinook_1r": {
	//FAMET chinook 1 rope right door
		_off1 = [2, 4.9, 0.45];
		_dir1 = "right";
		_inv1 = false;

		_ropes = 1;

	};

	case "chinook_1b": {
	//FAMET chinook 1 rope back door
		_veh animate["Ani_Ramp",1];
		_off1 = [0.15, -6.6, -0.5];
		_dir1 = "front";
		_inv1 = true;

		_ropes = 1;

	};

	case "ab212_1c": {
	//FAMET AB212 rope cargo
		_off1 = [-0.14, 1.54, -1.81];
		_dir1 = "front";
		_inv1 = true;

		_ropes = 1;
	};

	case "ab212_1l": {
	//FAMET AB212 1 rope left door
		_veh animate["PuertaIzq",1];
		_off1 = [-1.9, 2.18, 0];
		_dir1 = "left";
		_inv1 = false;

		_ropes = 1;

	};

	case "ab212_1r": {
	//FAMET AB212 1 rope right door
		_veh animate["PuertaDer",1];
		_off1 = [1.49, 3.02, 0];
		_dir1 = "right";
		_inv1 = true;

		_ropes = 1;

	};

	case "ab212_2": {
	//FAMET AB212 2 ropes both doors
		_veh animate["PuertaIzq",1];
		_off1 = [-1.9, 2.18, 0];
		_dir1 = "left";
		_inv1 = false;

		_veh animate["PuertaDer",1];
		_off2 = [1.49, 3.02, 0];
		_dir2 = "right";
		_inv2 = true;

		_ropes = 2;

	};

///////////////////////////////////////////////////////////////////////////////

	default {
	hint format ["Handy Tools Rope System. WARNING!\n\nThe following unit rope attach settings are not specified and the default ones will be used:\n\n<%1>\n\nPlease choose one of listed configurations in attach_type.sqf", _veh];

		_off1 = [0, 0, 0];
		_dir1 = "front";
		_inv1 = false;

		_off2 = [0, 0, 0];
		_dir2 = "front";
		_inv2 = false;

		_ropes = 1;
	};

};

switch (_dir1) do {

	case "left": {

		_dir1 = _dir + 90;
	

	};

	case "right": {

		_dir1 = _dir - 90;

	};

	case "front": {

		_dir1 = _dir + 180; 

	};

	case "back": {

		_dir1 = _dir; 

	};

	default {

		_dir1 = _dir;

	};

};

switch (_dir2) do {

	case "left": {

		_dir2 = _dir + 90;
	

	};

	case "right": {

		_dir2 = _dir - 90;

	};

	case "front": {

		_dir2 = _dir + 180; 

	};

	case "back": {

		_dir2 = _dir; 

	};

	default {

		_dir2 = _dir;

	};

};


_veh setvariable ["ht_rope_type", [_type, _off1, _dir1, _inv1, _off2, _dir2, _inv2, _ropes]];

