// Scope definitions for the SoldierWB init event handler class
#define private 0
#define public 2

// Extended event handlers example by Solus
class CfgPatches
{
// Name the patch the same as the folder and .pbo to make it easy to identify.
	class SLX_Advanced_Init_Example
	{
		units[]={};
		requiredVersion = 0.1;
		requiredAddons[] = {"Extended_EventHandlers"};
	};
};
class Extended_Init_EventHandlers
{
// Define the classes to add inits to.
	class All
	{
		// Add init lines to be run on all units that inherit from this class.
		// Always tag your line or make it unique in some way so it doesn't get overwritten.
		SLX_Init_All="_this execVM ""\SLX_Advanced_Init_Example\Init_All.sqf"";";
	};
	
	// This init EH will run on all units that are descendants of class Man
	class Man
	{
		SLX_Init_Man="_this execVM ""\SLX_Advanced_Init_Example\Init_Man.sqf"";";
	};

	class SoldierWB
	{

		// Here, we put an inner class with an init event handler that
		// should *only* run on units of the type "SoldierWB".
		// Descendants of that class won't run them because scope=0
		class SLX_SoldierWB_Init
		{
			scope = private;	// scope = 0; is the same thing

			init = "_this execVM ""\SLX_Advanced_Init_Example\Init_SoldierWB.sqf"";";
		};
		
	};
};
