class CfgPatches
{
	class ZGB_TankModels_T72
	{
		units[]={};
		weapons[]={};
		requiredVersion=1.140000;
		requiredAddons[]=
		{
			"CA_Anims_Char",
			"CATracked",
			"CA_Hotfix",
			"CAData",
			"WarfareBuildings_T72_RACS",
			"ZGB_TankModels"
		};
	};
};

class CfgAddons
{
	class PreloadAddons
	{
		class ZGB_TankModels_T72
		{
			list[]=
			{
				"ZGB_TankModels_T72"
			};
		};
	};
};

class CfgVehicles
{
	class ThingEffect;
	class ZGB_Turret;
	class LandVehicle;

	class Tank: LandVehicle
	{
		class NewTurret;
		class ViewPilot;

		class Turrets
		{
			class MainTurret: NewTurret
			{
				class Turrets
				{
					class CommanderOptics;
				};
			};
		};
	};

	class ZGB_T72_Cartridge: ThingEffect
	{
		scope=1;
		camouflage=0.000100;
		accuracy=1000;
		irTarget=0;
		submerged=0;
		model="\ZGB_TankModels\T72\models\ZGB_T72_Catridge.p3d";
		displayName="Internal: cartridge";
	};

	class ZGB_T72_Turret: ZGB_Turret
	{
		displayName="T-72 turret";
		model="\ZGB_TankModels\T72\models\ZGB_T72_Turret";
	};

	class ZGB_T72_RACS_Turret: ZGB_T72_Turret
	{
		model="\ZGB_TankModels\T72\models\ZGB_T72_RACS_Turret";
	};

	class T72: Tank
	{
		model="\ZGB_TankModels\T72\models\ZGB_T72";
		NWD_ModelEnhancements=1;
		maxSpeed=60;
		gearBox[]={-14.350000,0,8.173000,4.400000,3.485000,2.787000,2.027000,1.467000,1};
		driverOpticsModel="";
		driverOutOpticsModel="";
		driverOpticsShowCursor=0;
		driverOutOpticsShowCursor=0;
		driverForceOptics=0;
		driverAction="Abrams_DriverOut";
		driverInAction="ZGB_T72_Driver";
		forceHideDriver=0;
		viewCargoShadowDiff=0.050000;
		viewCargoShadowAmb=0.500000;

		class ViewPilot: ViewPilot
		{
			initAngleX=0;
			minAngleX=-10;
			maxAngleX=5;
			initAngleY=0;
			minAngleY=-40;
			maxAngleY=40;
		};

		class HitLTrack
		{
			armor=0.550000;
			material=55;
			name="pas_L";
			visual="pas_L";
			passThrough=0;
		};

		class HitRTrack
		{
			armor=0.550000;
			material=55;
			name="pas_P";
			visual="pas_P";
			passThrough=0;
		};

		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				lockWhenDriverOut=1;
				gunnerOpticsModel="\ca\Weapons\optika_empty";
				gunnerOutOpticsModel="";
				gunnerOpticsShowCursor=0;
				gunnerOutOpticsShowCursor=0;
				gunnerForceOptics=0;
				gunnerInAction="ZGB_T72_Gunner";
				startengine=0;
				minElev="-6-13/60";
				maxElev="13+47/60";
				initTurn=-12.500000;
				maxHorizontalRotSpeed=0.350000;
				maxVerticalRotSpeed=0.060000;

				class ViewOptics
				{
					initAngleX=0;
					minAngleX=-30;
					maxAngleX=30;
					initAngleY=0;
					minAngleY=-100;
					maxAngleY=100;
					initFOV=0.080000;
					minFOV="1/15";
					maxFOV=0.300000;
				};

				class Turrets: Turrets
				{
					class CommanderOptics: CommanderOptics
					{
						gunnerOutOpticsModel="\ca\Weapons\optika_empty";
						gunnerOpticsShowCursor=0;
						gunnerOutOpticsShowCursor=0;
						gunnerForceOptics=0;
						viewGunnerInExternal=0;
						gunnerInAction="ZGB_T72_commander";
						memoryPointGunnerOptics="commanderview";
						memoryPointGunnerOutOptics="commander_weapon_view";
						initElev=37;
						startengine=0;
					};
				};
			};
		};

		class AnimationSources
		{
			class gunnerFOV
			{
				source="user";
				animPeriod=0.250000;
				initPhase=0.350000;
			};

			class hidePrimarySight
			{
				source="user";
				animPeriod=0.001000;
				initPhase=0;
			};

			class hideGunnerPeriscope
			{
				source="user";
				animPeriod=0.001000;
				initPhase=1;
			};

			class gunNotReady
			{
				source="user";
				animPeriod=0.001000;
				initPhase=0;
			};

			class sightRange
			{
				source="user";
				animPeriod=0.000500;
				initPhase=0;
			};

			class sightElevationAPFSDS
			{
				source="user";
				animPeriod=0.400000;
				initPhase=0;
			};

			class sightElevationHEAT
			{
				source="user";
				animPeriod=0.065000;
				initPhase=0;
			};

			class sightElevationHEF
			{
				source="user";
				animPeriod=0.080000;
				initPhase=0;
			};

			class DShKM_Reload
			{
				source="reload";
				weapon="DShKM";
			};

			class NWD_NSVT_Reload
			{
				source="reload";
				weapon="NWD_NSVT_T72";
			};

			class D81_Recoil
			{
				source="user";
				animPeriod=0.200000;
				initPhase=0;
			};

			class hideTurret
			{
				source="user";
				animPeriod=0;
				initPhase=0;
			};
		};

		class Damage
		{
			tex[]={};
			mat[]=
			{
				"ca\tracked\data\detailmapy\t72_pasy.rvmat",
				"ca\tracked\data\detailmapy\t72_pasy.rvmat",
				"ca\tracked\data\detailmapy\t72_pasy_destruct.rvmat",
				"ZGB_TankModels\materials\t72_nsv_metal.rvmat",
				"ZGB_TankModels\materials\t72_nsv_metal.rvmat",
				"ZGB_TankModels\materials\t72_nsv_metal_destruct.rvmat"
			};
		};
	};

	class T72_RACS: T72
	{
		model="\ZGB_TankModels\T72\models\ZGB_T72_RACS";
	};
};

class CfgMovesBasic
{
	class DefaultDie;

	class ManActions
	{
		ZGB_T72_Commander="ZGB_T72_Commander";
		ZGB_T72_Driver="ZGB_T72_Driver";
		ZGB_T72_Gunner="ZGB_T72_Gunner";
	};
};

class CfgMovesMaleSdr: CfgMovesBasic
{
	class States
	{
		class Crew;

		class ZGB_T72_Commander: Crew
		{
			file="\ZGB_TankModels\T72\anims\ZGB_T72_Commander.rtm";
		};

		class ZGB_T72_Driver: Crew
		{
			file="\ZGB_TankModels\T72\anims\ZGB_T72_Driver.rtm";
		};

		class ZGB_T72_Gunner: Crew
		{
			file="\ZGB_TankModels\T72\anims\ZGB_T72_Gunner.rtm";
		};
	};
};
