/*
		FX for Generic Helicopters
		v1.04
		
		by MadDogX
*/

// Get vehicle object
_vehicle = _this select 0;
_forceTA = _this select 1;


_oldDamage = damage _vehicle;
_damageDone = 0;

// Initialize bits
drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",0.1,0.1,[0,0,1000],[0,0,0],0,0,1,0,[1],[[0,0,0,0]],[1],0,0,"","",""];
drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",0.1,0.1,[0,0,1000],[0,0,0],0,0,1,0,[1],[[0,0,0,0]],[1],0,0,"","",""];

// Damage loop
for [{_loop=0},{_loop>=0},{_loop=_loop}] do
{
	waitUntil {(damage _vehicle)!=_oldDamage;};
	_damageDone = (damage _vehicle) - _oldDamage;
	_oldDamage = damage _vehicle;
	if ((damage _vehicle)>=1) then
	{
		// If vehicle is destroyed, exit damage loop and go to destruction
		_loop = -1;
	}
	else
	{
		// Check if vehicle was heavily damaged
		if (_damageDone>0.1) then
		{
			// Damage code
			for [{_x=0},{_x<5},{_x=_x+1}] do
			{
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 2);
				_py = 1.5 - random(2); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 3 - random(6); _vz = (velocity _vehicle select 2)/2 + (_pz * 2);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
				drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 2);
				_py = 1.5 - random(2); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 3 - random(6); _vz = (velocity _vehicle select 2)/2 + (_pz * 2);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 0.5 + (random(1));_sz = 0.5 + (random(3));
				drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"","",""];
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 2);
				_py = 1.5 - random(2); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 3 - random(6); _vz = (velocity _vehicle select 2)/2 + (_pz * 2);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
				drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 2);
				_py = 1.5 - random(2); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 3 - random(6); _vz = (velocity _vehicle select 2)/2 + (_pz * 2);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 0.5 + (random(1));_sz = 0.5 + (random(3));
				drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"","",""];
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 2);
				_py = 1.5 - random(2); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 3 - random(6); _vz = (velocity _vehicle select 2)/2 + (_pz * 2);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
				drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 2);
				_py = 1.5 - random(2); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 3 - random(6); _vz = (velocity _vehicle select 2)/2 + (_pz * 2);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 0.5 + (random(1));_sz = 0.5 + (random(3));
				drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"","",""];

			};
		};
	};
	// Small pause just in case of endless loops
	sleep 0.1;
};

// Vehicle destruction code
//==========================

// Blast off those rotors baby!
_rotDir = random(90);
_rotPos = _vehicle modelToWorld [0,0.2,2];
for [{_x=0},{_x<4},{_x=_x+0.5}] do
{
	_curDir = _rotDir + (_x * 90);
	_px = (_rotPos select 0) + (sin(_curDir) * 1);_py = (_rotPos select 1) + (cos(_curDir) * 1);_pz = (_rotPos select 2);_vx = (sin(_curDir+20-random(40)) * 2.5) * (3 + random(2));_vy = (cos(_curDir+20-random(40)) * 2.5) * (3 + random(2));_vz = 1.8 + random(3);_rt = 1.2 + (random(2));_sz = 0.2 + (random(0.2));
	drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,[_px,_py,_pz],[(velocity _vehicle select 0)/2+_vx,(velocity _vehicle select 1)/2+_vy,(velocity _vehicle select 2)/2+_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
	_px = (_rotPos select 0) + (sin(_curDir) * 2);_py = (_rotPos select 1) + (cos(_curDir) * 2);_pz = (_rotPos select 2);_vx = (sin(_curDir+20-random(40)) * 2.5) * (5 + random(2));_vy = (cos(_curDir+20-random(40)) * 2.5) * (5 + random(2));_vz = 1.8 + random(3);_rt = 1.2 + (random(2));_sz = 0.2 + (random(0.2));
	drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,[_px,_py,_pz],[(velocity _vehicle select 0)/2+_vx,(velocity _vehicle select 1)/2+_vy,(velocity _vehicle select 2)/2+_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
	_px = (_rotPos select 0) + (sin(_curDir) * 3);_py = (_rotPos select 1) + (cos(_curDir) * 3);_pz = (_rotPos select 2);_vx = (sin(_curDir+20-random(40)) * 2.5) * (7 + random(3));_vy = (cos(_curDir+20-random(40)) * 2.5) * (7 + random(3));_vz = 1.8 + random(3);_rt = 1.2 + (random(2));_sz = 0.2 + (random(0.2));
	drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,[_px,_py,_pz],[(velocity _vehicle select 0)/2+_vx,(velocity _vehicle select 1)/2+_vy,(velocity _vehicle select 2)/2+_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
};


// Rotor Explosion
_rotPos = _vehicle modelToWorld [0,0.2,1.5];
for [{_x=0},{_x<10},{_x=_x+1}] do
{
 	_px = 1 - random(2); _vx = _px * 3;_py = 1 - random(2); _vy = _py * 3;_pz = 0.3 - random(0.6); _vz = _pz * 3;
	drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\FireAnim", 8, 2, 7],"","Billboard",0.7,0.7,[(_rotPos select 0) + _px,(_rotPos select 1) + _py,(_rotPos select 2) + _pz],[_vx,_vy,_vz],0,1.275,1,0.2,[1,2],[[1,0.8,0.6,1],[0.8,0.5,0.2,0.6],[0,0,0,0]],[0,1],0,0,"","",""];
	drop ["\Ca\Data\cl_basic.p3d","","Billboard",3.5,3.5,[(_rotPos select 0) + _px,(_rotPos select 1) + _py,(_rotPos select 2) + _pz],[_vx/2,_vy/2,_vz/2],0,1.275,1,0.2,[2,8],[[0.1,0.1,0.1,1],[0,0,0,1],[0,0,0,0]],[1],0,0,"","",""];
};


// Bits blasting off
for [{_x=0},{_x<20},{_x=_x+1}] do
{
	_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 12);_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 6);_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + (_pz * 6);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
	drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
};


// If Helicopter is in the air, 0% possibility of complete destruction (forced only)
_destruct = random(1);
if (_forceTA==1) then
{
	// Helicopter is totally annihilated
	for [{_x=0},{_x<10},{_x=_x+1}] do
	{
	 	// Medium metal shards
		_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 8);_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 5);_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 3);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 1.2 + (random(2));_sz = 0.5 + (random(3));
		drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",12,12,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"","",""];
	};	
	for [{_x=0},{_x<4},{_x=_x+1}] do
	{
	 	// Large metal shards
		_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 12);_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 8);_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 6);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 0.5 + (random(1));_sz = 2.5 + (random(4));
		drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",0.2,12,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"\TJPORCHEPD\MDXexploFX\FX\FX_smallFire.sqf","",""];
	};
	for [{_x=0},{_x<20},{_x=_x+1}] do
	{
	 	// Small metal shards
		_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 15);_py = 2 - random(4); _vy = (velocity _vehicle select 1)/2 + (_py * 9);_pz = 1.5 - random(1); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 9);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
		drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",12,12,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
	}; 
	for [{_x=0},{_x<20},{_x=_x+1}] do
	{
	 	// Engine explosion, fire and smoke
 		_px = 2 - random(4); _vx = _px * 2;_py = 5 - random(10); _vy = _py;_pz = 3 - random(4); _vz = (_pz-1) * 2;_realPos = _vehicle modelToWorld [0+_px,0.2+_py,0.8+_pz];
		drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\FireAnim", 8, 2, 7],"","Billboard",1.5+random(0.5),1.5+random(0.5),_realPos,[_vx,_vy,_vz],0,1.275,1,0.2,[2,6],[[1,0.8,0.6,1],[0.8,0.5,0.2,0.6],[0,0,0,0]],[0,1],0,0,"","",""];
		drop ["\Ca\Data\cl_basic.p3d","","Billboard",8.5+random(2),8.5+random(2),_realPos,[_vx/1.8,_vy/1.8,_vz/1.8],0,1.275,1,0.2,[5,20],[[0.1,0.1,0.1,0.2],[0,0,0,0.1],[0,0,0,0]],[1],0,0,"","",""];
	};
	_soundSrc1 = "HeliHEmpty" createVehicleLocal (position _vehicle);
	_soundSrc1 say "mdxexplosfx_engine_explosion_01";
	deleteVehicle _vehicle;
}
else
{
	// No complete destruction.
	for [{_x=0},{_x<10},{_x=_x+1}] do
	{
	 	// Medium metal shards
		_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 8);_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 5);_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 3);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 1.2 + (random(2));_sz = 0.5 + (random(3));
		drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",12,12,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"","",""];
	};	
	for [{_x=0},{_x<4},{_x=_x+1}] do
	{
	 	// Large metal shards
		_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 12);_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 8);_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 6);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 0.5 + (random(1));_sz = 2.5 + (random(4));
		drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",0.2,12,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.3,0.3,0.3,1],[0.3,0.3,0.3,1],[0.3,0.3,0.3,0]],[1],0,0,"\TJPORCHEPD\MDXexploFX\FX\FX_smallFire.sqf","",""];
	};
	for [{_x=0},{_x<20},{_x=_x+1}] do
	{
	 	// Small metal shards
		_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 15);_py = 2 - random(4); _vy = (velocity _vehicle select 1)/2 + (_py * 9);_pz = 1.5 - random(1); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 9);_realPos = _vehicle modelToWorld [_px,_py,_pz];_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
		drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",12,12,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
	}; 
	for [{_x=0},{_x<20},{_x=_x+1}] do
	{
	 	// Engine explosion, fire and smoke
 		_px = 2 - random(4); _vx = _px * 2;_py = 5 - random(10); _vy = _py;_pz = 3 - random(4); _vz = (_pz-1) * 2;_realPos = _vehicle modelToWorld [0+_px,0.2+_py,0.8+_pz];
		drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\FireAnim", 8, 2, 7],"","Billboard",1.5+random(0.5),1.5+random(0.5),_realPos,[_vx,_vy,_vz],0,1.275,1,0.2,[2,6],[[1,0.8,0.6,1],[0.8,0.5,0.2,0.6],[0,0,0,0]],[0,1],0,0,"","",""];
		drop ["\Ca\Data\cl_basic.p3d","","Billboard",8.5+random(2),8.5+random(2),_realPos,[_vx/1.8,_vy/1.8,_vz/1.8],0,1.275,1,0.2,[5,20],[[0.1,0.1,0.1,0.2],[0,0,0,0.1],[0,0,0,0]],[1],0,0,"","",""];
	};
	_soundSrc1 = "HeliHEmpty" createVehicleLocal (position _vehicle);
	_soundSrc1 say "mdxexplosfx_engine_explosion_01";
	//Check if vehicle is in the air, so it will burn and lose parts on the way down
	_dropping = false;
	if ((position _vehicle select 2)>3) then
	{
	 	_dropping = true;
	 	_loseObj = 0;
	 	_loseNext = 2 + random(6);
		for [{_loop=0},{_loop>=0},{_loop=_loop}] do
		{
		 	_loseObj = _loseObj + 1;
		 	_px = 1 - random(2); _py = 2 - random(4); _pz = 1.5 - random(2);
			_pos = _vehicle modelToWorld [_px,_py,_pz];
			_sz = 3 + random(5);
			drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\FireAnim", 8, 2, 7],"","Billboard",0.5,0.5,_pos,[(velocity _vehicle select 0)/1.6,(velocity _vehicle select 1)/1.6,(velocity _vehicle select 2)/1.3],0,1,1,0.1,[4,8],[[1,0.8,0.6,1],[0.8,0.5,0.2,0.6],[0,0,0,0]],[0,1],0,0,"","",""];
			drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\SmokeAnim", 8, 3, 1],"","Billboard",5,5,_pos,[0,0,0],0,1.275,1,0.1,[_sz,_sz*2],[[0.3,0.3,0.3,0.5],[0.3,0.3,0.3,0.5],[0.3,0.3,0.3,0]],[0],0,0,"","",""];
			if (_loseObj>=_loseNext) then
			{
				_loseObj = 0;
				_loseNext = 1 + random(3);
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 6);
				_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 3);
				_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + (_pz * 3);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 1.2 + (random(2));_sz = 0.8 + (random(1));
				drop ["\ca\misc\kusplechu3.p3d","","SpaceObject",5,5,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
			};
			sleep 0.1;
			if ((position _vehicle select 2)<2) then {_loop=(-1);};
		};
	};
	waitUntil {(velocity _vehicle select 2)>(-1)};
	if (_dropping) then
	{
		if (((getPosASL _vehicle) select 2)<0.5) then
		{
			// Water crash
			_soundSrc2 = "HeliHEmpty" createVehicleLocal (position _vehicle);
			_soundSrc2 say "mdxexplosfx_watersplash_01";
			// Water splash
			for [{_x=0},{_x<360},{_x=_x+8}] do
			{
				_px = sin(_x); _vx = _px * (8 + random(6));
				_py = cos(_x); _vy = _py * (8 + random(6));
				_vz = 0;
				_pos = _vehicle modelToWorld [0+_px,0+_py,1];
				_sz = 4 + (random(2));
				drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\SmokeAnim", 8, 3, 1],"","Billboard",4,4,[_pos select 0, _pos select 1, 1],[_vx,_vy,_vz],0,1.275,1,0.1,[_sz,_sz*2],[[1,1,1,0.2],[1,1,1,0]],[0],0,0,"","",""];
			};
			for [{_x=0},{_x<30},{_x=_x+1}] do
			{
				_px = 1 - random(2); _vx = _px * (1 + random(2));
				_py = 1 - random(2); _vy = _py * (1 + random(2));
				_vz = 5 + random(25);
				_pos = [((position _vehicle) select 0)+_px,((position _vehicle) select 1)+_py, 0];
				_sz = 4 + (random(2));
				drop ["\Ca\Data\cl_basic.p3d","","Billboard",6,6,_pos,[_vx,_vy,_vz],0,26.275,1,0.1,[10,20],[[1,1,1,0.2],[1,1,1,0]],[0],0,0,"","",""];
			};
		}
		else
		{
			// Ground crash
			_soundSrc2 = "HeliHEmpty" createVehicleLocal (position _vehicle);
			_soundSrc2 say "mdxexplosfx_engine_explosion_01";
			for [{_x=0},{_x<20},{_x=_x+1}] do
			{
				_px = 1 - random(2); _vx = (velocity _vehicle select 0)/2 + (_px * 12);
				_py = 3 - random(6); _vy = (velocity _vehicle select 1)/2 + (_py * 6);
				_pz = 1.5 - random(2); _vz = (velocity _vehicle select 2)/2 + ((_pz+2) * 6);
				_realPos = _vehicle modelToWorld [_px,_py,_pz];
				_rt = 1.2 + (random(2));_sz = 0.1 + (random(0.15));
				drop ["\ca\misc\sloupyelI.p3d","","SpaceObject",8,8,_realPos,[_vx,_vy,_vz],_rt,20,1,0.2,[_sz],[[0.1,0.1,0.1,1],[0.1,0.1,0.1,1],[0.1,0.1,0.1,0]],[1],0,0,"","",""];
			};
			// Blast wave
			for [{_x=0},{_x<360},{_x=_x+8}] do
			{
				_px = sin(_x); _vx = _px * (5 + random(3));
				_py = cos(_x); _vy = _py * (5 + random(3));
				_vz = 0;
				_pos = _vehicle modelToWorld [0+_px,0+_py,1];
				_sz = 4 + (random(2));
				drop [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\SmokeAnim", 8, 3, 1],"","Billboard",7,7,[_pos select 0, _pos select 1, 1],[_vx,_vy,_vz],0,1.275,1,0.1,[_sz,_sz*2],[[0.2,0.2,0.2,0.2],[0.2,0.2,0.2,0]],[0],0,0,"","",""];
			};
		};
	};
};

sleep 3;

deleteVehicle _soundSrc1;
deleteVehicle _soundSrc2;