/*
  REVIVE SCRIPT - AI disabled

  Creates playable units that fall unconcious when killed which can then be revived

  MARCH 2008 - norrin (norrins_nook@iprimus.com.au) 
  Revised by Xeno (www.germany-fun.de)
  Additional revive functions by HulkingUnicorn and alef

  Version:  1.46 (Revivable Players - AI disabled)
*******************************************************************************************************
  Special thanks to HulkingUnicorn and MCPXXL for their scripting advice, testing and many suggestions
  Many thanks also to satexas69, SNKMAN, sickboy, vengeance1 (JAAF), Legislator, alef
  and Raedor for all their suggestions, advice and support and to all at the BIS forums.
  Based on concepts by PRiMe, toadlife and Mongoose_84.  Also thanks to Chris'OFP editor.
  Some of the voice arrray stuff stolen with the permission of SNKMAN from ArmA Group Link II Plus!
  And of course thanks to Kegetys for his amazing spectating script and to ViperMaul for his script fix 
  Last but not least to Foxhound and ArmAholic for their great support and providing mirrors for all my scripts
-------------------------------------------------------------------------------------------------------

  See release notes for details on incorporating revive scripts in your missions

********************************************************************************************************
Start revive_init.sqf
*/

//Init.sqf settings for revive_player scripts by norrin
// ====================================================
ScopeName "NORRN_r_init";
//if (!requiredVersion "1.09") exitWith {hint "Wrong game version for revive"};
if (isServer) then {NORRN_list = []};

//sickboy's code modified by _xeno 
T_INIT 	= false;
T_Server 	= false; 
T_Client 	= false; 
T_JIP 	= false;

T_MP = (if (playersNumber east + playersNumber west + playersNumber resistance + playersNumber civilian > 0) then {true} else {false});

if (isServer) then 
{
	T_Server = true;
	if (!isNull player) then {T_Client = true};
	T_INIT = true;
} else {
	T_Client = true;
	if (isNull player) then 
	{
		T_JIP = true;
		[] spawn {waitUntil {!isNull player};T_INIT = true};
	} else {
		T_INIT = true;
	};
};
waitUntil {T_INIT};

//Configurable revive script options (Off = 0, On = 1)
// ====================================================
_NORRN_mission_end_function = 0; 		//array no.0 
_NORRN_reward_function = 0; 			//array no.1
_NORRN_team_kill_function = 0;     		//array no.2
_NORRN_all_dead_dialog = 0;			//array no.3
_NORRN_JIP_spawn_dialog = 0;			//array no.4
_NORRN_nearest_teammate_dialog = 1; 	//array no.5
_NORRN_unconcious_markers = 1;		//array no.6
_NORRN_follow_cam = 1;  			//array no.7
_NORRN_call_out_function = 1;			//array no.8
_NORRN_revive_timer = 1; 			//array no.9
_NORRN_heal_yourself = 0;			//array no.10
_NORRN_kegetys_spectator = 1;			//array no.11
_NORRN_water_dialog = 1;			//array no.38
_NORRN_unconscious_drag = 1;			//array no.47

//list of playable units 
// ====================================================
NORRN_player_units = ["alpha_1","alpha_2"];

//This next line can be commented out or removed if it 
//interferes with intro movies  
// ====================================================
titleText ["Joining Mission", "BLACK FADED", 0.2];

// no of respawn points, spawn position names for 
//respawn and the time before the respawn dialog appears 
//for JIP players - Option to make base_1 respawn possible 
//even if enemy forces are within 50 metres (options OFF = 0, ON = 1)
// =====================================================
_NORRN_no_respawn_points = 2;			//array no.12
_NORRN_Base_1 = "Mobile";			//array no.13
_NORRN_Base_2 = "West_spawn1";		//array no.14
_NORRN_Base_3 = "";				//array no.15
_NORRN_Base_4 = "";				//array no.16
_NORRN_time_b4_JIP_spawn_dialog = 10000;	//array no.17
_NORRN_Base_1_respawn = 0;			//array no.18
_NORRN_mobile_spawn = 1;			//array no.51
_NORRN_mobile_base_start = "Base";		//array no.52

if (isServer && _NORRN_mobile_spawn == 1) then {NORRN_camo_net = false; publicVariable "NORRN_camo_net"};
if (_NORRN_mobile_spawn == 1) then {r_ms_base_1 = _NORRN_Base_1};

//The can_revive variable can be changed if for example
// you only one sort of unit to be able to revive eg. "soldierWMedic" 
//The can_be_revived variable can be changed if you want
//to use these scripts for a different side
// =====================================================
_NORRN_can_revive = "soldierWB";		//array no.19
_NORRN_can_revive_2 = "";			//array no.20
_NORRN_can_be_revived = "soldierWB";	//array no.21
_NORRN_can_be_revived_2 = "";			//array no.22

//No of Enemy sides (0, 1 or 2). Enemy sides can be "EAST",
//"WEST","RESISTANCE" etc
// ======================================================
_NORRN_no_enemy_sides = 1;			//array no.23
_NORRN_enemy_side_1 = "EAST";			//array no.24
_NORRN_enemy_side_2 = "";			//array no.25

//Friendly sides. These next options are linked to the camera script and
//allow the players to spectate other team members and friendly sides
//while unconscious.  Friendly sides can be "EAST", "WEST","RESISTANCE" etc.  
//If all players are from the same side make sure you set the same side 
//for both variables eg "WEST", "WEST" ie do not leave these variables blank 
//if using the follow cam option (//array no.7)
//=======================================================
_NORRN_allied_side_1 = "WEST";		//array no.40
_NORRN_allied_side_2 = "WEST";		//array no.41

//Maximum number of revives per unit - adjust to whatever 
//value you like and the unit's level of damage following revive
//Whether you want to use HulkingUnicorn's script that does not allow the
//player to stand until after he has been healed by a medic
// ======================================================
_NORRN_max_respawns = param2;			//array no.26
_NORRN_revive_damage = 0.8; 			//array no.39
_HULK_rProne = 1;					//array no.43

//Time until respawn button appears (0 = approx. 12 seconds)
//Set to a high number like 100000 seconds if you do not want
//to use this option
// ======================================================
_NORRN_respawn_button_timer = 0;		//array no.27

//If the closest friendly unit is further 
//than this distance away trigger respawn dialog
// ======================================================
_NORRN_distance_to_friend = 250; 		//array no.28

//Number fo the revives required for bonus
// ======================================================
_NORRN_revives_required = 1;			//array no.29

//Number of teamkills before punishment
// ======================================================
_NORRN_no_team_kills = 1;			//array no.30

//Choose what type of respawn option for the revive_timer
//function: 0 = dead or 1 = spawns at base (NORRN_respawn_position = 0)
//or the closest enemy free respawn point to where the player died 
//NORRN_respawn_positon = 1) or player's choice of free respawn point 
//NORRN_respawn_positon = 2) When using the revive_timer function 
//the length of time before the unconscious player is declared dead 
//or respawns. Also you have the option of viewing a revive count down 
//timer 
// ======================================================
_NORRN_revive_timer_type = 1;			//array no.31
_NORRN_respawn_position = 1;			//array no.32
_NORRN_revive_time_limit = 180;		//array no.33
_NORRN_visible_timer = 1;			//array no.42

//Number of heals that each player gets during a mission 
//The damage level range between which the heal action becomes available 
//=======================================================
_NORRN_no_of_heals = 1;				//array no.34
_NORRN_lower_bound_heal = 0.1;		//array no.35
_NORRN_upper_bound_heal = 0.7;		//array no.36									

//This sets the distance that you wish the unconscious 
//follow cam to follow other team members.  Follow_cam_team allows
//you to specify whether the unconscious cam follows all friend units(0)or
//just those that are define by the NORRN_player_units array (1)  
//=======================================================
_NORRN_follow_cam_distance = 250;		//array no.37
_NORRN_follow_cam_team	   = 0;		//array no.44

//If _NORRN_rejoin_punish is set to 1 players who 
//quit then rejoin the server to avoid waiting to be revived
//will rejoin the server with _NORRN_rejoin_punish_revives
//lives. If _NORRN_rejoin_punish_system = 0 player receives
//_NORRN_rejoin_punish_revives each time he rejoins, if it equals 1 
//then player spawns as a seagull if he rejoins a second time  
//========================================================
_NORRN_rejoin_punish = 1;			//array no.45
_NORRN_rejoin_punish_revives = 3;		//array no.46
_NORRN_rejoin_punish_system = 1;

//========================================================
//Additional revive functions with many thanks to alef (0 - off, 1 - on except for _NORRN_bury_timeout)
_NORRN_drop_weapons = 1; 			//array no.48, Should the respawned player drop his weapons where he died?
_NORRN_cadaver = 0; 				//array no.49, Should the respawned player's body remain there?
_NORRN_bury_timeout = 120;			//array no.50, If drop weapons OR player body, how long before the body is buried?
							// 0=maximum (1200s) , n=seconds up to 1200s (hard coded)
//========================================================
//Code for punishing rejoining players
_r_units = [];
{call compile format ["_r_units = _r_units + [%1]", _x]} forEach NORRN_player_units;

if (_NORRN_rejoin_punish == 1 && player in _r_units) then 
{	
	_zzz = 0;
	if (_NORRN_rejoin_punish_system == 0) then 
	{
		if ((name player) in NORRN_list) then 
		{
			_NORRN_max_respawns = _NORRN_rejoin_punish_revives;
		};
		[0] execVM "revive_sqf\rejoin.sqf";
	}else{
		{if ((name player) == _x) then {_zzz = _zzz + 1}}forEach NORRN_list;
		if (_zzz == 0) then {[0] execVM "revive_sqf\rejoin.sqf";};
		if (_zzz == 1) then 
		{
			_NORRN_max_respawns = _NORRN_rejoin_punish_revives;
			[1] execVM "revive_sqf\rejoin.sqf";
		};
		if (_zzz > 1) then {[player, player, "null"] execVM "spect\specta.sqf"; breakout "NORRN_r_init"};
	};	
};

//========================================================
//User code - eg. NORRNCustonexec1="execvm ""myscript.sqf"";hint ""myoutput"";"
//Exec1 occurs following being revived
//Exec2 occurs when you team kill
//Exec3 occurs when you spawn at base
//Exec4 occurs when you try and spawn at base but it is still occupied
NORRNCustomExec1="";
NORRNCustomExec2="";
NORRNCustomExec3="";
NORRNCustomExec4="";
NORRNCustomExec5="";  //Must use variables: MAP_r_rejoin (false - first time, 
			    //true - rejoining the server, and 
			    //MAP_r_no_lives - number of lives if you rejoin server) 

//========================================================

NORRN_revive_array = [];
NORRN_revive_array = [_NORRN_mission_end_function,_NORRN_reward_function, _NORRN_team_kill_function, _NORRN_all_dead_dialog, _NORRN_JIP_spawn_dialog,
			    _NORRN_nearest_teammate_dialog, _NORRN_unconcious_markers, _NORRN_follow_cam, _NORRN_call_out_function, _NORRN_revive_timer,
			    _NORRN_heal_yourself, _NORRN_kegetys_spectator,_NORRN_no_respawn_points,_NORRN_Base_1,_NORRN_Base_2,_NORRN_Base_3,_NORRN_Base_4,
			    _NORRN_time_b4_JIP_spawn_dialog,_NORRN_Base_1_respawn,_NORRN_can_revive,_NORRN_can_revive_2,_NORRN_can_be_revived,
			    _NORRN_can_be_revived_2,_NORRN_no_enemy_sides,_NORRN_enemy_side_1,_NORRN_enemy_side_2,_NORRN_max_respawns,_NORRN_respawn_button_timer,
			    _NORRN_distance_to_friend,_NORRN_revives_required,_NORRN_no_team_kills,_NORRN_revive_timer_type,_NORRN_respawn_position,
			    _NORRN_revive_time_limit,_NORRN_no_of_heals,_NORRN_lower_bound_heal,_NORRN_upper_bound_heal,_NORRN_follow_cam_distance,
			    _NORRN_water_dialog, _NORRN_revive_damage, _NORRN_allied_side_1, _NORRN_allied_side_2, _NORRN_visible_timer, _HULK_rProne,
			    _NORRN_follow_cam_team, _NORRN_rejoin_punish, _NORRN_rejoin_punish_revives,_NORRN_unconscious_drag, _NORRN_drop_weapons,
			    _NORRN_cadaver,_NORRN_bury_timeout,_NORRN_mobile_spawn,_NORRN_mobile_base_start];

//Initialise isplayer script
if (player in _r_units) then {[] execVM "revive_sqf\revive_init.sqf"};	

//Initialise isplayer script
[NORRN_player_units] execVM "revive_sqf\isplayer.sqf";

if (isServer) then 
{
	//Initialise mission end script
	if (_NORRN_mission_end_function == 1) then {[NORRN_player_units] execVM "revive_sqf\mission_end.sqf"};
	
	//Initialise marker color script
	if (_NORRN_no_enemy_sides > 0) then {[] execVM "revive_sqf\marker_color.sqf"};

};

if (true) exitWith {};	



