/*

 DRAG BODY SCRIPT

 Allows players to drag unconscious bodies

 MARCH 2008 - norrin (norrins_nook@iprimus.com.au)
*****************************************************************************************************************************
Start drag.sqf
*/

private ["_unit","_dragee","_pos","_dir"];

_can_be_revived 		= NORRN_revive_array select 21;
_can_be_revived_2 	= NORRN_revive_array select 22;
_unit  			= player;
r_drag_sqf 			= true;

//identify unit to be dragged
if (animationstate (nearestObjects [_unit, [_can_be_revived, _can_be_revived_2], 2] select 1) == "AmovPpneMstpSnonWnonDnon_healed") then 
{
	_dragee = nearestObjects [_unit, [_can_be_revived, _can_be_revived_2], 2] select 1;
};

if (isNull _dragee) exitWith {}; 

//unit assumes dragging posture
// _unit playMove "AmovPknlMwlkSlowWrflDb";

//Uneccesary actions removed & drop body added 
call compile format ["%1 removeAction %1_myaction_drag", _unit];
call compile format ["%1 removeAction %1_myaction", _unit];
NORRN_dragaction = player addAction ["Drop body", "revive_sqf\drop_body.sqf","", 0, false, true];


while {r_drag_sqf} do
{	
	//check that dragged unit still exists
	_dragee = objNull;
	if (animationstate (nearestObjects [_unit, [_can_be_revived, _can_be_revived_2], 2] select 1) == "AmovPpneMstpSnonWnonDnon_healed") then 
	{
		_dragee = nearestObjects [_unit, [_can_be_revived, _can_be_revived_2], 2] select 1;
	};

	if (isNull _dragee || !alive _unit) exitWith 
	{	
		player removeAction NORRN_dragaction; 
		NORRN_remove_drag = true;  
		r_drag_sqf = false;
	}; 
	
	//unit assumes dragging posture
	if (animationState _unit != "AmovPknlMwlkSlowWrflDb") then 
	{	
		_wait = time + 1;
		while {time < _wait} do 
		{
			//get current position of unit
			_pos = getPos _unit;
			_dir = getDir _unit;
			_pos_dragee = getPos _dragee;
			_height = _dragee distance _pos_dragee;
	
			//update position of body
			_dragee setDir (_dir - 180);
			_dragee setPos[((_pos select 0) + (1.5 * sin _dir)), ((_pos select 1) + (1.5 * cos _dir)),_height];
		 	sleep 0.01;
		};
		if (!r_drag_sqf) exitWith {};	
		_unit playMove "AmovPknlMwlkSlowWrflDb";
	};
	
	//get current position of unit
	_pos = getPos _unit;
	_dir = getDir _unit;
	_pos_dragee = getPos _dragee;
	_height = _dragee distance _pos_dragee;
	
	//update position of body
	_dragee setDir (_dir - 180);
	_dragee setPos[((_pos select 0) + (1.5 * sin _dir)), ((_pos select 1) + (1.5 * cos _dir)),_height];
	sleep 0.01;
};

if (true) exitWith {};
	