/*

RESPAWN AT BASE DIALOG

This script adds a button when the follow_camera activates that allows the player to respawn at base

 June 2007 - norrin (norrins_nook@iprimus.com.au) 
**********************************************************************************************************************************
respawn_button_1.hpp
*/

// Control types
#define CT_STATIC           0
#define CT_BUTTON           1
#define CT_EDIT             2
#define CT_SLIDER           3
#define CT_COMBO            4
#define CT_LISTBOX          5
#define CT_TOOLBOX          6
#define CT_CHECKBOXES       7
#define CT_PROGRESS         8
#define CT_HTML             9
#define CT_STATIC_SKEW      10
#define CT_ACTIVETEXT       11
#define CT_TREE             12
#define CT_STRUCTURED_TEXT  13
#define CT_CONTEXT_MENU     14
#define CT_CONTROLS_GROUP   15
#define CT_XKEYDESC         40
#define CT_XBUTTON          41
#define CT_XLISTBOX         42
#define CT_XSLIDER          43
#define CT_XCOMBO           44
#define CT_ANIMATED_TEXTURE 45
#define CT_OBJECT           80
#define CT_OBJECT_ZOOM      81
#define CT_OBJECT_CONTAINER 82
#define CT_OBJECT_CONT_ANIM 83
#define CT_LINEBREAK        98
#define CT_USER             99
#define CT_MAP              100
#define CT_MAP_MAIN         101


// Static styles
#define ST_POS            0x0F
#define ST_HPOS           0x03
#define ST_VPOS           0x0C
#define ST_LEFT           0x00
#define ST_RIGHT          0x01
#define ST_CENTER         0x02
#define ST_DOWN           0x04
#define ST_UP             0x08
#define ST_VCENTER        0x0c

#define ST_TYPE           0xF0
#define ST_SINGLE         0
#define ST_MULTI          16
#define ST_TITLE_BAR      32
#define ST_PICTURE        48
#define ST_FRAME          64
#define ST_BACKGROUND     80
#define ST_GROUP_BOX      96
#define ST_GROUP_BOX2     112
#define ST_HUD_BACKGROUND 128
#define ST_TILE_PICTURE   144
#define ST_WITH_RECT      160
#define ST_LINE           176

#define FontM             "Zeppelin32"

class Respawn_button_1 {
  idd = -1;
  movingEnable = false;
  controlsBackground[] = {};
  objects[] = { };
  controls[] = {TOP_BORDER, BOTTOM_BORDER, TITLE_DIALOG, HELP_DIALOG, PRESS_HELP, CAM_LIST, CAM_select, FRIEND_LIST, FRIEND_select, Respawn_1};   

class TOP_BORDER
{
	idc = -1;
	type = CT_STATIC;
	style = ST_CENTER;
	x = -0.2; 
	y = -0.2;
	w = 1.4; 
	h = 0.28;
	font = FontM;
	sizeEx = 0.04;
	colorText[] = { 1, 1, 1, 1 };
	colorBackground[] = {0,0,0,1};
	text = "";
	blinkingPeriod = 20;
};

class BOTTOM_BORDER
{
	idc = -1;
	type = CT_STATIC;
	style = ST_CENTER;
	x = -0.2; 
	y = 0.89;
	w = 1.4; 
	h = 0.25;
	font = FontM;
	sizeEx = 0.04;
	colorText[] = { 1, 1, 1, 1 };
	colorBackground[] = {0,0,0,1};
	text = "";
	blinkingPeriod = 20;
};	

class TITLE_DIALOG
{
	idc = -1;
	type = CT_ACTIVETEXT;
	style = ST_LEFT;
	x = 0.38; 
	y = 0.03;
	w = 0.4; 
	h = 0.04;
	font = FontM;
	sizeEx = 0.04;
	color[] = { 1, 1, 1, 1 };
	colorActive[] = { 1, 0.2, 0.2, 1 };
	soundEnter[] = { "", 0, 1 };   // no sound
	soundPush[] = { "", 0, 1 };
	soundClick[] = { "", 0, 1 };
	soundEscape[] = { "", 0, 1 };
	action = "";
	text = "Unconscious Camera";
	blinkingPeriod = 20;
	default = true;
};

class RscText
{        
	type = CT_STATIC;        
	idc = -1;        
	style = ST_LEFT;        
	colorBackground[] = {0, 0, 0, 0};        
	colorText[] = {1, 1, 1, 1};     
	font = FontM;        
	sizeEx = 0.02;
};

class PRESS_HELP : RscText  
{    
	idc = 10000;    
	style = ST_MULTI; 
	linespacing = 1;   
	x = 0.8;    
	y = 0.92;    
	w = 0.2;    
	h = 0.1;    
	text = ""; 
};


class HELP_DIALOG
{
	idc = -1;
	type = CT_ACTIVETEXT;
	style = ST_LEFT;
	x = 0.8; 
	y = 0.9;
	w = 0.4; 
	h = 0.02;
	font = FontM;
	sizeEx = 0.02;
	color[] = { 1, 1, 1, 1 };
	colorActive[] = { 1, 0.2, 0.2, 1 };
	soundEnter[] = { "", 0, 1 };   // no sound
	soundPush[] = { "", 0, 1 };
	soundClick[] = { "", 0, 1 };
	soundEscape[] = { "", 0, 1 };
	action = "ctrlSetText [10000, ""Keyboard controls:          A/D - Previous/Next target W/S - Previous/Next camera N/M - NV Cam On/Off""]";
	text = "Press for Help";
	blinkingPeriod = 20;
	default = true;
};

class RscLB_C
{
      	style = ST_LEFT;
      	idc = -1;
      	colorSelect[] = {1, 1, 1, 1 };
      	colorSelectBackground[] = {0, 0, 0, 1};
      	colorText[] = {1, 1, 1, 1};
	colorBackground[] = {0, 0, 0, 1};
	colorBorder[] = {0, 0, 0, 0};
	colorShadow[] = {0, 0, 0, 0};
	borderSize = 0;
	font = FontM;
	sizeEx = 0.02; 
      	rowHeight = 0.025;
};

class RscCombo : RscLB_C
{
      	type = CT_COMBO;
      	wholeHeight = 0.3;
};

class CAM_LIST: RscCombo
{
	idc = 10004;
	soundSelect[] = { "", 0, 1 };
	soundExpand[] = { "", 0, 1 };
	soundCollapse[] = { "", 0, 1 };
	x = 0.09; 
	y = 0.03;
	w = 0.1; 
	h = 0.04;
	blinkingPeriod = 20;
};

class CAM_select
{
	type = CT_STATIC;        
	style = ST_LEFT; 
	idc = 10001;
	colorText[] = {1, 1, 1, 1};
	colorBackground[] = {0,0,0,0};
	x = 0.02; 
	y = 0.03;
	w = 0.08; 
	h = 0.04;
	font = FontM;
	sizeEx = 0.02;
	text = "Camera:";
	default = true;
	blinkingPeriod = 20;
};

class FRIEND_LIST: RscCombo
{
	idc = 10005;
	soundSelect[] = { "", 0, 1 };
	soundExpand[] = { "", 0, 1 };
	soundCollapse[] = { "", 0, 1 };
	x = 0.82; 
	y = 0.03;
	w = 0.15; 
	h = 0.04;
	blinkingPeriod = 20;
};

class FRIEND_select
{
	type = CT_STATIC;        
	style = ST_LEFT; 
	idc = 10002;
	colorText[] = {1, 1, 1, 1};
	colorBackground[] = {0,0,0,0};
	x = 0.75; 
	y = 0.03;
	w = 0.08; 
	h = 0.04;
	font = FontM;
	sizeEx = 0.02;
	text = "Target:";
	default = true;
	blinkingPeriod = 20;
};


class Respawn_1 
{
	idc = 1;
	type = CT_BUTTON;
	style = ST_CENTRE;
	default = false;
	font = FontM;
	sizeEx = 0.022;
	colorText[] = { 0, 0, 0, 1 };
	colorFocused[] = { 0.31, 0.31, 0.31, 0.31 };   
	colorDisabled[] = { 0, 0, 1, 0.7 };   
	colorBackground[] = { 1, 1, 1, 0.5 };
	colorBackgroundDisabled[] = { 1, 1, 1, 0.5 };   
	colorBackgroundActive[] = { 0.5, 0.5, 0.5, 0.5 };   
	offsetX = 0.003;
	offsetY = 0.003;
	offsetPressedX = 0.002;
	offsetPressedY = 0.002;
	colorShadow[] = { 0, 0, 0, 0.5 };
	colorBorder[] = { 0.5, 0.5, 0.5, 0.5 };
	borderSize = 0;
	soundEnter[] = { "", 0, 1 };  
	soundPush[] = { "buttonpushed.ogg", 0.1, 1 };
	soundClick[] = { "", 0, 1 };  
	soundEscape[] = { "", 0, 1 };  
	x = 0.85; y = 0.7;
	w = 0.11; h = 0.04;
	text = "RESPAWN 1";
	action = "[1, player] execVM ""revive_sqf\respawn_at_base.sqf""";
};

};