//////////////////////////////////////////////////////////////////
// Function file for Armed Assault
// Created by: Pirin gmail: armapirin
//////////////////////////////////////////////////////////////////
//
//  Version 1.0 - 5/14/2008
//
//////////////////////////////////////////////////////////////////

// Grab passed variables.
_vehicle = _this select 0;
_position = _this select 1;
_unit = _this select 2;

// Check to see if cargo is currently loaded or not...
if (isNull ADCurrentCargo) then {
	if (_position != "driver") exitWith {};  // Passenger with no cargo and we just quit.
		// driver with no cargo:
		
		// Clear the current actions.
		_removeActions = [_vehicle] execVM "removeActions.sqf";
		waitUntil {scriptDone _removeActions};
		
		// Create a load cargo option.
		_listinf = [_vehicle, _unit];  // Form the addAction parameters.
		_action = _vehicle addaction ["Load Cargo", "listcargo.sqf", _listinf];  // Add action to the vehicle for the pilot.	
} else {
	if (_position != "driver") exitWith {
		// There is cargo but we're not the pilot, so kick them out of the plane since it's full.
		_unit sidechat "Sorry! This vehicle is currently carrying cargo and has no room for you!";
		_unit action["EJECT", _vehicle];
	};

	// driver with cargo, so we'll restore the cargo drop option for them:
	// remove current actions.
	_removeActions = [_vehicle] execVM "removeActions.sqf";
	waitUntil {scriptDone _removeActions};
	
	//  Create a drop cargo action.
	_dropinf = [_vehicle, ADCurrentCargo, "message"];  // Form the addAction parameters.
	_droptype = typeof ADCurrentCargo;  // Grab the type of vehicle for the menu label.
	_todrop = format["Release Cargo! [%1][%2]", _droptype, ADCurrentCargo];  // Display menu label: "Release Cargo! [HMMWV][AL12]
	_action = _vehicle addaction [_todrop, "cargo_drop.sqf", _dropinf];	
};
