/* ======================================================================================
  Air Drop Expanded
  Version: 2.0 (ArmA)
  Modifications By: Pirin (www.arma-tow.com / gmail: armapirin)
  Original Author: Kronzky (www.kronzky.info / kronzky@gmail.com)
 ======================================================================================

  Parachutes an item from a plane.

  Place into your mission folder, and call at the desired drop-off point via:
  nul=[plane,object] execVM "dropit.sqf";

  Required parameters:
    'plane'  - Name of the air vehice the item should be dropped out of.
    'object' - Name of the item to be dropped. This item has to be exist somewhere on the map.
    
  Optional parameters:
    "smoke"   - Will create a smoke plume at the landing point.
    "message" - Will display a message with drop-off and landing coordinates.
    "usebox"  - Eject item inside heavier shipping box.

 ====================================================================================== */
//
//  Version 1.0 - 5/14/2008
//
//////////////////////////////////////////////////////////////////

if !(requiredVersion "1.12") exitWith {};

_input = _this select 3;  // This is the 3rd part of the addAction input, it replaced the _this of a self called script.

// Get the plane that will be dropping things.
_carrier = _input select 0;
if (isNil ("_carrier")) exitWith {hint format["Plane not found"]};

// Get the item to be dropped.
_dropitem = _input select 1;
if (isNil ("_dropitem")) exitWith {hint format["Item not found"]};

// TODO:  Make this grab from global variable instead of script input?
_orgitem = _dropitem;
_orgitem allowDammage false;

// Enforcement of drop height.
_currentalt = floor ((getPos _carrier) select 2);
if ((_currentalt > ADmaxdropheight)) exitWith {hint format["Altitude of %1 is too high to drop cargo!", _currentalt]};
if ((_currentalt < ADmindropheight)) exitWith {hint format["Altitude of %1 is too low to drop cargo!", _currentalt]};

// Everything is ok, so remove the action and drop!
// Remove the action from the vehicle.
_removeActions = [_carrier] execVM "removeActions.sqf";
waitUntil {scriptDone _removeActions};

ADCurrentCargo = objNull;

/*
The rest of the script is the same as orginal except for using _input instead of _this, mostly. :)
*/
_message = (("message" in _input) || ("MESSAGE" in _input));

_drop=.2;
_delay=.01;

_forceDrop = (getText (configFile >> "cfgVehicles" >> typeof _dropitem >> "simulation")=="House");
if (("usebox" in _input) || ("USEBOX" in _input)) then {_forceDrop=true};
_velfact=.5;
if (_forceDrop) then {
  _dropitem = "ReammoBox" createVehicle [0,0]; 
  _velfact=.25;
};

_pos=position _carrier;
_vel=velocity _carrier;
_vel=[(_vel select 0) min 20,(_vel select 1) min 20,-10];

_dropitem setDir getDir _carrier;
_z=(_pos select 2)-2;
if (_z<50) then {
  _z=abs((_carrier worldToModel position _carrier) select 2);
};
_zoff=((boundingBox _dropitem select 1) select 2);
_z=_z-_zoff;
_yoff=((boundingBox _dropitem select 1) select 1) - ((boundingBox _carrier select 0) select 1)+2;

if (_message) then {player sidechat format["%1: Dropped at %2 (height: %3m)",getText (configFile >> "CfgVehicles" >> typeof _orgitem >> "displayName"), (_pos),round(_z)]};

_chute = "ParachuteWest" createVehicle [_pos select 0,_pos select 1,_z];
_chute setvelocity [(_vel select 0)*_velfact,(_vel select 1)*_velfact,10];
_pos=getpos _carrier;
_dir=direction _carrier;
_pos=[(_pos select 0)-sin(_dir)*_yoff,(_pos select 1)-cos(_dir)*_yoff,_z];
_chute setpos [_pos select 0, _pos select 1, _z];
_dropitem setpos [_pos select 0, _pos select 1, _z];
_dropitem setvelocity [(_vel select 0)*_velfact,(_vel select 1)*_velfact,10];

while {_z > 0.2} do {
  _dropitem setpos [getpos _dropitem select 0, getpos _dropitem select 1, _z];
  _z=_z-_drop;
  _chute setvelocity [velocity _chute select 0,velocity _chute select 1,10];
  _chute setpos [getpos _dropitem select 0, getpos _dropitem select 1, _z];
  sleep _delay;
};
if (_forceDrop) then {
  sleep .5;
  deleteVehicle _dropitem;
};
_orgitem setpos [getpos _dropitem select 0, getpos _dropitem select 1, 0];
_orgitem setVelocity [0,0,0];
_orgitem setVectorUp [0,0,1];
_orgitem allowDammage true;
if (_message) then {player sidechat format["%1: Landed at %2",getText (configFile >> "CfgVehicles" >> typeof _orgitem >> "displayName"), (position _orgitem)]};

// I lied, I added in a map maker option.
// Add in Map Marker
_mapmarkername = getText (configFile >> "CfgVehicles" >> typeof _orgitem >> "displayName");
_markerobj = createMarker [_mapmarkername, position _orgitem];
_mapmarkername setMarkerShape "ICON";
_mapmarkername setMarkerType "DOT";
_mapmarkername setMarkerText _mapmarkername;

sleep 5;
if !(isNull _chute) then {
  _chute setPos [(getpos _orgitem select 0)+1,(getpos _orgitem select 1)+1,0];
  _chute setvelocity [0,0,0];
};
_orgitem setVectorUp [0,0,1];

if (("smoke" in _input) || ("SMOKE" in _input)) then {
  _smoke = "Logic" createVehicle [(getpos _orgitem select 0)+2,(getpos _orgitem select 1)+2,.5];
  _ps = "#particlesource" createVehicleLocal position _smoke;
  _ps setParticleCircle [0, [0, 0, 0]];
  _ps setParticleRandom [0, [0.25, 0.25, 0], [0.2, 0.2, 0], 0, 0.25, [0, 0, 0, 0.1], 0, 0];
	_ps setParticleParams [["\Ca\Data\ParticleEffects\FireAndSmokeAnim\SmokeAnim.p3d", 8, 3, 1], "", "Billboard", 1, 10, [0, 0, 0], [0, 0, 1], 0, 10, 10, 0.1, [2, 6, 12], [[1, 1, 1, 0.7], [1, 1, 1, 0.15], [1, 1, 1, 0]], [0.125], 1, 0, "", "", _orgitem];
  _ps setDropInterval 0.05;
  sleep 30;
  deleteVehicle _ps;
  deleteVehicle _smoke;
};