//////////////////////////////////////////////////////////////////
// Function file for Armed Assault
// Created by: Pirin gmail: armapirin
//////////////////////////////////////////////////////////////////
//
//  Version 1.0 - 5/14/2008
//
//////////////////////////////////////////////////////////////////

//These are passed via the addAction from the vehicle.
_input = _this select 3;
_vehicle = _input select 0;
_unit = _input select 1;

// Clear messages
hint "";

// Let the pilot know you're looking up what's available.
hint "Checking for cargo...";

// Get a list of Cars in the spawn area.
_inZone = [_unit, ADspawnpoint, ADvehicletypes, ADspawnrange] call ADsqfFindInZone;

// Make sure we've found cargo, if so we'll remove the Load option and replace it with a list of Load Cargo options.
_found = count _inZone;

if (_found > 0) then {
	hint "";
	// Remove the action from the vehicle.
	_removeActions = [_vehicle] execVM "removeActions.sqf";
	waitUntil {scriptDone _removeActions};
		
	{	
		// Form the addAction parameters.
		_loadinf = [_vehicle, _x, ADloadedcargo];  
		_loadtype = typeof _x;  // Grab the type of vehicle for the menu label.
		_toload = format["Load this: [%1][%2]", _loadtype, _x];  // Display menu label: "Release Cargo! [HMMWV][AL12]

		// Add action to the vehicle for the pilot.
		_action = _vehicle addaction [_toload, "loadcargo.sqf", _loadinf];  
	} foreach _inZone;  // Do all the above for valid vehicles in the trigger area.

	hint "";
	hint "Cargo manifest available, please choose now!";
	
} else {
	// No vehicles found that can be transported, so do nothing.
	hint "";
	hint "No cargo found to load!";
};
