//////////////////////////////////////////////////////////////////
// Function file for Armed Assault
// Created by: (AEF)Wolffy.au [2CAV]
// Created: 20090419
// Version: 20090420 - Initial release
// Version: 20090425 - Changelog:
//	- Changed: Shorter startup time
//	- Changed: Weighted random actions changed to random movement
//	followed by random animation.
//	- Changed: SL's will not wander around the camp as it
//	affected other members of group.
//	- Changed: Move to Camp uses random buildingPos
//	- Changed: Minor cosmetic distances
//	- Changed: Move randomly limited to _distance from fire
//	- Removed: Two very long animations until I work out how to
//	cancel a running animation
//	- Removed: Minimum 30 sec idle time between movements
// Contact: http://www.aef-hq.com.au
// Purpose: Animate CARELESS AI infantry group
///////////////////////////////////////////////////////////////////
if (!isServer) exitWith{};
_grp = _this select 0;

{
	sleep random 1;
	[_x] spawn {
		_unit = _this select 0;
		_distance = 10;
		_change = 90;
		
		_unit setBehaviour "CARELESS";
		_unit setSpeedMode "LIMITED";

		_sactions = [
			"AmovPsitMstpSlowWrflDnon",
			"AmovPsitMstpSlowWrflDnon_Smoking",
			"AmovPsitMstpSlowWrflDnon_WeaponCheck1",
			"AmovPsitMstpSlowWrflDnon_WeaponCheck2"
		];
		
		_actions = [
			"AmovPercMstpSlowWrflDnon",
			"AmovPercMstpSlowWrflDnon_seeWatch",
//			"AmovPercMstpSlowWrflDnon_talking",
			"AmovPercMstpSlowWrflDnon_turnL",
			"AmovPercMstpSlowWrflDnon_turnR", 
			"AmovPercMstpSnonWnonDnon_Ease",
			"AmovPercMstpSnonWnonDnon_exercisePushup",
			"AmovPercMstpSnonWnonDnon_exercisekneeBendA",
			"AmovPercMstpSnonWnonDnon_exercisekneeBendB",
			"AmovPercMstpSnonWnonDnon_seeWatch",
//			"AmovPercMstpSnonWnonDnon_talking",
			"AmovPercMwlkSnonWnonDf"
		];
		
		_actions = _actions + [
			"ActsPercMstpSlowWrflDnon_Listening",
			"ActsPercMstpSlowWrflDnon_Lolling",
			"ActsPercMstpSlowWrflDnon_Talking1"
		];

		scopeName "main";
		while {behaviour _unit == "CARELESS"} do {
			_action = floor(random 3);
			// random move action
			switch (_action) do {
				case 0: {
					// move to building
					_pos = position _unit;
					_camps = nearestObjects [_pos, ["Camp"], _distance * 5];
					_camp = _camps select floor(random count _camps);
					_newpos = _camp buildingPos floor(random 5);
					_unit doMove _newpos;
				};
				case 1: {
					// move to fire
					_pos = position _unit;
					_newpos = position (_pos nearestObject "Fire");
					_gap = 1 + (random 2);
					_i = random 360;
					_angle = 0;
					_xg = (_gap * (sin _i));
					_yg = (_gap * (cos _i));
					_x_rot = (_newpos select 0) + _xg*(cos _angle) - _yg*(sin _angle);
					_y_rot = (_newpos select 1) + _xg*(sin _angle) + _yg*(cos _angle);
					_newpos = [ _x_rot, _y_rot];
					_unit doMove _newpos;
				};
				case 2: {
					// move randomly
					if (leader _unit != _unit) then {
						_pos = position _unit;
						_newpos = _pos;
						_gap = random _distance;
						_i = random 360;
						_angle = 0;
						_xg = (_gap * (sin _i));
						_yg = (_gap * (cos _i));
						_x_rot = (_newpos select 0) + _xg*(cos _angle) - _yg*(sin _angle);
						_y_rot = (_newpos select 1) + _xg*(sin _angle) + _yg*(cos _angle);
						_newpos = [ _x_rot, _y_rot];
						_unit doMove _newpos;
					};
				};
			};
			waitUntil{unitReady _unit};

			_action = floor(random 2);
			// random animation
			switch (_action) do {
				case 0: {
					// play random sitting action
					_unit playMove (_sactions select floor(random count _sactions));
				};
				case 1: {
					// play random standing action
					_unit playMove (_actions select floor(random count _actions));
				};
			};

			_sleep = random _change;
			for "_i" from 1 to _sleep do {
				if (behaviour _unit == "CARELESS") then {
					sleep 1;
				} else {
					breakTo "main";
				};
			};
		};
		_unit playMove "null";
	};
} forEach units _grp;
