//////////////////////////////////////////////////////////////////
// Function file for Armed Assault
// Created by: (AEF)Wolffy.au [2CAV]
// Created: 20090419
// Version: 20090419 - Initial release
// Version: 20090425 - Changelog:
//	- Fixed: Bugs in unit and vehicle creation
//	- Fixed: No longer added vehicles to infantry group as inf
//	were mounting and driving over tents
//	- Changed: Shorter startup time
//	- Changed: Number of tents based on total number of units
//	- Changed: Tent distance from fire randomised and increases
//	- Changed: Increased detection radius from 100m to 300m
//	- Changed: Infantry only mount UAZ's when activated
//	- Changed: Infantry go COMBAT and RED (Open fire, Engage at
//	Will) when activated
//	- Added: Clear trees, rocks, etc beforehand with number of
//	tents and vehicles
//	- Added: Random barrels and pallets in camp vicinity
// Contact: http://www.aef-hq.com.au
// Purpose: Randomly setup an enemy camp of different setups
///////////////////////////////////////////////////////////////////
if (!isServer) exitWith{};
sleep random 1;
_setup = ceil(random 15);
_objs = [];
_vehs = [];
_units = [];

if (_setup - 8 >= 0) then {
	_vehs = _vehs + ["ACE_Ural"];
	_units = _units + ["ACE_SquadLeaderE","ACE_SoldierE_SR","ACE_SoldierEB","ACE_SoldierEB","ACE_SoldierEG","ACE_SoldierERPG","ACE_SoldierERPGAB"];
	_setup = _setup - 8;
};
if (_setup - 4 >= 0) then {
	_vehs = _vehs + ["ACE_Ural_Open"];
	_units = _units + ["ACE_SquadLeaderE","ACE_SoldierE_SR","ACE_SoldierEB","ACE_SoldierEB","ACE_SoldierEG","ACE_SoldierERPG","ACE_SoldierERPGAB"];
	_setup = _setup - 4;
};
if (_setup - 2 >= 0) then {
	_vehs = _vehs + ["ACE_UAZ_AGS30"];
	_units = _units + ["ACE_TeamLeaderE","ACE_SoldierEAA","ACE_SoldierEAAAB"];
	_setup = _setup - 2;
};
if (_setup - 1 >= 0) then {
	_vehs = _vehs + ["ACE_UAZ_MG"];
	_units = _units + ["ACE_TeamLeaderE","ACE_SoldierEAA","ACE_SoldierEAAAB"];
	_setup = _setup - 1;
};

for "_i" from 0 to ceil(count _units / 6) - 1 do {
	if (_i mod 2 == 0) then {
		_objs = _objs + ["CampEast"];
	} else {
		_objs = _objs + ["CampEastC"];		
	};
};

_pos = _this select 0;
_vobjs = [];
_uobjs = [];
_uid = format["SC%1", floor(random 10000)];
call compile format["%1 = []", _uid];

// clear trees
_rad = 15;
_cobjs = nearestObjects [_pos, [], _rad];

{
	if (_x != player) then {
		deleteCollection _x;
	};
} forEach _cobjs;

//hint "Create objs";
_fire = "FireLit"	createVehicle _pos;
_firepos = position _fire;
_gap = 5 + (count _objs + count _vehs);
_j = 0;
_a = 360 / (count _objs + count _vehs);
_aoff = random 360;
{
	_i = _j * _a + _aoff;
	_angle = 0;
	_xg = (_gap * (sin _i));
	_yg = (_gap * (cos _i));
	_x_rot = (_firepos select 0) + _xg*(cos _angle) - _yg*(sin _angle);
	_y_rot = (_firepos select 1) + _xg*(sin _angle) + _yg*(cos _angle);
	_tmp = _x createVehicle [ _x_rot, _y_rot];
	_tmp setDir _i;
	_tmp setPos [getPos _tmp select 0, getPos _tmp select 1, ((getPos _tmp select 2) + 0)];
	_tmp setVectorUp [0, 0, 1];
	
	_j = _j + 1;
} forEach _objs;

//hint "Create Junk";
_junk = [
	"Vysilacka",
	"Barrels",
	"Barrel1",
	"Barrel2",
	"Barrel3",
	"Barrel4",
	"Barrel5",
	"Barrel6",
	"Paleta1",
	"Paleta2"
];
{
	_i = random 360;
	_angle = 0;
	_xg = (_gap * (sin _i));
	_yg = (_gap * (cos _i));
	_x_rot = (_firepos select 0) + _xg*(cos _angle) - _yg*(sin _angle);
	_y_rot = (_firepos select 1) + _xg*(sin _angle) + _yg*(cos _angle);
	_tmp = (_junk select floor(random count _junk)) createVehicle [ _x_rot, _y_rot];
	_tmp setPos [getPos _tmp select 0, getPos _tmp select 1, ((getPos _tmp select 2) + 0)];
	_tmp setVectorUp [0, 0, 1];
} forEach _objs;

//hint "Create units";
createCenter EAST;
WEST setFriend [EAST, 0];
EAST setFriend [WEST, 0];
Resistance setFriend [EAST, 0];
EAST setFriend [Resistance, 0];
_grp = createGroup EAST;

//hint "Create vehs";
{
	_gap = random 10  + count _objs + count _vehs;
	_i = _j * _a + _aoff;
	_angle = 0;
	_xg = (_gap * (sin _i));
	_yg = (_gap * (cos _i));
	_x_rot = (_firepos select 0) + _xg*(cos _angle) - _yg*(sin _angle);
	_y_rot = (_firepos select 1) + _xg*(sin _angle) + _yg*(cos _angle);
	_tmp = _x createVehicle [ _x_rot, _y_rot];
	_tmp setDir (random 360);
	_tmp setPos [getPos _tmp select 0, getPos _tmp select 1,((getPos _tmp select 2) + 1)];
	_tmp setVectorUp [0, 0, 1];
	_tmp addWeaponCargo ["ACE_Strela", 5];
	_vobjs = _vobjs + [_tmp];
	_j = _j + 1;
} forEach _vehs;

{
	_tmp = _grp createUnit [_x, _firepos, [], 10, "NONE"];
	_uobjs = _uobjs + [_tmp];
} forEach _units;

//hint "Create trigs";
_trigrad = 300;
_trig = createTrigger ["EmptyDetector", _pos];
_trig setTriggerActivation ["WEST", "EAST D", true];
_trig setTriggerArea [_trigrad, _trigrad, 0, false];
_trig setTriggerStatements ["this", format["%1 = thisList;", _uid], ""];

_script = [_grp] execVM "RelaxedAI.sqf";

waitUntil{call compile format["count %1 != 0", _uid]};
hint "You have been discovered!";
{
	if (_x isKindOf "UAZMG") then {
		_grp addVehicle _x;
		_u = _uobjs select floor(random(count _uobjs));
		_u assignAsGunner _x;
		[_u] orderGetIn true;
	};
} forEach _vobjs;
	
{
	_x setBehaviour "COMBAT";
	_x setSpeedMode "FULL";
	_x setCombatMode "RED";
} forEach _uobjs;

units _grp orderGetIn true;