// SPON Core v0.5.1 (Mission-script version)
//
// Copyright (C) 2007-8 Bil Bas (bil {dot} bagpuss [at] gmail {dot} com / Spooner)
// License: GNU Lesser General Public License, version 3 <http://www.gnu.org/licenses/>

// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Core\initSort
//
// Description:
//   Creates functions that allow arrays to be sorted (SPON_sort,
//   SPON_sortNumbers and SPON_sortStrings).
//
// Parameters:
//   none
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "macros\macros.inc.sqf"

// ------------------------------------------------------------------------------
// Description:
//   Sorts an array given a comparison function to work with.
//
//   Note: The current implementation uses the QuickSort algorithm.
//
// Parameters:
//   0: _array - What to sort [Array]
//   1: _comparison - Function that compares two elements of _array, returning
//       true if the first element is greater than the second element 
//       [Code that returns boolean]
//
// Return:
//   Sorted array [Array]
//
// ------------------------------------------------------------------------------
SPON_sort =
{
	SPON_GET_PARAMS_2(_array,_comparison);
	
	if ((count _array) <= 1) exitWith { _array };
	
	_pivot = _array select 0;
	
	_less = [];
	_greater = [];
	
	for "_i" from 1 to ((count _array) - 1) do
	{
		if ([_array select _i, _pivot] call _comparison) then
		{
			SPON_PUSH(_greater,_array select _i);
		}
		else
		{
			SPON_PUSH(_less,_array select _i);
		};
	};
	
	([_less] call SPON_sortStrings) + [_pivot] +
		([_greater] call SPON_sortStrings); // Return.
};

// ------------------------------------------------------------------------------
// Function: SPON_sortStrings
//
// Description:
//   Sorts an array of strings.
//
// Parameters:
//   0: _array - List of strings to sort [Array of String]
//   1: _reverse - Whether to sort alphabetically (true) or reverse
//        alphabetically (false) [Boolean, defaults to false]
//
// Return:
//   Sorted array [Array]
//
// ------------------------------------------------------------------------------
SPON_sortStrings =
{
	SPON_GET_PARAMS_1(_array);
	SPON_GET_DEFAULT_PARAM(1,_reverse,false);
	
	private "_comparison";
	
	if (_reverse) then
	{
		_comparison = { (_this call SPON_compareStrings) < 0 };
	}
	else
	{
		_comparison = { (_this call SPON_compareStrings) > 0 };
	};
	
	[_array, _comparison] call SPON_sort; // Return.
};

// ------------------------------------------------------------------------------
// Function: SPON_sortNumbers
//
// Description:
//   Sorts an array of numbers.
//
// Parameters:
//   0: _array - List of numbers to sort [Array of Number]
//   1: _reverse - Whether to sort in ascending (true) or decending (false) order
//        [Boolean, defaults to false]
//
// Return:
//   Sorted array [Array]
//
// ------------------------------------------------------------------------------
SPON_sortNumbers =
{
	SPON_GET_PARAMS_1(_array);
	SPON_GET_DEFAULT_PARAM(1,_reverse,false);
	
	private "_comparison";
	
	if (_reverse) then
	{
		_comparison = { (_this select 0) < (_this select 1) };
	}
	else
	{
		_comparison = { (_this select 0) > (_this select 1) };
	};
	
	[_array, _comparison] call SPON_sort; // Return.
};

// ------------------------------------------------------------------------------

// TODO: Make this actually work ;P
SPON_sortNumbers2 =
{
	SPON_GET_PARAMS_1(_array);
	
	_sort =
	{
		SPON_GET_PARAMS_3(_array,_from,_to);
		
		if ((_to - _from) <= 1) exitWith { _array };
		
		_pivot = _array select _from;
		
		_less = [];
		_greater = [];
		
		for "_i" from (_from + 1) to _to do
		{
			if ((_array select _i) > _pivot) then
			{
				SPON_PUSH(_greater,_array select _i);
			}
			else
			{
				SPON_PUSH(_less,_array select _i);
			};
		};
		
		([_less] call SPON_sort) + [_pivot] + ([_greater] call SPON_sort);
	};
	
	[_array, 0, (count _array) - 1] call _sort; // Return.
};

nil; // Return.
