// Must initiate SPON Core before the rangefinder.
["DEBUG_CLIENT_SERVER"] call compile preprocessFileLineNumbers "SPON\Core\initCore.sqf";

// Using default values, but show the map markers.
[] call compile preprocessFileLineNumbers "SPON\Rangefinder\initRangefinder.sqf";

// Enable map marker at laser position, though this is not enabled by default.
[true] call SPON_RF_enableMapMarker;

// Start using NATO-standard mils.
[6400] call SPON_RF_setMilsPer360Degrees;

// -----------------------------------------------------------------------------
// Specific for the demo, show smoke where the detected laser is targetted.
#include "SPON\Rangefinder\macros\macros.inc.sqf"

// Use this for testing extreme range lasers.
//setViewDistance 10000;

// Example of how to run code when a laser designator is used to mark a target.
private "_targetFoundHandler";
_targetFoundHandler =
{
	private ["_target", "_firer", "_targetPos"];
	_target = _this select 0;
	_firer = _this select 1;
	_targetPos = _this select 2;
	
	SPON_TRACE_3("SPON_laserTargetFound handler (demo init)",_target,_firer,_targetPos);
	
	// If detected on the client, show smoke rising from the position
	// of the target as long as it exists.
	if ((not (isNull _target)) and SPON_isClient) then
	{
		[_target] spawn
		{
			private "_target";
			_target = _this select 0;
			
			waitUntil
			{
				drop ["\ca\data\Cl_basic", "", "Billboard", 1.5, 5,
					[0, 0, 0], [0, 0, 0], 0, 1, 1, 1, [1, 3, 9],
					[[1, 0, 0, 0.1], [1, 0, 0, 0.1], [1, 0, 0, 0.05]],
					[0], 0, 0, "", "", _target];
					
				isNull _target; // Condition
			};
		};
	};
};

//["SPON_RF_targetFound", _targetFoundHandler] call SPON_addEventHandler;

// Track the harrier's movement.
[] spawn
{
	waitUntil
	{
		"harrier" setMarkerPosLocal (getPos harrier);
	};
};

for "_i" from 0 to 20 do
{
	hint ("-= SPON Rangefinder Demo =-\n\n" +
		"Use the Laser Marker to paint a laser target onto something, as normal, but notice that range, azimuth and elevation information are also shown.\n\n" +
		"When looking through the laser marker, use your reload key (defaults to 'R') to cycle through the angle modes displayed by the rangefinder.\n\n" +
		"If the soldier using the laser has GPS, then a map icon is shown to players on same side, at the laser marker position.\n\n" +
		"Smoke is shown at the target position too, but only for this demo! Look at the init.sqf for an example of how to perform actions when a target is painted.\n\n" +
		"(Both marker and event-based effects, like the smoke used in the demo, are MP compatible).");
		
	sleep 1;
};

nil; // Return.