_plane = _this select 0;
ccip_enabled = false;
_plane addEventHandler["fired", {_this execVM "ccip_fired.sqf"}];
_plane addEventHandler["getin", {_this execVM "ccip_getin.sqf"}];
_plane addEventHandler["getout", {_this execVM "ccip_getout.sqf"}];

_targetElevation = 0;

_Logic = "Logic" createVehicleLocal [0,0,0];


while {alive _plane} do
{
  if (ccip_enabled) then
  {
    if (_targetElevation != _targetElevation) then {_targetElevation = 0};

    //Calculate impact time
    //=====================
    _g = 9.8;
    _v = velocity _plane;
    _vz0 = _v select 2; //initiall fall velocity

    //by solving the quadratic equation we will get the estimated freefall time
    _a = -0.5*_g;
    _b = _vz0;
    _c = ((getposASL _plane) select 2) - _targetElevation;

    _t = (-_b - sqrt (_b*_b - 4 *_a*_c))/(2*_a);

    _px = getpos _plane select 0;
    _py = getpos _plane select 1;

    _vx = _v select 0;
    _vy = _v select 1;

    //impact position calculated by
    _pos = [_px + (_vx*_t), _py + (_vy*_t)];

    _Logic setpos _pos;
    _targetElevation = (getPosASL _Logic) select 2;

    [group (driver _plane),1] setWaypointDescription format ["ASL:%1, TTI:%2", floor _targetElevation, floor _t];
    [group (driver _plane),1] setWpPos _pos;


  };
  sleep .01;
};

deleteVehicle _Logic;
_plane removeAllEventHandlers "fired";
_plane removeAllEventHandlers "getin";
_plane removeAllEventHandlers "getout";