// __________________________________________________
// | Coop Essential Pack by -eutf-Myke              |
// |________________________________________________|
// | Basic Settings script. Change to your needs.   |
// | cep_edit_me.sqs                                |
// |________________________________________________|

if (! isServer) exitwith {};


// Group sizes. Edit these Lines to change the created group sizes to your needs
// _cep_xxxxx_grpsize_min: at least so many Units/Vehicles will be in one group
// _cep_xxxxx_grpsize_max: not more than this will be in one group
// These settings are used for all created Groups

// First part: Heavy armored vehicles
_cep_armored_grpsize_min = 1;
_cep_armored_grpsize_max = 2;
_cep_armored_grpsize = [_cep_armored_grpsize_min, _cep_armored_grpsize_max];

// Second part: Light armored vehicles
_cep_light_grpsize_min = 1;
_cep_light_grpsize_max = 3;
_cep_light_grpsize = [_cep_light_grpsize_min, _cep_light_grpsize_max];

// Third part: Armed cars
_cep_armed_grpsize_min = 2;
_cep_armed_grpsize_max = 3;
_cep_armed_grpsize = [_cep_armed_grpsize_min, _cep_armed_grpsize_max];

// Fourth part: Unarmed Cars
_cep_unarmed_grpsize_min = 1;
_cep_unarmed_grpsize_max = 2;
_cep_unarmed_grpsize = [_cep_unarmed_grpsize_min, _cep_unarmed_grpsize_max];

// Fifth part: Standard Infantry patrols
_cep_standard_grpsize_min = 4;
_cep_standard_grpsize_max = 10;
_cep_standard_grpsize = [_cep_standard_grpsize_min, _cep_standard_grpsize_max];

// Sixth part: SpecOps Infantry patrols
_cep_specops_grpsize_min = 2;
_cep_specops_grpsize_max = 5;
_cep_specops_grpsize = [_cep_specops_grpsize_min, _cep_specops_grpsize_max];

// Seventh part: Basic AI behaviours
// Set these Parameters as you need.
_cep_group_behaviour = "SAFE";
_cep_group_speed = "LIMITED";
_cep_group_combatmode = "RED";
_cep_group_formation = "FILE";
_cep_group_skill = 1;
_cep_group_fleeing = 0;

// Eigth part: Civilian Weapons
// Add array [weapon classname, [magazine classname, number of magazines], [magazine classname, number of magazines]
_cep_civ_prime = [["AK74", ["30Rnd_545x39_AK", 4]], ["AK74GL", ["30Rnd_545x39_AK", 4], ["1Rnd_HE_GP25", 3]]];
_cep_civ_second = [["RPG7V", "PG7V", 3], ["STRELA", "STRELA", 1], ["RPG7V", "PG7V", 3]];
_cep_civ_hand = [["Makarov", "8Rnd_9x18_Makarov", 4]];
// --------------------------------------------------------------------------------------------
// Do not change the following parts!
// --------------------------------------------------------------------------------------------
cep_grpsize_def = [_cep_armored_grpsize, _cep_light_grpsize, _cep_armed_grpsize, _cep_unarmed_grpsize, _cep_standard_grpsize, _cep_specops_grpsize];
cep_group_behave = [_cep_group_behaviour, _cep_group_speed, _cep_group_combatmode, _cep_group_formation, _cep_group_skill, _cep_group_fleeing];
cep_civ_weapons = [_cep_civ_prime, _cep_civ_second, _cep_civ_hand];