// _________________________________________________________________________________________________________________________________________________________________________
// | Coop Essential Pack by -eutf-Myke                                                                                                                                      |
// |________________________________________________________________________________________________________________________________________________________________________|
// | Do not change this scrip!                                                                                                                                              |
// |________________________________________________________________________________________________________________________________________________________________________|
// | cep zone script                                                                                                                                                        |
// | nul =[triggername, zonesize, treshold distance, [[EAST, [armored],[light],[armed],[unarmed],[standard],[specops], [Behave_array]]]] exec "coop_essential\cep_zone.sqf" |
// |________________________________________________________________________________________________________________________________________________________________________|

if (! isServer) exitwith{};
waituntil {(cep_init_done)};
_cep_zone_center = _this select 0;
_cep_zone_radius = _this select 1;
_cep_treshold_offset = _this select 2;
_cep_create_array = _this select 3;
_cep_zone_treshold = _cep_zone_radius + _cep_treshold_offset;
_cep_armed_waypoints = [];
_cep_units_waypoints = [];
_cep_cust_wp = [];
_cep_armed_nowp = 0;
_cep_units_nowp = 0;
_cep_custom_list = [];
_cep_opos = getpos _cep_zone_center;
_cep_oxc = _cep_opos select 0;
_cep_oyc = _cep_opos select 1;
_cep_custom_list = _cep_opos nearobjects ["Logic", _cep_zone_radius];
_cep_typeof_wp = getdir (_cep_custom_list select 0);
if (cep_editor_mode) then
	{
	_nul = [_cep_zone_center, _cep_zone_radius, _cep_treshold_offset] execVM "coop_essential\cep_editor_scripts\cep_zone_marker.sqf";
	};

switch (count _cep_custom_list) do
	{
	case 1 :
		{
		_cep_waypoints = waypoints (_cep_custom_list select 0);
			{
			_cep_cust_wp = _cep_cust_wp + [getwppos _x];
			}
		foreach _cep_waypoints;
		if (cep_editor_mode) then
			{
			_nul = [_cep_cust_wp, "ColorBlue"] execVM "coop_essential\cep_editor_scripts\cep_wp_marker.sqf";
			};
		};
	case 0 :
		{
		if (true) exitwith {};
		};
	default
		{
		if (true) exitwith {hintc format ["Only 1 Gamelogic is supported for each zone.\n%1 Gamelogics detected!", count _cep_custom_list]};
		};
	};
while {count _cep_armed_waypoints <= round (_cep_zone_radius / 4)} do
	{
	if (_cep_armed_nowp == (round (_cep_zone_radius))) exitwith {hint format ["Could not create enough waypoints for vehicles!\nPlease make area bigger or move it!\n Waypoints created: %1 of %2", count _cep_armed_waypoints, (round (_cep_zone_radius / 4))]};
	_cep_dir = random 360;
	_cep_nxc = _cep_oxc + ((random _cep_zone_radius))* sin _cep_dir;
	_cep_nyc = _cep_oyc + ((random _cep_zone_radius))* cos _cep_dir;
	_cep_armed_nowp = _cep_armed_nowp + 1;
	if (! surfaceiswater [_cep_nxc, _cep_nyc]) then
		{
		if (count ([_cep_nxc, _cep_nyc] nearobjects ["Static", 15]) == 0) then
			{
			_cep_armed_waypoints = _cep_armed_waypoints + [[_cep_nxc, _cep_nyc]];
			};
		};
	sleep 0.02;
	};
if (cep_editor_mode) then
	{
	_nul = [_cep_armed_waypoints, "ColorRed"] execVM "coop_essential\cep_editor_scripts\cep_wp_marker.sqf";
	};
if (count _cep_cust_wp != 0) then
	{
	if ((_cep_typeof_wp >= 120) and (_cep_typeof_wp <= 360)) then
		{
		_cep_armed_waypoints = _cep_armed_waypoints + _cep_cust_wp;
		};
	};
while {count _cep_units_waypoints <= round (_cep_zone_radius / 2)} do
	{
	if (_cep_units_nowp == (round (_cep_zone_radius * 2))) exitwith {hint format ["Could not create enough waypoints for infantry!\nPlease make area bigger or move it!\n Waypoints created: %1 of %2", count _cep_units_waypoints, (round (_cep_zone_radius / 2))]};
	_cep_dir = random 360;
	_cep_nxc = _cep_oxc + ((random _cep_zone_radius))* sin _cep_dir;
	_cep_nyc = _cep_oyc + ((random _cep_zone_radius))* cos _cep_dir;
	_cep_units_nowp = _cep_units_nowp + 1;
	if (! surfaceiswater [_cep_nxc, _cep_nyc]) then
		{
		if ( count ([_cep_nxc, _cep_nyc] nearobjects ["Static", 5]) == 0) then
			{
			_cep_units_waypoints = _cep_units_waypoints + [[_cep_nxc, _cep_nyc]];
			};
		};
	sleep 0.02;
	};
if (cep_editor_mode) then
	{
	_nul = [_cep_units_waypoints, "ColorGreen"] execVM "coop_essential\cep_editor_scripts\cep_wp_marker.sqf";
	};
if ((count _cep_armed_waypoints == 0) and (count _cep_unitswaypoints == 0)) exitwith {hintc format ["cep couldn't create any waypoints!\n\nZone creation aborted: %1", _cep_zone_center];};
if (count _cep_cust_wp != 0) then
	{
	if ((_cep_typeof_wp >= 0) and (_cep_typeof_wp <= 240)) then
		{
		_cep_armed_waypoints = _cep_armed_waypoints + _cep_cust_wp;
		};
	_cep_units_waypoints = _cep_units_waypoints + _cep_cust_wp;
	};

if (cep_editor_mode) then
	{
	_cep_msg_zone =   format ["Zone size: %1", _cep_zone_radius];
	_cep_msg_trigger= format ["Triggering distance: %1", _cep_zone_treshold];
	_cep_msg_veh =    format ["Vehicles waypoints: %1", count _cep_armed_waypoints];
	_cep_msg_units =  format ["Infantry waypoints: %1", count _cep_units_waypoints];
	_cep_msg_custom = format ["Custom waypoints: %1", count _cep_cust_wp];
	_cep_msg = format ["Zone %6 status report:\n\n%1\n%2\n%3\n%4\n%5", _cep_msg_zone, _cep_msg_trigger, _cep_msg_veh, _cep_msg_units, _cep_msg_custom, _cep_zone_center];
	hint _cep_msg;
	};

waituntil {((cep_playerside countside (position _cep_zone_center nearobjects ["AllVehicles", _cep_zone_treshold])) != 0)};
deletevehicle _cep_zone_center;
{
_nul = [_x, _cep_armed_waypoints, _cep_units_waypoints, _cep_treshold_offset] execVM "coop_essential\cep_prepare.sqf";
}
foreach _cep_create_array;