// *****************************************************
// *** coupDeGrace.sqf, Version .8
// *** By JohnnyBoy
// ***
// *****************************************************
// Put the following call in a unit's init or in a trigger that
// fires when a unit dies.
//
// [targetUnit,[grp1,grp2], true] execvm "coupDeGrace.sqf"
// Parameters:
// * targetUnit  <== dead unit to be shot
// * [grp1,grp2] <== Array of groups that are potential shooters
// * true        <== true/false boolean that toggles voice taunts on/off
// *
// Important Note:  You need global variables set in your INIT.SQS as 
//                  shown in sample mission.

_targetUnit = _this select 0;
_grps = _this select 1;
_tauntOn = _this select 2;

_shooters = [];
//player sidechat format ["count grps=%1", (count _grps)];
for "_i" from 0 to ((count _grps) - 1) do
{
    _shooters = _shooters + units (_grps select _i);
};

//********************************************************************
// We remove AT and GL soldiers from list of potential shooters because
// stupid AI will choose to use the Rocket or GL for point-blank coup de grace shot.
//
// Also remove group leaders from potential shooters, because this insures
// group will continue moving to waypoints.
//**********************************************************************
_at_shooters = [];
for "_i" from 0 to ((count _shooters) - 1) do
{
    _shooter = _shooters select _i;
    if ((primaryWeapon _shooter in ["M16A2GL","M16A4_GL","M16A4_ACG_GL","M4GL","AK74GL"]) or (_shooter hasWeapon "M136" or _shooter hasWeapon "RPG7V") or (_shooter == leader group _shooter)) then
    {
       _at_shooters = _at_shooters + [_shooter];
    };
};
_shooters = _shooters - _at_shooters;
_cnt      = count (_shooters);

//**********************************************************************
//*** Sleep until target unit dead
//**********************************************************************
while {alive(_targetUnit)} do 
{
  sleep 2;
};
//player sidechat "after target dead, before shooter near";

//**********************************************************************
//*** Loop until a shooter unit is close enough to dead target unit
//**********************************************************************
_shooterNear = false;
_x = 0;
While {!(_shooterNear)} do 
{
   _shooter = _shooters select _x;
   _distance = _shooter distance _targetUnit;
   if (_distance <= 5 and !(_shooter == player) and (_shooter == vehicle _shooter) and not((_shooters select _x) in gCDGshooters) ) then
   {
      gCDGshooters = gCDGshooters + [_shooters select _x];
      _shooterNear = true;
   }
   else
   {
      sleep .1;
      _x = _x + 1;
//    reset subscript to zero so we start at beginning of unit array again.
      if (_x == _cnt) then
      {
         _x = 0;
         sleep 1;
      }
   } 
};

_shooter = _shooters select _x;

if ( count(gCDGTargets) > 0 ) THEN 
{
  dostop _shooter;
  _trg = gCDGTargets select ((count gCDGTargets) - 1);
  gCDGTargets = gCDGTargets - [_trg];

  _pos = (_targetUnit modelToWorld [0,0,0]); 
  _trg setpos (_targetUnit modelToWorld [0,.3,-.5]); 
  sleep .5;
       
//*** Event handler moves target, so shooter only fires on it once.
//*** It also setsdammage to zero, so shooter no longer aims at targets 
//*** last position.  DeleteVehicle did not work here:  AI still pointed
//*** at last position of target, so moving and damaging target instead.
  _idx = _shooter addEventHandler ["Fired",{}];
  _shooter removeEventHandler ["Fired", _idx];
  _str = format ["%2 setpos [0,0,0]; %2 setdammage 1; (_this select 0) removeEventHandler [""Fired"", %1]; (_this select 0) setUnitPOs ""AUTO"";", _idx,_trg];
  _idx = _shooter addEventHandler ["Fired",_str];

  _shooter reveal _trg;
  _shooter setUnitPos "UP"; 
  _shooter dotarget _trg; 
  _distance = _shooter distance _targetUnit;
//player sidechat format ["dist=%1",_distance];

// Shooter won't fire on target if too close, so we move him a little to where
// he will shoot.  Minimum distance required before unit shoots seems to vary from
// 2.25 meters to 2.8 meters--not sure what drives that AI decision.

  while {(_shooter distance _targetUnit) <= 2.5} do
  {
     _shooter domove (_shooter modelToWorld[0,2.5,0]);
     while {!(unitReady _shooter)} do
     {
        sleep .05;
     };
     sleep .05;
  };
  dostop _shooter;



  _shooter dotarget _trg; 
// Move target toward shooter a bit so angle of shot more likely to hit corpse.
  _dirToShooter = [_trg,_shooter] call DirToObj;
  _trg setdir _dirToShooter;
  _trg setpos (_trg modelToWorld [0, -.7, -.6]); 
  sleep .1;
  if (_tauntOn and (count gCDGtaunts > gCDGtauntsIDX) ) then 
  {
// ***** We increment the taunts index so each taunt only used once.
    gCDGtauntsIdx = gCDGtauntsIdx + 1;
     _shooter say (gCDGtaunts select (gCDGtauntsIdx -1));
  };
//  dumTrg setpos getpos _trg;
  _shooter dotarget _trg; 
  sleep .7;
  _shooter dofire _trg;
  sleep 5;
  _shooter dofire _trg;
//  player sidechat "b4 dofollow";
  _shooter dofollow leader _shooter;

   gCDGshooters = gCDGshooters - [_shooter];
  // Delete vehicle after 100 seconds.
  sleep 10;
  _shooter dotarget objnull;
  // In rare cases, the shooter has been assigned two targets, and the eventhandlers
  // that move and damage the targets get confused, and leave on target in place, which
  // causes shooter to continually shoot target.  Following lines should prevent this.
  _trg setpos [0,0,0]; 
  _trg setdammage 1;
  _shooter setUnitPos "AUTO"; 
  sleep 1;
  deleteVehicle _trg;
};
