/*
Script: ESC (Easy Sector Control)
File: create_triggers.sqf
Version: 0.6
Author: g_n_o_s_i_s
Email: mats@ronin-group.org

Arguments:
0. Sector Marker (String)
1. Side (String)
*/
private["_sectormarker", "_side", "_sectorpos", "_conditionstring1", 
		  "_activationstring1", "_activationstring2", "_conditionstring3", "_activationstring3"];

_getsectortext = {
	private["_sectormarker"];
	_sectormarker = _this select 0;
	if (markerText _sectormarker == "") then {
		_sectormarker
	} else {
		markerText _sectormarker
	};
};

_sectormarker = _this select 0;
_side = _this select 1;
_sectorpos = getMarkerPos _sectormarker;
_sectortext = [_sectormarker] call _getsectortext;

if (GNO_debug) then {player globalChat format["DEBUG: CREATING TRIGGERS %1 FOR %2", _sectormarker, _side]};

call compile format["team = GNO_%1name", _side]; // Converts side to user specified names
call compile format["GNO_%1 = 'NONE'", _sectormarker]; //Sets variable which tracks team holding sector
call compile format["GNO_%1_captured = false", _sectormarker];

if (!isServer || !GNO_dedicated) then {
	flipflag = compile preprocessFile "esc\flip_flag.sqf";
	
	_conditionstring1 = format["this && GNO_%1 != '%2' && {alive _x} count thislist > 0 && !GNO_gameover", _sectormarker, _side];
	_activationstring1 = format["titleText['%1 is being captured by %2', 'PLAIN']", _sectortext, team];
	_activationstring2 = format["['%1', thislist] call flipflag; titleText['%2 has captured %3', 'PLAIN']", _sectormarker, team, _sectortext];

	// Trigger to display capturing text.
	_trigger1 = createTrigger["EmptyDetector", _sectorpos];
	_trigger1 setTriggerActivation[_side, "present", true];
	_trigger1 setTriggerArea[GNO_triggersize, GNO_triggersize, 0, false];
	_trigger1 setTriggerStatements[_conditionstring1, _activationstring1, ""];
	
	// Trigger to display captured text.
	_trigger2 = createTrigger["EmptyDetector", _sectorpos];
	_trigger2 setTriggerActivation[_side, "present", true];
	_trigger2 setTriggerArea[GNO_triggersize, GNO_triggersize, 0, false];
	_trigger2 setTriggerTimeout[GNO_capturedelay, GNO_capturedelay, GNO_capturedelay, true];
	_trigger2 setTriggerStatements[_conditionstring1, _activationstring2, ""];
};
	
if (isServer) then {
	scoresys = compile preprocessFile "esc\score_sys.sqf";
	_conditionstring3 = format["this && GNO_%1_captured", _sectormarker];
	_activationstring3 = format["['%1', '%2'] spawn scoresys", _sectormarker, _side];

	// Trigger exectuted on server only to start scoring.
	_trigger3 = createTrigger["EmptyDetector", _sectorpos];
	_trigger3 setTriggerActivation[_side, "present", true];
	_trigger3 setTriggerArea[GNO_triggersize, GNO_triggersize, 0, false];
	_trigger3 setTriggerStatements[_conditionstring3, _activationstring3, ""];
};


