/*
Script: ESC (Easy Sector Control)
File: init_esc.sqf
Version: 0.6
Author: g_n_o_s_i_s
Email: mats@ronin-group.org
*/

// Customization Variables.

GNO_timelimit = 600; 		//Timelimit to end game.
GNO_scorelimit = 500; 		//Scorelimit to end game.
GNO_initialscore = 5; 		//Initial score given upon sector capture.
GNO_repeatscore = 10; 		//Score given for each time span held.
GNO_repeattime = 30; 		//Time span to give score to team.
GNO_capturedelay = 5; 		//Delay to capture a sector.
GNO_scoreboarddelay = 15;	//Time span between scoreboard show.  At default 15 it shows all the time.
GNO_triggersize = 5;		//Size of trigger that captures a sector.
GNO_westname = "US";		//Team name for side west.
GNO_eastname = "SLA";		//Team name for side east.
GNO_guername = "RACS";		//Team name for side guer.

GNO_debug = false;		//true or false.
GNO_dedicated = true; 		//true or false. When designing and testing on local machine set this to false

//Tweaks to line up scores on  scoreboard, makes it look nicer. Why oh why can't they allow tabs in texts.
// Use empty string, ie "", to remove a side from scoreboard.
GNO_westscoreboardname = "US:    ";
GNO_eastscoreboardname = "SLA:   ";
GNO_guerscoreboardname = "RACS: ";

// GNO_timelimit = param1; //Uncomment to tie into description.ext for timelimit.
// GNO_scorelimit = param2; //Uncomment to tie into description.ext for scorelimit.

// Initialize Variables. Do not change.

GNO_west = 0;
GNO_east = 0;
GNO_guer = 0;
GNO_sectors = _this;
GNO_gameover = false;

// Debug.

if (GNO_debug) then {player globalChat "DEBUG: INITIALIZING ESC"};

// Initialize Functions.

_initsectors = compile preprocessFile "esc\init_sectors.sqf";
_mainloop = compile preprocessFile "esc\main_loop.sqf";
_initclients = compile preprocessFile "esc\init_clients.sqf";

// Initialize Sectors.

{_x call _initsectors} forEach GNO_sectors;

// Initialize Clients.

[] call _initclients;

// Main Loop

[] spawn _mainloop;






