/*
Script: ESC (Easy Sector Control)
File: score_sys.sqf
Version: 0.6
Author: g_n_o_s_i_s
Email: mats@ronin-group.org

Arguments: 
0. Sector Marker (string)
1. Side (string)
*/
private["_sectormarker", "_side"];

_sectormarker = _this select 0;
_side = _this select 1;

call compile format["GNO_%1_captured = false", _sectormarker];
call compile format["publicVariable 'GNO_%1_captured'", _sectormarker];

if (GNO_gameover) exitWith {
	player sideChat "GAME OVER";
	};

call compile format["GNO_%1 = _side", _sectormarker];
call compile format["publicVariable 'GNO_%1'", _sectormarker];

// Sets capture score

call compile format["GNO_%1 = GNO_%1 + GNO_initialscore", _side];
call compile format["publicVariable 'GNO_%1'", _side];

if (GNO_debug) then {player globalChat format["STARTING LOOP %1: West %2, East %3, Guer %4", _sectormarker, GNO_west, GNO_east, GNO_guer]};

sleep GNO_repeattime;
	
while {call compile format["GNO_%1 == _side", _sectormarker] && !GNO_gameover} do {
	
	if (GNO_west >= GNO_scorelimit || GNO_east >= GNO_scorelimit || GNO_guer >= GNO_scorelimit) exitWith {
		GNO_gameover = true;
		publicVariable "GNO_gameover";
	};
	
	call compile format["GNO_%1 = GNO_%1 + GNO_repeatscore", _side];
	call compile format["publicVariable 'GNO_%1'", _side];

	if (GNO_debug) then {player globalChat format["LOOPING %1: West %2, East %3, Guer %4", _sectormarker, GNO_west, GNO_east, GNO_guer]};

	sleep GNO_repeattime;
};
