// mando single unit ejection script for ArmA v1.05 or above
// mando_ejectunit.sqf v1.1
// Ejects a single unit, this script is executed automatically by mando_eject.sqf
// May 2007 Mandoble

_unit    = _this select 0;
_plane   = _this select 1;
_ispilot = _this select 2;


_vol = 1.0;
_wei = 1.27;
_zodiacs = [];
_zodiac = objNull;

_unit action ["EJECT", _plane];
unassignVehicle _unit;

waitUntil {vehicle _unit != _plane};
vehicle _unit setPos [(getPos vehicle _unit select 0),(getPos vehicle _unit select 1),(getPos vehicle _unit select 2)+4];
vehicle _unit setVelocity [0,0,60];
_smoketrail = "#particlesource" createVehicleLocal getPos vehicle _unit;
_smoketrail setParticleParams ["\ca\data\koulesvetlo","","Billboard",100,0.1,[0,0,0],[0,0,0],0,_wei,_vol,0.05,[1,1.5,0.8,0.5],[[1,0.5,0,0.6],[1,1,1,0.5],[1,1,1,0.1]],[0],0,0,"","",vehicle _unit];
_smoketrail setDropInterval 0.005;
waitUntil {(velocity vehicle _unit select 2) < 10};
deleteVehicle _smoketrail;

waitUntil {vehicle _unit == _unit};

if (surfaceIsWater (getPos vehicle _unit)) then
{
   if (_ispilot) then
   {
      _zodiac = "zodiac" createVehicle [(getPos _unit select 0)+5,(getPos _unit select 1)+5,0];
      _zodiac setVelocity [0,0,0];
   };

   group _unit lockWp true;

   while {isNull _zodiac} do
   {
      _zodiacs = nearestObjects  [vehicle _unit, ["zodiac"], 100];
      if (count _zodiacs > 0) then
      {   
         _zodiac = _zodiacs select 0;
      };
      Sleep 1;
   };
 
   _unit reveal _zodiac;
   if (_unit == leader group _unit) then
   {
      _zodiac setFuel 0;
      _unit moveInDriver _zodiac;
      waitUntil {({damage _x < 1} count (units group _unit)) == ({_x in _zodiac} count (units group _unit))};
      _zodiac setFuel 1;
      group _unit lockWp false;
   }
   else
   {
      waitUntil {(getPos _zodiac select 2) < 0.02};
      _unit moveInCargo _zodiac;  
   }; 
   group _unit lockWp false;
};