/* mando missile control center camera.sqs
 mando_missilecentercam.sqs v1.0
 Jan 2007 Mandoble
 
 This script activates the camera of the launcher when no missile is being followed with mando_mccpredicam camera.
*/
MCC_MCC_FRAME = 21901;


_launcher = _this select 0;
_posrelcam   = _this select 1;

_oldzoom = mando_missile_camera_zoom;
_poscam = _launcher modelToWorld _posrelcam;

showCinemaborder false;
_cam = "camera" camcreate [0, 0, 0];
_cam cameraeffect ["internal", "back"];
_cam camSetPos _poscam;
_cam camSetTarget (_launcher modelToWorld [0, 50, 0.25]);
_cam camSetFov 1;
_cam camCommit 0;

_camfollow = false;
_mando_camfollow = objNull;
_oldfollow = objNull;

while {ctrlVisible MCC_MCC_FRAME} do
{
   _poscam = _launcher modelToWorld _posrelcam;
   _mando_camfollow = _launcher getVariable "mando_camfollow";

   if (mando_mccpredicam) then 
   {
      _camfollow = true;
   }
   else
   {

      if (!mando_mccpredicam && _camfollow) then 
      {
         _camfollow = false;
         _cam = "camera" camcreate [0, 0, 0];
         _cam cameraeffect ["internal", "back"];
         _cam camPreparePos _poscam;
         _cam camCommitPrepared 0;

         if (isNull _mando_camfollow) then 
         { 
            _cam camSetTarget (_launcher modelToWorld [0, 50, 0.25]);
         }
         else
         {
            _cam camSetTarget _mando_camfollow;
         };
         _cam camCommit 0;
      };

      _cam camPreparePos _poscam;
      _cam camPrepareFov (mando_missile_camera_zoom);
      _cam camCommitPrepared 0;

      if (isNull _mando_camfollow) then 
      { 
         _cam camSetTarget (_launcher modelToWorld [0, 50, 0.25]);
         _cam camCommit 0;
      };


      if (_oldfollow != _mando_camfollow) then 
      {
         if (!isNull _mando_camfollow) then 
         { 
            _cam camSetTarget _mando_camfollow;
         }
         else
         {
            _cam camSetTarget (_launcher modelToWorld [0, 50, 0.25]);
         };
         _cam camCommit 0.5;
         _oldfollow = _mando_camfollow;
      };
   };

   sleep (0.01);
};

_cam cameraeffect ["terminate", "back"];
camDestroy _cam;
