/* mando_assignvehicle_by_name.sqf
By Mandoble June 2007

Purpose:
   Waits until a player is in a vehicle which name is in the provided array, and then gives that vehicle missile or flare/chaff capability. Missiles and chaff/flares will work manually, controlled by the player.

Arguments: 
   Array of vehicle names
   Player's position inside the vehicle: 0 = driver, 1 = gunner
   Name of the vehicle's weapon used to fire and aim the missiles, "" if none (aiming with the vehicle's nose)
   Maximum number of missiles
   Current number of missiles
   Maximum number of flares/chaff
   Current number of flares/chaff
   Control script name (mando_missilevehicle.sqf or anyother similar to that one)
   Is the vehicle able to fire against vehicles or ships? true/false
   Is the vehicle able to fire against air targets? true/false
   Is the vehicle able to fire against buildings? true/false
   Firing position in vehicle coordinates from where the missiles will be fired
   Keyboard control script 
   Weapon sight vertical delta (aproximate height of the sight of the selected weapon, distance over the ground).

Examples:
   Helicopters without missiles and with 10 flares
   [["heli1", "heli2", "heli3"], 0, "", 0, 0, 10, 10, "mando_missiles\units\mando_missilevehicle.sqf", false, false, false, false [0,0,0]]execVm"mando_missiles\units\mando_assignvehicle_by_name.sqf"

   A Shilka with 8 missiles and no flares using its AZP85 gun to lock on air targets and fire missiles. The gunsight is about 2m over the ground.
   [["shilka1"], 1, "AZP85", 8, 8, 0, 0, "mando_missiles\units\mando_missilevehicle.sqf", false, true, false, false, [0,0,0.5], "mando_vulcan_keys.sqf", 2]execVm"mando_missiles\units\mando_assignvehicle_by_name.sqf";

*/


private ["_names", "_plane", "_aa", "_ag", "_af", "_ar", "_ao", "_ak", "_var", "_maxmissiles", "_actmissiles", "_maxflares", "_actflares", "_keyscript", "_ttypes", "_inplane", "_position", "_weapon", "_ctrlscript", "_gvtargets", "_airtargets", "_structargets", "_remottargets", "_firingpos", "_hudopenh", "_hudopenv", "_deltav", "_driver", "_gunner", "_vehiclename", "_missileidx"];

_names         = _this select 0;
_position      = _this select 1;
_weapon        = _this select 2;
_maxmissiles   = _this select 3;
_actmissiles   = _this select 4;
_maxflares     = _this select 5;
_actflares     = _this select 6;
_ctrlscript    = _this select 7;
_gvtargets     = _this select 8;
_airtargets    = _this select 9;
_structargets  = _this select 10;
_remottargets  = _this select 11;
_firingpos     = _this select 12;
_keyscript     = _this select 13;
_hudopenh      = _this select 14;
_hudopenv      = _this select 15;
_deltav        = _this select 16;
_missileidx    = _this select 17;


_plane = objNull;
_ttypes = [];
while {true} do
{
   waitUntil {!isNull player};

   _inplane = false;

   while {!_inplane} do
   {
      Sleep 1;

      if ((vehicle player) != player) then
      {
         _vehiclename = vehicleVarName (vehicle player);

         if (_vehiclename in _names) then
         {
            _driver = driver vehicle player;
            _gunner = gunner vehicle player;
            if (((_position == 0) && (_driver == player)) || ((_position == 1) && (_gunner == player))) then
            {
               _inplane = true;
               _plane = vehicle player;
            };
         };
      };
   };

   cutRsc["mandosystems", "PLAIN DOWN"];

   for [{_i = 0},{_i < count _maxmissiles},{_i = _i + 1}] do
   {
      mando_vehvar_vehicler = _plane;
      mando_vehvar_r = format["mando_maxmissiles%1",_i+_missileidx];
      mando_vehvar_requestr = true;
      {publicVariable _x} forEach ["mando_vehvar_vehicler", "mando_vehvar_r", "mando_vehvar_requestr"];
      Sleep 0.5;
      mando_vehvar_vehicler = _plane;
      mando_vehvar_r = format["mando_missilesleft%1",_i+_missileidx];
      mando_vehvar_requestr = true;
      {publicVariable _x} forEach ["mando_vehvar_vehicler", "mando_vehvar_r", "mando_vehvar_requestr"];
      Sleep 0.5;

      _var = _plane getVariable format["mando_maxmissiles%1",_i+_missileidx];
      if ((isNil "_var") && ((_maxmissiles select _i) > 0)) then
      {
         mando_vehvar_vehiclew = _plane;
         mando_vehvar_w = format["mando_maxmissiles%1",_i+_missileidx];
         mando_vehvar_valuew = _maxmissiles select _i;
         mando_vehvar_requestw = true;
         {publicVariable _x} forEach ["mando_vehvar_vehiclew", "mando_vehvar_w", "mando_vehvar_valuew", "mando_vehvar_requestw"];
         Sleep 0.5;
         _var = _plane getVariable format["mando_missilesleft%1",_i+_missileidx];
         if (isNil "_var") then
         {
            mando_vehvar_vehiclew = _plane;
            mando_vehvar_w = format["mando_missilesleft%1",_i+_missileidx];
            mando_vehvar_valuew = _actmissiles select _i;
            mando_vehvar_requestw = true;
            {publicVariable _x} forEach ["mando_vehvar_vehiclew", "mando_vehvar_w", "mando_vehvar_valuew", "mando_vehvar_requestw"];
            Sleep 0.5;
         };
      };   
   };

   mando_vehvar_vehicler = _vehicle;
   mando_vehvar_r = "mando_maxflares";
   mando_vehvar_requestr = true;
   {publicVariable _x} forEach ["mando_vehvar_vehicler", "mando_vehvar_r", "mando_vehvar_requestr"];
   Sleep 0.5;
   mando_vehvar_vehicler = _vehicle;
   mando_vehvar_r = "mando_flaresleft";
   mando_vehvar_requestr = true;
   {publicVariable _x} forEach ["mando_vehvar_vehicler", "mando_vehvar_r", "mando_vehvar_requestr"];
   Sleep 0.5;

   _var = _plane getVariable "mando_maxflares";
   if ((isNil "_var") && (_maxflares > 0)) then
   {
      mando_vehvar_vehiclew = _plane;
      mando_vehvar_w = "mando_maxflares";
      mando_vehvar_valuew = _maxflares;
      mando_vehvar_requestw = true;
      {publicVariable _x} forEach ["mando_vehvar_vehiclew", "mando_vehvar_w", "mando_vehvar_valuew", "mando_vehvar_requestw"];
      Sleep 0.5;

      _var = _plane getVariable "mando_flaresleft";
      if (isNil "_var") then
      { 
         mando_vehvar_vehiclew = _plane;
         mando_vehvar_w = "mando_flaresleft";
         mando_vehvar_valuew = _actflares;
         mando_vehvar_requestw = true;
         {publicVariable _x} forEach ["mando_vehvar_vehiclew", "mando_vehvar_w", "mando_vehvar_valuew", "mando_vehvar_requestw"];
         Sleep 0.5;
      };
   };   


   mando_ihavemissiles = false;
   mando_ihaveflares   = false;
   _msg = "";

   for [{_i = 0},{_i < count _maxmissiles},{_i = _i + 1}] do
   {
      if ((_maxmissiles select _i) > 0) then
      {
         mando_ihavemissiles = true;
         _msg = _msg + format["Max Missiles type%1: %2, Missiles Left type%3: %4\n", _i+_missileidx, _plane getVariable format["mando_maxmissiles%1",_i+_missileidx], _i+_missileidx, _plane getVariable format["mando_missilesleft%1",_i + _missileidx]];
      };
   };

   if (_maxflares > 0) then
   {
      mando_ihaveflares = true;
      _msg = _msg + format["Max Flares:%1, Flares Left:%2", _plane getVariable "mando_maxflares", _plane getVariable "mando_flaresleft"];
   };   
   cutText[_msg, "PLAIN DOWN"];

   mando_missileidxbase = _missileidx;

   if (mando_ihavemissiles) then
   {
      if (_airtargets) then
      {
         _aa = _plane addAction ["Switch to AA targets", "mando_missiles\units\AAmode.sqf"];
         _ttypes = ["Air"];
         mando_missileidx = mando_missileidxbase;
      };

      if (_gvtargets) then
      {
         _ag = _plane addAction ["Switch to AG targets", "mando_missiles\units\AGmode.sqf"];
         if (count _ttypes == 0) then
         {
            _ttypes = ["LandVehicle", "Ship"];
            mando_missileidx = mando_missileidxbase + 1;
         };
      };

      if (_structargets) then
      {
         _af = _plane addAction ["Switch to structures", "mando_missiles\units\ABmode.sqf"];
         if (count _ttypes == 0) then
         {
            _ttypes = ["House"];
            mando_missileidx = mando_missileidxbase + 1;
         };
      };

      if (_remottargets) then
      {
         _ar = _plane addAction ["Switch to remote", "mando_missiles\units\ARmode.sqf"];
         if (count _ttypes == 0) then
         {
            _ttypes = ["REMOTE"];
            mando_missileidx = mando_missileidxbase + 1;
         };
      };
   };

   if (mando_ihavemissiles || mando_ihaveflares) then
   {
      _ao = _plane addAction ["Show ordenance", "mando_missiles\units\mando_showordenance.sqf"];  
      _ak = _plane addAction ["Mando Missile Keys", "mando_missiles\units\mando_keyconfig.sqf"];  
   };
  
   _res = [_plane, _ttypes, _weapon, _firingpos, _keyscript, _deltav, _position, _hudopenh, _hudopenv]execVm _ctrlscript;


   if (_position == 0) then
   {
      while {driver _plane == player} do
      {
         Sleep 1;
      };
   }
   else
   {
      while {gunner _plane == player} do
      {
         Sleep 1;
      };
   };


   if (mando_ihavemissiles) then
   {
      if (_airtargets) then
      {
         _plane removeAction _aa;   
      }; 
 
      if (_gvtargets) then
      {
         _plane removeAction _ag;
      };

      if (_structargets) then
      {
         _plane removeAction _af;
      };

      if (_remottargets) then
      {
         _plane removeAction _ar;
      };
   };

   if (mando_ihavemissiles || mando_ihaveflares) then
   {
      _plane removeAction _ao;
      _plane removeAction _ak;
   };
   _inplane = false;

   Sleep 2;
};