/* 
 mando basic missile defense system
 mando_missileecm.sqf v1.1
 Apr 2007 Mandoble
 

The purpose is to add an automatic missile defense system for a unit (chaff or flares).
The unit will use them automatically when needed.

Parameters:

Unit that has the CHAFF or FLARES packs
Minimum distance beetween incomming missile and the unit to drop flares or chaff
Type: 0 - Chaff, 1 - Flares
Number of chaff or flares packs, each usage substracs one to this initial quantity
radio: true/false, if unit sends radio messages indicating a missile incomming, chaff or flares dropped, missile evaded, etc.

Example AV8B with a chaff system (10 chaff packets):

[harrier1, 300, 0, 10, true]execVM"mando_missiles\units\mando_missileecm.sqf"
*/
private ["_unitecm", "_mindistecm", "_typeecm", "_numecm", "_radio", "_distlaunch", "_misecm", "_eh"];

_unitecm    = _this select 0;
_mindistecm = _this select 1;
_typeecm    = _this select 2;
_numecm     = _this select 3;
_radio      = _this select 4;


_eh = _unitecm addEventHandler ["IncomingMissile",{_this execVM "mando_missiles\units\mando_incoming.sqf"}];

if (local _unitecm) then
{
   _distlaunch = 0;
   _misecm = objNul;

   while {(damage _unitecm < 0.8)&&(_numecm > 0)} do
   {
      if (mando_missilerequest) then
      { 
         if (mando_missiletarget == _unitecm) then
         {
//            mando_message = format["%1, CHAFF REQUESTED BY %2", name player, mando_missiletarget];
//            publicVariable "mando_message";

            _misecm = mando_missileincomming;
            mando_missilerequest = false;
         };
      };

      if (!isNull _misecm) then
      {
         if (_radio) then {driver _unitecm sideChat "Missile incomming!";};

         waitUntil {(isNull _misecm) || ((_misecm distance _unitecm)<_mindistecm)};

         if (!isNull _misecm) then
         {
            _numecm = _numecm - 1;
            [_unitecm, _typeecm]exec"mando_missiles\mando_chaffflares.sqs";
            _distlaunch = _unitecm distance _misecm;

            if (_radio && (_typeecm == 0)) then {driver _unitecm sideChat "CHAFF! CHAFF! CHAFF!";};
            if (_radio && (_typeecm == 1)) then {driver _unitecm sideChat "FLARES! FLARES! FLARES!";};
            if (_radio && (_numecm == 0) && (_typeecm == 0)) then {driver _unitecm sideChat "We ran out of chaff!";};
            if (_radio && (_numecm == 0) && (_typeecm == 1)) then {driver _unitecm sideChat "We ran out of flares!";};

            Sleep 4;

            if ((isNull _misecm) || ((_misecm distance _unitecm)>_distlaunch)) then
            {
               if (_radio && (!isNull _misecm)) then
               {
                  driver _unitecm sideChat "Missile evaded!";
                  Sleep(1);
               };
               _misecm = objNull;
            };
         };
      };
      Sleep(0.5);
   };
}
else
{
   waitUntil {(damage _unitecm > 0.8)};
};
_unitecm removeEventHandler ["IncomingMissile", _eh];
