/* mando_missilevehicle.sqf
By Mandoble March 2007

*/

_unit        = _this select 0;
_ttypes      = _this select 1;
_weaponname  = _this select 2;
_firingpos   = _this select 3;
_keyscript   = _this select 4;
_deltav      = _this select 5;
_playerpos   = _this select 6;
_hudopenh    = _this select 7;
_hudopenv    = _this select 8;

_posu = [0,0,0];
_vdir = [0,0,0];
_post = [0,0,0];
_color = [[0,1,0,1]];

_unit setVariable ["target_types",_ttypes];
_unit setVariable ["weapon_name",_weaponname];


_missile_warning = false;
_misecm = _unit getVariable "mando_missileincomming";
_oldmisecm = objNull;
if (isNil ("_misecm")) then {_misecm = objNull;};

_log1t = "Logic" createVehicleLocal [0,0,0];
_log2t = "Logic" createVehicleLocal [0,0,0];

_log1m = "Logic" createVehicleLocal [0,0,0];
_log2m = "Logic" createVehicleLocal [0,0,0];


_unit setVariable ["current_target", objNull];
_unit setVariable ["current_targetmcc", objNull];

mando_planefiretime  = dayTime * 3600;
mando_planechafftime = dayTime * 3600;
mando_planelocktime  = dayTime * 3600;
mando_planetakeoff   = false;
mando_pilon          = 1;
mando_firingpos      = _firingpos;

if (vehicle player == _unit) then
{
   mando_keyscript = _keyscript;
   (findDisplay mando_main_display) displaySetEventHandler ["KeyDown", "_res = _this execVM mando_keyscript"];
};



_msg = "";

if (mando_ihavemissiles) then
{
   _msg = _msg + format["%1 -> Lock on target\n%2 -> Fire missile\n", mando_keylockname, mando_keyfirename];
};
if (mando_ihaveflares) then
{
   _msg = _msg + format["%1 -> Flares\n", mando_keyflarename];
};
if (mando_ihavemissiles) then
{
   _msg = _msg + "\nMenu actions to change target types.";
};

hint format["%1", _msg];
_continue = true;

_target = objNull;
_target_destroyed = objNull;

while {_continue} do
{
   _posu = [getPosASL _unit select 0,getPosASL _unit select 1, (getPosASL _unit select 2)+_deltav];
   if (_weaponname != "") then 
   {
      _vdir = _unit weaponDirection _weaponname;
   }
   else
   {
      _vdir = vectorDir _unit;
   };

   _target = _unit getVariable "current_target";
   if (isNull _target) then
   {
      _target = _unit getVariable "current_targetmcc";
   };

   if (!isNull _target) then
   {
      _post = getPosASL _target;
      _dir = (_vdir select 0) atan2 (_vdir select 1);
      _ang = ((_post select 0)-(_posu select 0)) atan2 ((_post select 1)-(_posu select 1));

      _log1t setDir (_ang - _dir);
      _log1t setposASL _posu;

      _difh = getDir _log1t;
      if (_difh > 180) then {_difh = _difh - 360;};

      _altuasl = _posu select 2;
      _alttasl = _post select 2;
      _distance  = _log1t distance _target;

      _angu = asin(_vdir select 2);
      _angv = asin((_alttasl - _altuasl)/_distance);
      _difv = _angv - _angu;

      hint format["Target:%1 (%2)\nH. dev:%3 degs, V. dev:%4 degs\nDist:%5 m", typeOf _target, side _target, floor _difh, floor _difv, _distance];

      if ((abs(_difh) <= _hudopenh) && (abs(_difv) <= _hudopenv)) then
      {
         _rad = (100 min (_distance - 5));
         _pz = (_posu select 2)+sin(_angu + _difv)*_rad;
         _radh = cos(_angu + _difv)*_rad;
 
         _px = (_posu select 0)+sin(_dir + _difh)*_radh;
         _py = (_posu select 1)+cos(_dir + _difh)*_radh;

         _posASL = [_px,_py,_pz];
         _log2t setDir _ang;
         _log2t setPosASL _posASL;

         
         if (side _target == side player) then 
         {
            _color = [[0,1,0,1]];
         }
         else
         {
            _color = [[1,1,0,1]];
         };
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[0,0,0],[0,0,0],0,1.27,1.0,0.05,[1.5],_color,[0],0,0,"","",_log2t]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[-1.5,0,0],[0,0,0],0,1.27,1.0,0.05,[1.5],_color,[0],0,0,"","",_log2t]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[1.5,0,0],[0,0,0],0,1.27,1.0,0.05,[1.5],_color,[0],0,0,"","",_log2t]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[0,0,1.5],[0,0,0],0,1.27,1.0,0.05,[1.5],_color,[0],0,0,"","",_log2t]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[0,0,-1.5],[0,0,0],0,1.27,1.0,0.05,[1.5],_color,[0],0,0,"","",_log2t]; 
      };

      if ((damage _target > 0.9) && (_target != _target_destroyed)) then 
      {
         _target_destroyed = _target;
         _unit setVariable ["current_target", objNull];
         cutText["Target destroyed!", "PLAIN DOWN"];
         hint "";
      };
   };

   if (mando_missilerequest) then
   { 
      if (mando_missiletarget == _unit) then
      {
         _misecm = mando_missileincomming;
         mando_missilerequest = false;
      };
   };

   if (!isNull _misecm) then
   {
      if (!_missile_warning) then
      {
         _missile_warning = true;
         titleRsc["mandoincoming", "PLAIN"];
//         cutText["\n\nMISSILE INCOMMING !!", "PLAIN DOWN"];
         playSound "mando_noammo1";
      };

      _post = getPosASL _misecm;
      _dir = (_vdir select 0) atan2 (_vdir select 1);
      _ang = ((_post select 0)-(_posu select 0)) atan2 ((_post select 1)-(_posu select 1));

      _log1m setDir (_ang - _dir);
      _difh = getDir _log1m;
      if (_difh > 180) then {_difh = _difh - 360;};

      _altuasl = _posu select 2;
      _alttasl = _post select 2;
      _distance  = _unit distance _misecm;

      _angu = asin(_vdir select 2);
      _angv = asin((_alttasl - _altuasl)/_distance);
      _difv = _angv - _angu;

      if ((abs(_difh) < 90) && (abs(_difv) < 90)) then
      {
         _rad = (100 min _distance);
         _pz = (_posu select 2)+sin(_angu + _difv)*_rad;
         _radh = cos(_angu + _difv)*_rad;
 
         _px = (_posu select 0)+sin(_dir + _difh)*_radh;
         _py = (_posu select 1)+cos(_dir + _difh)*_radh;

         _posASL = [_px,_py,_pz];
         _log2m setPosASL _posASL;
         _log2m setDir _ang;

         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[0,0,0],[0,0,0],0,1.27,1.0,0.05,[2],[[1,0,0,1]],[0],0,0,"","",_log2m]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[-2,0,0],[0,0,0],0,1.27,1.0,0.05,[2],[[1,0,0,1]],[0],0,0,"","",_log2m]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[2,0,0],[0,0,0],0,1.27,1.0,0.05,[2],[[1,0,0,1]],[0],0,0,"","",_log2m]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[0,0,2],[0,0,0],0,1.27,1.0,0.05,[2],[[1,0,0,1]],[0],0,0,"","",_log2m]; 
         drop ["\ca\data\koulesvetlo","","Billboard",100,0.15,[0,0,-2],[0,0,0],0,1.27,1.0,0.05,[2],[[1,0,0,1]],[0],0,0,"","",_log2m]; 
      };
   };

   if (((isNull _misecm) || (_oldmisecm != _misecm)) && _missile_warning) then
   {
      _missile_warning = false;
   };
   _oldmisecm = _misecm;

   if (!(alive _unit) || (isNull _unit) || ((_playerpos == 0) && (driver _unit != player)) || ((_playerpos == 1) && (gunner _unit != player))) then
   {
      _continue = false;
   };


   Sleep(0.1);
};

deleteVehicle _log1t;
deleteVehicle _log2t;
deleteVehicle _log1m;
deleteVehicle _log2m;
(findDisplay mando_main_display) displaySetEventHandler ["KeyDown", ""];
hint "";