// mando scripted missile
// mando_missile.sqf v2.2
// March 2007 Mandoble
// 
// Purpose: Creates an scripted guided missile able to pursue and destroy assigned target.
// 
// Arguments:
// Launcher, unit that fires the missile
// Class of missile's object
// Initial position in space (global position, not relative to launcher)
// Initial horizontal direction (usualy, the direction of the launcher)
// Initial vertical angle (-89 to 89). If out of limits, the angle will be calculated to point at target.
// Initial speed a launch time in m/s
// Speed to keep constant after initial acceleration in m/s
// Acceleration factor (1 min, 4 max)
// Real target object
// Range to target to explode in meters
// Missile inboard radar range in meters
// Initial operation mode: 0, 1 or 2
// 0 - The missile climbs/dives until cruise altitude is reached, then it switches to mode 1.
// 1 - The missile flies towards a pre-calculated position from where it may switch on its own radar. 
// 2 - Active pursuing. The target must be inside missile's radar range.
//
// Average cruise altitude in meters ASL, used if initial operation mode is 0 or 1 (inertial launches).
// SQF Script to create the explosion. Receives last missile position and target as arguments. "" if no explosion.
// SQF Script to create missile smoke trail. Receives missile object as argument. "" if no smoke.
// Missile sound resource name, "" if none.
// Missile sound duration in seconds
// Missile maximum endurance in seconds (after this time, the missile will be unpowered)
// Terrain avoidance in mode 1 (true/false). Terrain avoidance is off in modes 0 and 2.
// Frequency of mid-course corrections in seconds while in mode 1, any number above endurance for no corrections.
//    NOTE: script consumed time is added to mid-course corrections frequency, so, a frequency of 2 seconds may
//       end in updates every 4 real seconds depending on CPU load. This is just to simulate launcher mid-course
//       corrections while flying in inertial mode, like current AIM120 AMRAAM command mode.
// Time between creating the missile and switching on its engine in seconds
// Time (-process time) between creating the missile and starting guidance (usually use 0 or very small values lower than 0.1)
// Detectable? true/false. Detectable missiles may be intercepted by other mando missiles and detected by MCCs.
// Debug data for missile dialog info (true/false)
// SQF script to be executed at launch time to add FX, receives missile object as single argument, "" if none.

// Horizontal agility level (0 min, 4 max, 3 is normal)
// Vertical agility level (0 min, 4 max, 3 is normal)
// Accuracy (0.5 min, 1 max)
// Interception mode true/false in active mode. true = interception course, false = collision course.
// Missile's seeker horizontal scan arc in degrees (65 is normal)
// Missile's seeker vertical scan arc in degrees (65 is normal)



private ["_launcher", "_type", "_posini", "_dirini", "_angvini", "_speedini", "_speedmax", "_accelfact", "_rtarget", "_proximity", "_radarrgn", "_modeini", "_cruisealt", "_boomscript", "_smokescript", "_sound", "_sounddur", "_endurance", "_terrain", "_corrections", "_droptime", "_controltime", "_detectable", "_debug", "_launchscript", "_hagility", "_vagility", "_accuracy", "_intercept", "_scanarch", "_scanarcv", "_velt", "_spdt", "_intercepttime", "_post", "_ang", "_vt", "_vr", "_dirt", "_dif", "_dir1", "_dif1", "_dir2", "_dif2", "_sig", "_ang1", "_dirmode0", "_tti", "_altmasl", "_deltaalt", "_angmode0", "_radmode0", "_postmode0", "_postmode1", "_follow", "_dir", "_distance", "_angv", "_difang", "_difabs", "_climbdir", "_turn", "_emergency", "_vz", "_vh", "_vx", "_dmg", "_dist", "_distold", "_array", "_numitems", "_i", "_item", "_finish", "_missilelnum", "_missileid", "_chaff", "_chaffrgn", "_mis", "_maxclimbup", "_maxclimbdown", "_maxacqhor", "_maxacqver", "_vel", "_speed", "_mode", "_sealeveloffset", "_delay", "_hdegreessec01", "_vdegreessec01", "_hdegreessec2", "_vdegreessec2", "_deltah01", "_deltav01", "_deltah2", "_deltav2", "_log", "_ltarget", "_ground", "_target", "_posmini", "_posm", "_posmg","_postini", "_distanceini", "_correctionstime" , "_controltimeini", "_endurancetimeini","_timeleft", "_soundtimeini", "_side"];

_launcher     = _this select 0;
_type         = _this select 1;
_posini       = _this select 2;
_dirini       = _this select 3;
_angvini      = _this select 4;
_speedini     = _this select 5;
_speedmax     = _this select 6;
_accelfact    = _this select 7;
_rtarget      = _this select 8;
_proximity    = _this select 9;
_radarrgn     = _this select 10;
_modeini      = _this select 11;
_cruisealt    = _this select 12;
_boomscript   = _this select 13;
_smokescript  = _this select 14;
_sound        = _this select 15;
_sounddur     = _this select 16;
_endurance    = _this select 17;
_terrain      = _this select 18;
_corrections  = _this select 19;
_droptime     = _this select 20;
_controltime  = _this select 21;
_detectable   = _this select 22;
_debug        = _this select 23;
_launchscript = _this select 24;
_hagility     = _this select 25;
_vagility     = _this select 26;
_accuracy     = _this select 27;
_intercept    = _this select 28;
_scanarch     = _this select 29;
_scanarcv     = _this select 30;


_velt = [0,0,0];
_spdt = 0.0;
_intercepttime = 0,0;
_post = [0,0,0];
_ang = 0.0;
_vt = 0.0;
_vr = 0.0;
_dirt = 0.0;
_dif = 0.0;
_dir1 = 0.0;
_dif1 = 0.0;
_dir2 = 0.0;
_dif2 = 0.0;
_sig = 0;
_ang1 = 0.0;
_dirmode0 = 0;
_tti = 0.0;
_altmasl = 0.0;
_deltaalt = 0.0;
_angmode0 = 0;
_radmode0 = 0;
_postmode0 = [0,0,0];
_postmode1 = [0,0,0];
_follow = false;
_dir = 0.0;
_distance = 0.0;
_angv = 0.0;
_difang = 0.0;
_difabs = 0.0;
_emergency = false;
_vz = 0.0;
_vh = 0.0;
_vx = 0.0;
_dmg = 0.0;
_dist = 0.0;
_distold = 0.0;
_array = [];
_numitems = 0;
_i = 0;
_item = [0, objNull, objNull];
_finish = false;
_missilelnum = 0;
_missileid = [0, objNull, objNull];
_chaff = objNull;
_chaffrgn = 1000;


if (!isNull _launcher) then
{
   _posini = _launcher modelToWorld _posini;
};
_mis = _type createVehicle _posini;
_mis setPos _posini;
_mis setDir _dirini;


if (!isNull _launcher) then
{
   _mis setVectorUp vectorUp _launcher;
   if (_angvini < 89) then
   {
      _angvini = _angvini + asin(vectorDir _launcher select 2); 
      if (_angvini > 89) then
      {
         _angvini = 89;
      }
      else
      {
         if (_angvini < -89) then
         {
            _angvini = -89;
         };
      };
   };
   _mis setVelocity velocity _launcher;
};

_side = side _rtarget;


if (_detectable) then
{
/*
   _missilelnum = floor(random 10000);
   _missileid = [_missilelnum,_mis,_rtarget];
   mando_missilearray=mando_missilearray + [_missileid];
*/

   mando_detmissileowner = _launcher;
   mando_detmissile = _mis;
   mando_detmissilereq = true;
   publicVariable "mando_detmissileowner";publicVariable "mando_detmissile";publicVariable "mando_detmissilereq";
};


if (_debug) then 
{
   mando_missile = _mis;
};

sleep _droptime;


_maxclimbup = 89;
_maxclimbdown = -89;
_maxacqhor = _scanarch;
_maxacqver = _scanarcv;

_vel = velocity _mis;
_speed = _speedini + sqrt((_vel select 0)^2 + (_vel select 1)^2);
_mode  = _modeini;

_sealeveloffset = 1;

_delay = 0.002;

_hdegreessec01 = 120*3;
_vdegreessec01 = 120*3;
_hdegreessec2 = 120*_hagility;
_vdegreessec2 = 120*_vagility;

_deltah01 = 0.0;
_deltav01 = 0.0;
_deltah2 = 0.0;
_deltav2 = 0.0;


_log = "logic" createVehicleLocal [0,0,0];
_ltarget = "logic" createVehicleLocal [0,0,0];
_ground = "logic" createVehicleLocal [0,0,0];


_distold = 99999;


_target      = _rtarget;
_posmini     = getPos _mis;
_posm        = _posmini;
_postini     = getPos _target;
_distanceini = _target distance _mis;

_turn = 0;

_dir = _dirini;
_climbdir = 0;

_correctionstime  = dayTime * 3600;
_controltimeini   = dayTime * 3600;
_endurancetimeini = dayTime * 3600;
_timeleft         = _endurance;
_soundtimeini     = dayTime * 3600;

if (_distanceini < _radarrgn) then {_mode = 2;};


if (_mode != 2) then
{
   _ang = ((_posmini select 0)-(_postini select 0)) atan2 ((_posmini select 1)-(_postini select 1));
   if (_ang < 0) then {_ang = 360 + _ang;};

   _vt = (speed _rtarget) / 3.6;
   _vr = _speedmax;

   _dirt = getDir _rtarget;

   _dif = abs(_ang - _dirt);
   if (_dif > 180) then {_dif = 360 - _dif;};

   _dir1 = _dirt + 2;
   if (_dir1 > 360) then {_dir1 = _dir1 - 360;};

   _dif1 = abs(_ang - _dir1);
   if (_dif1 > 180) then {_dif1 = 360 - _dif1;};

   _dir2 = _dirt - 2;
   if (_dir2 < 0) then {_dir2 = 360 - _dir2;};

   _dif2 = abs(_ang - _dir2);
   if (_dif2 > 180) then {_dif2 = 360 - _dif2;};

   _sig = 1;
   if (_dif2 < _dif1) then {_sig = -1;};

   _angi1 = asin((_vt/_vr)*sin(_dif));
   _dirmode0 = (_ang + 180) + _sig*_angi1;

   _tti = _distanceini / ((_vt*cos(_dif)+_vr*cos(_angi1))+0.0001);


   _altmasl = getPosASL _mis select 2;
   _deltaalt = _cruisealt - _altmasl;

   _angmode0 = _angvini;
   _radmode0 = abs(_deltaalt);

   if (_deltaalt < 0) then 
   {
      _radmode0 = abs(_deltaalt)*6.0;
   };

   _postmode0 = [(_posmini select 0)+sin(_dirmode0)*_radmode0, (_posmini select 1)+cos(_dirmode0)*_radmode0, 0];
   _ltarget setPos _postmode0;
   _postmode0 = [_postmode0 select 0, _postmode0 select 1, _cruisealt - (getPosASL _ltarget select 2)];

   _postmode1 = [(_posmini select 0)+sin(_dirmode0)*((_speedmax*_tti)-(_radarrgn/1.2)),(_posmini select 1)+cos(_dirmode0)*((_speedmax*_tti)-(_radarrgn/1.2)), 0];

   if (_terrain) then
   {
      _postmode1 = [_postmode1 select 0, _postmode1 select 1, _cruisealt];
   }
   else
   {
      _ltarget setPos _postmode1;
      _postmode1 = [_postmode1 select 0, _postmode1 select 1, _cruisealt + (getPosASL _ltarget select 2)];
   };

   if ((_postmode1 distance _rtarget) > (_postmode0 distance _rtarget)) then
   {
      _postmode1 = _postmode0;
   };
};

_proximitytemp = _proximity;

if (_mode == 0) then
{
   _ltarget setPos _postmode0;
   _target = _ltarget;
   _angvini = _angmode0;
//   _proximitytemp = 40;
   _proximitytemp = 100;
};


if (_mode == 1) then 
{
//   _angvini = 0;
   _ltarget setPos _postmode1;
   _target = _ltarget;
   _proximitytemp = 40;
};


if (abs(_angvini) > 89) then 
{
   _altmasl = getPosASL _mis select 2;
   _alttasl = getPosASL _target select 2;
   _angvini = asin((_alttasl - _altmasl)/_distanceini);
};


_climb = _angvini;

if (_sound != "") then {_mis say [_sound, 200];};

if (_smokescript != "") then 
{
//   _res = [_mis]execVM _smokescript;
   mando_missilesmoke_mis = _mis;
   mando_missilesmoke_script = _smokescript;
   mando_missilesmoke = true;
   publicVariable "mando_missilesmoke_mis";publicVariable "mando_missilesmoke_script";publicVariable "mando_missilesmoke";
};



if (_launchscript != "") then 
{  
   mando_launch_mis = _mis;
   mando_launch_script = _launchscript;
   mando_launch_req = true;
   publicVariable "mando_launch_mis";publicVariable "mando_launch_script";publicVariable "mando_launch_req";
};


mando_missileincomming = _mis;
mando_missiletarget = _rtarget;
mando_missilerequest = true;

publicVariable "mando_missileincomming";publicVariable "mando_missiletarget";publicVariable "mando_missilerequest";

_follow = true;
while {!_finish} do
{
   if (mando_missilechafflauncher == _rtarget) then
   {
      if (((_mis distance _rtarget)+100) > (_mis distance mando_missilechaff)) then
      {
         _chaff = mando_missilechaff;
      };
   };



   if (_mode == 2) then 
   {
      if (!isNull _chaff) then 
      {
         if ((_mis distance _chaff) < _chaffrgn) then
         {
            _target = _chaff;
         }
         else
         {
            _target = _rtarget;
         };
      }
      else
      {
         _target = _rtarget;

      };
   };

   _dir = getDir _mis;
   if ((_speed + _accelfact) < _speedmax) then {_speed = _speed + _accelfact;};


   if ((getPos _mis select 0)>1) then 
   {
      _posm = getPosASL _mis;
      _posmg = getPos _mis;
   };


   if (!isNull _target) then 
   {
      if (_intercept) then
      {
         _ang = ((_posm select 0)-(getPos _target select 0)) atan2 ((_posm select 1)-(getPos _target select 1));
         if (_ang < 0) then {_ang = 360 + _ang;};

         _vt = (speed _target) / 3.6;
         _vr = _speedmax;

         _dirt = getDir _target;
         _dif = abs(_ang - _dirt);
         if (_dif > 180) then {_dif = 360 - _dif;};


         _dir1 = _dirt + 2;
         if (_dir1 > 360) then {_dir1 = _dir1 - 360;};
         _dif1 = abs(_ang - _dir1);
         if (_dif1 > 180) then {_dif1 = 360 - _dif1;};


         _dir2 = _dirt - 2;
         if (_dir2 < 0) then {_dir2 = 360 - _dir2;};
         _dif2 = abs(_ang - _dir2);
         if (_dif2 > 180) then {_dif2 = 360 - _dif2;};


         _sig = 1;
         if (_dif2 < _dif1) then {_sig = -1;};
         _angi1 = asin((_vt/_vr)*sin(_dif));
         _angi = (_ang + 180) + _sig*_angi1;

         _tti = (_mis distance _target) / ((_vt*cos(_dif)+_vr*cos(_angi1))+0.0001);
         _tti2 = _tti;
         _post = [(_posm select 0)+sin(_angi)*(_speedmax*_tti2),(_posm select 1)+cos(_angi)*(_speedmax*_tti2), (getPosASL _target select 2)+(velocity _target select 2)*_tti + _sealeveloffset];
      }
      else
      {
         _post = [(getPos _target select 0),(getPos _target select 1), (getPosASL _target select 2)+ _sealeveloffset];
      };
   };

   _log setPosASL _post;

   _altmasl = getPosASL _mis select 2;

   _alttasl = getPosASL _log select 2;
   _distance = _log distance _mis;
   _angv = asin((_alttasl - _altmasl)/_distance);

   _difang = abs(_climb - _angv);

   _climbdir = 1;
   if (_angv - _climb < 0) then {_climbdir = -1;};

   if ((_difang > _maxacqver)&&(_mode == 2)) then {_follow = false;};
   if ((_difang < 1)||!_follow) then {_climbdir = 0;};


   _ang = ((_post select 0)-(_posm select 0)) atan2 ((_post select 1)-(_posm select 1));
   _dif = (_ang - _dir);
   if (_dif < 0) then {_dif = 360 + _dif;};
   if (_dif > 180) then {_dif = _dif - 360;};
   _difabs = abs(_dif);
  
   if ((_difabs > _maxacqhor)&&(_mode == 2)) then {_follow = false;};

   if ((_difabs >= 1) && _follow) then
   {
      _turn = _dif/_difabs;
   }
   else
   {
      _turn = 0;
   };


   if (_mode == 2) then 
   {
      _dir = _dir + (_turn * _deltah2) - ((1-_accuracy) * _turn * random(_deltah2));
   }
   else
   {
      _dir = _dir + (_turn * _deltah01) - ((1-_accuracy) * _turn * random(_deltah01));
   };


   _emergency = false;
   _ground setPos [(_posm select 0)+sin(_dir)*100, (_posm select 1)+cos(_dir)*100, 0];
   if ( (((getPosASL _ground select 2)+30) > _altmasl)&&(_mode == 1)&&_terrain) then 
   {
      _climbdir = 1;
      _emergency = true;
   };

   _ground setPos [(_posm select 0)+sin(_dir)*50, (_posm select 1)+cos(_dir)*50, 0];
   if ( (((getPosASL _ground select 2)+30) > _altmasl)&&(_mode == 1)&&_terrain) then 
   {
      _climbdir = 1;
      _emergency = true;
   };


   if (((_climbdir > 0) && (_climb < _maxclimbup) && ((_climb < _angv)||_emergency)) ||
       ((_climbdir < 0) && (_climb > _maxclimbdown) && (_climb > _angv)) ) then
   {
      if (_mode == 2) then
      {
         _climb = _climb + (_climbdir * _deltav2 * _accuracy);
      }
      else
      {
         _climb = _climb + (_climbdir * _deltav01 * _accuracy);
      };
   };
   

   if ( ((_climbdir > 0) && (_climb > _angv) && _follow && !_emergency) ||
        ((_climbdir < 0) && (_climb < _angv) && _follow) ) then 
   {
      _climb = _angv;
   };


   _vz = (sin _climb)*_speed;
   _vh = (cos _climb)*_speed;
   _vx = (sin _dir)*_vh;
   _vy = (cos _dir)*_vh;

   _dmg = damage _mis;

   if (_dmg == 0) then 
   {
      _mis setVectorDir[_vx/_speed, _vy/_speed, _vz/_speed];
      _uz = sin(_climb+90);
      _ur = cos(_climb+90);
      _ux = sin(_dir)*_ur;
      _uy = cos(_dir)*_ur;
      _mis setVectorUp[_ux, _uy, _uz];
      _mis setVelocity [_vx, _vy, _vz];
   };

   _dist = _target distance _mis;
   _distr = _rtarget distance _mis;

   if ( ((_mode == 0) && (abs(_altmasl - _cruisealt)<6)) || 
        (isNull _mis) ||
        (_dmg > 0.1) ||
        ((_dist < _proximitytemp)&&(_target != _chaff)) ||
        (_distr < _proximitytemp) ||
        ((_dist < 30)&&(_dist > _distold)&&(_target != _chaff)&&((getPos _rtarget select 2)>1)) ) then
   {

// The missile reached target, cruise alt or a mid-course position
      if ((_mode == 0) && (!isNull _mis) && (_dmg < 0.1)) then 
      {
         _mode = 1;
         _ltarget setPosASL _postmode1;
         _target = _ltarget;
      } 
      else
      {
         if ((_mode == 1) && (!isNull _mis) && (_dmg < 0.1)) then 
         {
            _mode = 2;
            _target = _rtarget;
            _proximitytemp = _proximity;
         }
         else
         {
            deleteVehicle _ltarget;
            deleteVehicle _log;
            deleteVehicle _ground;
            if (!isNull _mis) then {deleteVehicle _mis;};
            if ((_posm select 0) < 1) then 
            {
               _finish=true;
            }
            else
            {
               if (_dist < _proximitytemp) then {_target setDamage (damage _target + 0.11);};
               if (_boomscript != "") then 
               { 
                 mando_deton_x = _posmg select 0;
                 mando_deton_y = _posmg select 1;
                 mando_deton_z = _posmg select 2;
                 mando_deton_target = _rtarget;
                 mando_deton_side = _side;
                 mando_deton_launcher = _launcher;
                 mando_deton_script = _boomscript;
                 mando_deton_req = true;
                 publicVariable "mando_deton_x";publicVariable "mando_deton_y";publicVariable "mando_deton_z";publicVariable "mando_deton_target";publicVariable "mando_deton_side";publicVariable "mando_deton_launcher";publicVariable "mando_deton_script";publicVariable "mando_deton_req";
               };

/*
               if (_detectable) then
               {
	          _array = [];
                  _numitems = count mando_missilearray;

                  for [{_i = 0},{_i < _numitems},{_i = _i + 1}] do
                  {
                    _item = mando_missilearray select _i;
                    if (((_missileid select 0) != (_item select 0))) then {_array = _array + [_item];};
                  };
                  mando_missilearray = _array;
               };
*/
               _finish=true;        
            };
         };
      };
   };

   if (!_finish) then
   {
      if ((_dist > (_radarrgn+500)) && (_mode == 2)) then {_follow = false};

      _distold = _dist;

      if (_debug) then 
      {
         if (mando_missile == _mis) then
         {
            mando_missile_follow = _follow;
            mando_missile_mode = _mode;
            mando_missile_emergency = _emergency;
            mando_missile_distance = _dist;
            mando_missile_endurance = floor (_timeleft);
         };
      };

      sleep _delay;

      if ((dayTime * 3600) > (_correctionstime + _corrections)) then
      {
         _correctionstime = (dayTime * 3600);
         if (_mode == 1) then
         {
            _ang = ((_posm select 0)-(getPos _rtarget select 0)) atan2 ((_posm select 1)-(getPos _rtarget select 1));
            if (_ang < 0) then {_ang = 360 + _ang;};

            _vt = (speed _rtarget) / 3.6;
            _vr = _speedmax;

            _dirt = getDir _rtarget;
            _dif = abs(_ang - _dirt);
            if (_dif > 180) then {_dif = 360 - _dif;};


            _dir1 = _dirt + 2;
            if (_dir1 > 360) then {_dir1 = _dir1 - 360;};
            _dif1 = abs(_ang - _dir1);
            if (_dif1 > 180) then {_dif1 = 360 - _dif1;};


            _dir2 = _dirt - 2;
            if (_dir2 < 0) then {_dir2 = 360 - _dir2;};
            _dif2 = abs(_ang - _dir2);
            if (_dif2 > 180) then {_dif2 = 360 - _dif2;};


            _sig = 1;
            if (_dif2 < _dif1) then {_sig = -1;};

            _angi1 = asin((_vt/_vr)*sin(_dif));
            _angi = (_ang + 180) + _sig*_angi1;

            _dist = _mis distance _target;
            _tti = (_mis distance _rtarget) / ((_vt*cos(_dif)+_vr*cos(_angi1))+0.0001);
            if (_dist > _radarrgn/4.0) then
            {
               _postmode1 = [(_posm select 0)+sin(_angi)*((_speedmax*_tti)-(_radarrgn/1.2)),(_posm select 1)+cos(_angi)*((_speedmax*_tti)-(_radarrgn/1.2)), 0];

               if (_terrain) then
               {
                  _postmode1 = [_postmode1 select 0, _postmode1 select 1, _cruisealt];
               }
               else
               {
                  _ltarget setPos _postmode1;
                  _postmode1 = [_postmode1 select 0, _postmode1 select 1, _cruisealt + (getPosASL _ltarget select 2)];
               };
               _target setPosASL _postmode1;
            };
         };
      };

      if ((dayTime * 3600) > (_controltimeini + _controltime)) then
      {
         _controltime = 99999;
         _deltah01 = _hdegreessec01 * _delay;
         _deltav01 = _vdegreessec01 * _delay;
         _deltah2 = _hdegreessec2 * _delay;
         _deltav2 = _vdegreessec2 * _delay;
      };

      if ((dayTime * 3600) < (_endurancetimeini + _endurance)) then
      {
         _timeleft =  ((_endurancetimeini + _endurance) - (dayTime * 3600));
      }
      else
      {
         if (_dmg == 0) then
         {
            _mis setDamage 0.05;
         };
         _timeleft = 0;
      };

      if (_sound != "") then 
      {
         if ( ((dayTime * 3600) > (_soundtimeini + _sounddur - 0.5)) && (_dmg == 0)) then
         {
            _soundtimeini = (dayTime * 3600);
            _mis say [_sound, 200];
         };
      };
   };
};