/* mando_vulcan_keys.sqf
By Mandoble March 2007

LEFT CTRL to lock on target, LEFT WIN to fire missile and LEFT SHIFT to drop flares
*/
private ["_unit", "_list", "_pos", "_ttypes", "_delta", "_log", "_target", "_missilebody", "_speedini", "_delayinit", "_hagility", "_vagility", 
"_speedmax", "_acceleration", "_boomrange",
 "_activerange",
 "_modeinit",
 "_cruisealt",
 "_boomscript",
 "_smokescript",
 "_soundrsc",
 "_sounddur", "_endurance",
 "_terrainavoidance",
 "_updatefreq",
"_timetocontrol",
"_detectable"
,"_debug"
,"_launchscript"
,"_accuracy"
,"_intercept"
,"_scanarch"
,"_scanarcv", "_airtargets"];

_maxscanrange = 2000;

_key = _this select 1;
if ((_key == mando_keylock) && ((dayTime * 3600 - mando_planelocktime)>0.5)) then 
{
// L CTRL, get target
   mando_planelocktime = dayTime * 3600;

   _unit = vehicle player;
   _ttypes = _unit getVariable "target_types";
   _target = objNull;
   
   if ("REMOTE" != _ttypes select 0) then
   {
      _weapon = _unit getVariable "weapon_name";
      _airtargets = "Air" in _ttypes;
      _vdir = [0,0,0];
      if (_weapon == "") then 
      {
         _vdir = vectorDir _unit;
      }
      else
      {
         _vdir = _unit weaponDirection _weapon;
      };
      _log = "logic" createVehicleLocal [0,0,0];
      _dst = 80;
      _posini = [getPosASL _unit select 0,getPosASL _unit select 1,(getPosASL _unit select 2)];

      _delta = 10;
      _list = [];
      while {(_dst < _maxscanrange) && (isNull _target)} do
      {
         _pos = [(_posini select 0)+(_vdir select 0)*_dst, 
                 (_posini select 1)+(_vdir select 1)*_dst, 
                 (_posini select 2)+(_vdir select 2)*_dst];

         _log setPosASL _pos;
         _list = nearestObjects [getPos _log, _ttypes, _delta];


         _dst = _dst + _delta;
         _numitems = count _list;
         if (_numitems > 0) then 
         {
            for [{_i = 0},{_i < _numitems},{_i = _i + 1}] do
            {
               if (damage (_list select _i) < 1) then 
               {
                  if (_airtargets) then
                  {
                     if ((getPos (_list select _i) select 2) > 5) then
                     {
                        _target = _list select _i;
                        _i = 99999;
                     };
                  }
                  else
                  {
                     _target = _list select _i;
                     _i = 99999;
                  };
               };
            };
         }
         else
         {
            if ((_delta < 50) && _airtargets) then 
            {
               _delta = _delta + 5;
            };
         };

      };
      deleteVehicle _log;
   }
   else
   {
      if ("REMOTE" == _ttypes select 0) then
      {
         switch (side player) do
         {
            case west:
            {
               if ((count mando_remote_targets_w) > 0) then
               {
                  mando_remote_selected = mando_remote_selected + 1; 
                  if (mando_remote_selected >= (count mando_remote_targets_w)) then
                  {
                     mando_remote_selected = 0;
                  };
                  _target = mando_remote_targets_w select mando_remote_selected;
               };
            };
     
            case east:
            {
               if ((count mando_remote_targets_e) > 0) then
               {
                  mando_remote_selected = mando_remote_selected + 1; 
                  if (mando_remote_selected >= (count mando_remote_targets_e)) then
                  {
                     mando_remote_selected = 0;
                  };
                  _target = mando_remote_targets_e select mando_remote_selected;
               };        
            };        
         };
      };
   };

   if (!isNull _target) then 
   {
      if (_target != vehicle player) then
      {
         mando_lockedon=_target;
         publicVariable "mando_lockedon";

         _unit setVariable ["current_target", _target];
         cutText[format["Target Locked! (%1)", typeOf _target], "PLAIN DOWN"];
         playSound "mando_target1";
      };
   }
   else
   {         
      hint "";
      _unit setVariable ["current_target", objNull];
   };
};

if ((_key == mando_keyfire) && ((dayTime * 3600 - mando_planefiretime)>2)) then
{ 
// L Windows, firing missile
   if (((vehicle player getVariable format["mando_missilesleft%1", mando_missileidx]) > 0) && mando_ihavemissiles) then
   {
      _target =  vehicle player getVariable "current_target";
      if (!isNull _target) then
      {
         mando_planefiretime = dayTime * 3600;
         cutText["FOX ONE!", "PLAIN DOWN"];
         _dir = 0;
         _vangle = 0;
      
         _launcher         = vehicle player;
         _ttypes = _launcher getVariable "target_types";


         if (mando_missileidx == mando_missileidxbase) then
         {
            _missilebody      = "M_Sidewinder_AA";
            _speedini         = 5;
            _delayinit        = 0;
            _hagility         = 5;
            _vagility         = 5;
            _speedmax         = 600;
            _acceleration     = 6;
            _boomrange        = 5;
            _activerange      = 3000;
            _modeinit         = 2;
            _cruisealt        = 80;
            _boomscript       = "mando_missiles\warheads\mando_missilehead1l.sqf";
            _smokescript      = "mando_missiles\exhausts\mando_missilesmoke1a.sqf";
            _soundrsc         = "mando_missile1";
            _sounddur         = 29;
            _endurance        = 6;
            _terrainavoidance = false;
            _updatefreq       = 999;
            _timetocontrol    = 0;
            _detectable       = false;
            _debug            = false;
            _launchscript     = "";
            _accuracy         = 1;
            _intercept        = true;
            _scanarch         = 65;
            _scanarcv         = 65;
         } 
         else
         {
            _missilebody      = "M_Javelin_AT";
            _speedini         = 5;
            _delayinit        = 0;
            _hagility         = 4;
            _vagility         = 4;
            _speedmax         = 300;
            _acceleration     = 3;
            _boomrange        = 5;
            _activerange      = 3000;
            _modeinit         = 0;
            _cruisealt        = 80;
            _boomscript       = "mando_missiles\warheads\mando_missilehead1a.sqf";
            _smokescript      = "mando_missiles\exhausts\mando_missilesmoke1a.sqf";
            _soundrsc         = "mando_missile1";
            _sounddur         = 29;
            _endurance        = 6;
            _terrainavoidance = false;
            _updatefreq       = 999;
            _timetocontrol    = 0;
            _detectable       = false;
            _debug            = false;
            _launchscript     = "";
            _accuracy         = 1;
            _intercept        = true;
            _scanarch         = 65;
            _scanarcv         = 65;
         };

         _weapon = _launcher getVariable "weapon_name";
         if (_weapon == "") then 
         {
            _dir           = getDir _launcher;
            _vangle           = 0;
         }
         else
         {
            _dir           = ((_launcher weaponDirection _weapon) select 0) atan2 ((_launcher weaponDirection _weapon) select 1);
            _vangle        = asin((_launcher weaponDirection _weapon) select 2) - asin(vectorDir _launcher select 2)
         };

         _pos              = mando_firingpos;
         _target           = _target;

        _res = [_launcher, _missilebody, _pos, _dir, _vangle, _speedini, _speedmax, _acceleration, _target, _boomrange, _activerange, _modeinit, _cruisealt, _boomscript, _smokescript, _soundrsc, _sounddur, _endurance, _terrainavoidance, _updatefreq, _delayinit, _timetocontrol, _detectable, _debug, _launchscript, _hagility, _vagility, _accuracy, _intercept, _scanarch, _scanarcv]execVM"mando_missiles\mando_missile.sqf";

         vehicle player setVariable [format["mando_missilesleft%1", mando_missileidx], (vehicle player getVariable format["mando_missilesleft%1", mando_missileidx]) - 1];
         mando_vehvar_vehiclew = vehicle player;
         mando_vehvar_w = format["mando_missilesleft%1", mando_missileidx];
         mando_vehvar_valuew = (vehicle player getVariable format["mando_missilesleft%1", mando_missileidx]);
         mando_vehvar_requestw = true;
         {publicVariable _x} forEach ["mando_vehvar_vehiclew", "mando_vehvar_w", "mando_vehvar_valuew", "mando_vehvar_requestw"];

         cutText[format["%1 missiles left", (vehicle player getVariable format["mando_missilesleft%1", mando_missileidx])], "PLAIN DOWN"];
      }
      else
      {
         cutRsc["mandonolock", "PLAIN"];
      };
   }
   else
   {
      cutRsc["mandonomissiles", "PLAIN"];
   };
   Sleep(2);
   cutText["", "PLAIN DOWN"];
};


if ((_key == mando_keyflare) && ((dayTime * 3600 - mando_planechafftime)>2)) then 
{ 
// L shift (launching flares)
   mando_planechafftime = dayTime * 3600;
   if (((vehicle player getVariable "mando_flaresleft") > 0) && mando_ihaveflares) then
   {
      [vehicle player, 1]exec"mando_missiles\mando_chaffflares.sqs";

      vehicle player setVariable ["mando_flaresleft", (vehicle player getVariable "mando_flaresleft") - 1];
      mando_vehvar_vehiclew = vehicle player;
      mando_vehvar_w = "mando_flaresleft";
      mando_vehvar_valuew = (vehicle player getVariable "mando_flaresleft");
      mando_vehvar_requestw = true;
      {publicVariable _x} forEach ["mando_vehvar_vehiclew", "mando_vehvar_w", "mando_vehvar_valuew", "mando_vehvar_requestw"];

      cutText[format["%1 flares left", (vehicle player getVariable "mando_flaresleft")], "PLAIN DOWN"];
   };
};