/* 
 mando basic missile armed unit
 mando_missileattacker.sqf v1.1
 Jan 2007 Mandoble
 

The purpose is to add an automatic lock on/missile fire system for a unit
More than 1 system may be added to a single unit (but not at the same firing place.


 Sintax:
[disp, unitpos, ttype, quantity, min range, max range, rate of fire, firing pos, scan arc, minknows, enemy sides, antimissile?, radar initially ON?, Radio Messsages?, missile params, radar on sound, radar off sound] exec"mando_missileattacker.sqf"

 disp: Missile armed vehicle
 unitpos: Missile armed unit position inside vehicle: 0 driver, 1 gunner, 2 commander.
 missile target types array: ["Air"] or ["LandVehicle"] or ["Air", "LandVehicle", "Ship"],etc. "REMOTE" target type may be used
                             to indicate this unit may target targets locked by other units.    
 quantity: number of missiles loaded into this unit.
 min range: closer than that, the system will not attack units.
 max range: farther than that, the system will not attack units
 rate of fire: maximum number of missiles launched per minute.
 firing position: relative firing position of the missile to the launcher (vehicle or unit parameter).
 scan arc: arc in front of the firing unit where targets may be locked, 90 means from -45 degrees to the left to
           +45 degrees to the right, 360 will lock on any target in range, 180 will lock on any target in front 
           of the firing unit (from -90 to the left to +90 to the right).
 minimum knowledge: Minimum knowledge of the target from 0 (nothing, STANDOFF attacks) to 4 (everything).
 enemy sides: array with sides considered enemy (west, east, resistance and/or civilian)
              note: empty units side is civilian
              note: if you use the side of the launcher, it may launch a missile to itself.
 Able to track and fire against incomming missiles? (true/false)
 Its "launcher" is fixed to the direction of the vehicle? true/false. If false, the missile will be fired already oriented towards the target.
 Initially active: true/false. If false, the unit may be activated writing a true into its "mando_missileattacker_on" variable.
 Radio initially on: true/false. If false, it may be turned on when needed writing a true into its "mando_missileattacker_radio" variable.
 Array of missile paramters (same as used for mando_missile.sqf script)
 Radar ON sound resource name, "" if none.
 Radar OFF sound resource name, "" if none.



 Example of init field for a AG missile armed unit with a single missile system:
 this as missile armed unit
 Firing unit position: 1 (gunner)
 Target Type = 1 (ground/sea)
 8 missiles left
 Range from 500 to 2000m
 firing up yo 10 missiles per minute
 Firing place 3m ahead and 3m above firing unit's vehicle position
 Searching for targets in an arc of 90 degress in from the of the launching vehicle
 The target needs to be known minimally by the firing unit
 Will target east side units
 Not able to track and fire against incomming missiles
 The missile will be launched with launcher dir
 Initially active
 Transmitting targets and shots by radio
 [this, 1, 1, 8, 500, 2000, 10, [0,3,3], 90, 1, [east], false, false, true, true, _mymissileparams, "", ""]execVM"mando_missiles\units\mando_missileattacker.sqf"


 Example to turn on an existing missile system:
 sam1 setVariable ["mando_missileattacker_on", true]

 Example to turn off an existing missile system:
 sam1 setVariable ["mando_missileattacker_on", false]

 Example to turn on radio messages of an existing missile system:
 sam1 setVariable ["mando_missileattacker_radio", true]

 Example to turn off radio messages of an existing missile system:
 sam1 setVariable ["mando_missileattacker_radio", false]
*/

private["_disp", "_unitpos", "_quantityini", "_minrange", "_maxrange", "_rof", "_firingpos", "_arc", "_minknow", "_enemysides", "_antimissile", "_fixeddir", "_active", "_radio", "_missparams", "_radaronsound", "_radaroffsound", "_unit", "_wait", "_i", "_blanco", "_espera", "_disparado", "_list", "_knows", "_know", "_angulos", "_posl", "_mindir", "_minang", "_minangi", "_enemigo", "_posfoe", "_altenemigo", "_bandoenemigo", "_know", "_ang", "_angv", "_difang", "_dist", "_endofunits", "_targetmissile", "_mccstate", "_vdir", "_mindist", "_quantity", "_ammos", "_trigger", "_airpresent", "_vehiclespresent", "_createtrigger", "_refresh_state", "_posdisp", "_posfoe"];

_disp          = _this select 0; 
_unitpos       = _this select 1;
_ttypes        = _this select 2;
_quantityini   = _this select 3;
_minrange      = _this select 4;
_maxrange      = _this select 5;
_rof           = _this select 6;
_firingpos     = _this select 7;
_arc           = _this select 8;
_minknow       = _this select 9;
_enemysides    = _this select 10;
_antimissile   = _this select 11;
_fixeddir      = _this select 12;
_active        = _this select 13;
_radio         = _this select 14;
_missparams    = _this select 15;
_radaronsound  = _this select 16;
_radaroffsound = _this select 17;

_unit     = objNull;
_wait     = 60.0 / _rof;
_arc      = _arc / 2;

_i = 0;
_blanco=objNull;
_espera = 1.0;
_disparado = false;
_list = [];
_knows = [];
_angulos = [];
_posl = [0,0,0];
_midir = 0;
_minang = 9999.0;
_minangi = -1;
_enemigo = objNull;
_posfoe = [0,0,0];
_altenemigo = 0;
_bandoenemigo = east;
_know = 0.0;
_ang  = 999.9;
_angv = 0.0;
_difang = 0.0;
_dist = 0;
_endofunits = 0;
_targetmissile = false;
_mccstate = false;
_i = 0;
_vdir = [0,0,0];
_mindist = 99999;
_quantity = _quantityini;
_ammos = [];
_trigger = objNull;
_airpresent = false;
_vehiclespresent = false;
_createtrigger = false;

Sleep 2;

if ("Air" in _ttypes) then
{
   _airpresent = true;
   _createtrigger = true;
};


if (("LandVehicle" in _ttypes) || ("Ship" in _ttypes)) then
{
   _vehiclespresent = true;
   _createtrigger = true;
};


_mintalt = -100;
_maxtalt = 9.9;
if (_airpresent || _antimissile) then
{
   _maxtalt = 4000;
   if ((count _ttypes == 1) && ("Air" in _ttypes)) then
   {
      _mintalt = mando_minairalt;
   };
};

_remote  = false;
if ("REMOTE" in _ttypes) then
{
   _remote = true;
   _ttypes = _ttypes - ["REMOTE"];
};


if (_unitpos == 0) then
{
   _unit = driver _disp;
}
else
{
   if (_unitpos == 1) then
   {
      _unit = gunner _disp;
   }
   else
   {
      if (_unitpos == 2) then
      {
         _unit = commander _disp;
      }
      else
      {
         _unit = _disp;
      };
   };
};


_logdir = "Logic" createVehicle [0,0,0];

if (!_radio) then 
{
   _disp setVariable ["mando_missileattacker_radio", false];
}
else
{
   _disp setVariable ["mando_missileattacker_radio", true];
};


if (!_active) then 
{
   _disp setVariable ["mando_missileattacker_on", false];
}
else
{
   _disp setVariable ["mando_missileattacker_on", true];
   _mccstate = true;

   if (
       (((_unitpos == 0) && !(isNull driver _disp) && (alive driver _disp) && !(isPlayer driver _disp)) ||
       ((_unitpos == 1) && !(isNull gunner _disp) && (alive gunner _disp) && !(isPlayer gunner _disp)) ||
       ((_unitpos == 2) && !(isNull commander _disp) && (alive commander _disp) && !(isPlayer commander _disp))) &&
       (alive _disp) && !(isNull _disp)) then
   {
      if (_radaronsound != "") then {_disp say _radaronsound;};

      if ((_disp getVariable "mando_missileattacker_radio") && !(isNull _unit))then
      {
         if (!isNull _unit) then
         {
            _unit sideChat format["%1 switching on MCC", _disp];
         };
      };
   
      if (((getPos _disp select 2) < 10) && _createtrigger) then
      {
         mando_radar_on = _disp;publicVariable "mando_radar_on";
      };
   };
};

if (_createtrigger) then
{
   _trigger = createTrigger ["EmptyDetector", getPos _disp];
   _trigger setTriggerActivation ["ANY", "PRESENT", false];
   _trigger setTriggerArea [_maxrange, _maxrange, 0, false];
   _trigger setTriggerType "NONE";
   _trigger setTriggerStatements ["this", "", ""];
   _trigger setTriggerTimeout [0, 0, 0, false ];
};

_refresh_state = 0;

while {(alive _disp)&&!(isNull _disp)} do
{
   if (!(_disp getVariable "mando_gunattacker_on") ||
       ((_unitpos == 0) && ((isNull driver _disp) || (!alive driver _disp) || (isPlayer driver _disp))) ||
       ((_unitpos == 1) && ((isNull gunner _disp) || (!alive gunner _disp) || (isPlayer gunner _disp))) ||
       ((_unitpos == 2) && ((isNull commander _disp) || (!alive commander _disp) || (isPlayer commander _disp)))) then 
   {
      if (_mccstate) then 
      {
         if (_radaroffsound != "") then 
         {
            _disp say _radaroffsound;
         };

         if (((getPos _disp select 2) < 10) && _createtrigger) then
         {
            mando_radar_off = _disp;publicVariable "mando_radar_off";
         };

         if (_disp getVariable "mando_missileattacker_radio") then
         {
            if ((alive _unit) && (_unit in _disp)) then
            {
               _unit sideChat format["%1 switching off MCC", _disp];
            };
         };
         _mccstate = false;
      };

      while {(!(_disp getVariable "mando_missileattacker_on") ||
             ((_unitpos == 0) && ((isNull driver _disp) || (!alive driver _disp) || (isPlayer driver _disp))) ||
             ((_unitpos == 1) && ((isNull gunner _disp) || (!alive gunner _disp) || (isPlayer gunner _disp))) ||
             ((_unitpos == 2) && ((isNull commander _disp) || (!alive commander _disp) || (isPlayer commander _disp)))) &&
             (alive _disp) && !(isNull _disp)} do
      {
         Sleep 2;
      };

      if ((!alive _disp) || (isNull _disp)) exitWith {};   

      if (_unitpos == 0) then
      {
         _unit = driver _disp;
      }
      else
      {
         if (_unitpos == 1) then
         {
            _unit = gunner _disp;
         }
         else
         {
            if (_unitpos == 2) then
            {
               _unit = commander _disp;
            };
         };
      };


      if (_radaronsound != "") then {_disp say _radaronsound;};

      if (((getPos _disp select 2) < 10) && _createtrigger) then
      {
         mando_radar_on = _disp;publicVariable "mando_radar_on";
      };


      if (_disp getVariable "mando_missileattacker_radio") then
      {
         _unit sideChat format["%1 switching on MCC", _disp];
      };
      _mccstate = true;      
   };

   if ((!alive _disp) || (isNull _disp)) exitWith {};   



   if (_disparado) then 
   {
      _disparado = false;
      _espera = _wait;
   }
   else
   {
      _espera = 1;
   };


   if ((alive _unit) && (vehicle _unit == _disp) && (alive _disp) && (_quantity > 0) && (!isNull _disp) && (!isNull _unit)) then 
   {
      sleep _espera;
      //List of units affected by the scan area
      if ((!alive _disp) || (isNull _disp)) exitWith {};

      _refresh_state = _refresh_state + 1;
      if (_refresh_state > 5) then
      {
         if (((getPos _disp select 2) < 10) && _createtrigger) then
         {
            mando_radar_on = _disp;publicVariable "mando_radar_on";
         };
         _refresh_state = 0;
      };


      _list = [];
      if (_createtrigger) then
      {
         _trigger setPos getPos _disp;
         if (count _ttypes > 0) then
         {
            {if (driver _x != _x) then {_list = _list + [_x]}} forEach list _trigger;
//            {if (fuel _x < 1.0) then {_list = _list + [_x]}} forEach list _trigger;
         };
      };

      if (_remote) then
      {
         switch (side _disp) do
         {    
            case west:
            {
               _list = _list + mando_remote_targets_w;
            };

            case east:
            {
               _list = _list + mando_remote_targets_e;
            };
         };
      };

      _endofunits = (count _list) - 1;
      if (_antimissile) then 
      {
         // Missiles in flight in range against friendly units are added to the list

         _i = 0;
         {if ( (side (mando_detowners select _i) in _enemysides)&&((_x distance _disp)<_maxrange)) then {_list = _list + [_x]};_i=_i+1} forEach mando_detmissiles;
      };

      _blanco = objNull;
      if (count _list > 0) then 
      {
         //Heading of the vehicle (if any) of the firing unit
         _vdir = vectorDir _disp;
         _dird = (_vdir select 0) atan2 (_vdir select 1);
         /* I store the knowledges and angles of all units inside scan area that are not almost destroyed and of different side than the firing unit */

         _posdisp = getPos _disp;

         _mindist = 99999;
         _count = count _list;
         for [{_i = 0},{_i < _count},{_i = _i + 1}] do
         {
            _enemigo = _list select _i;
            _posfoe = getPos _enemigo;
            _altenemigo = _posfoe select 2;
            _bandoenemigo = side _enemigo;
            _know = 0.0;
            _ang  = 9999.0;
            _dist = _enemigo distance _disp;

            _targetmissile = false;
//            hint format["A:%1, D:%2 D:%3 S:%4 MA:%5 MA:%6 EU:%7", _altenemigo, _dist, damage _enemigo, _bandoenemigo, _minrange, _maxrange, _endofunits];

            if ((_altenemigo >= _mintalt) && (_altenemigo <= _maxtalt) && 
                (_dist >= _minrange) && (_dist <= _maxrange) && 
                (damage _enemigo < 0.9) && 
                ((_bandoenemigo in _enemysides)||(_i > _endofunits)) ) then 
            {
               _know=_unit knowsAbout _enemigo;

               _ang = ((_posfoe select 0) - (_posdisp select 0)) atan2 ((_posfoe select 1) - (_posdisp select 1));
               _logdir setDir (_ang - _dird);
               _difang = getDir _logdir;
               if (_difang > 180) then {_difang = _difang - 360;};
               
               if ((abs(_difang) <= _arc) && (_know >= _minknow)) then 
               {
               // Suitable target
                  if (_i > _endofunits) then 
                  {
                     _mindist = 0;
                     _targetmissile = true;
                     _blanco = _enemigo;
                  }
                  else
                  {
                     if (_dist < _mindist) then 
                     {
                        _mindist = _dist;
                        _blanco = _enemigo;
                     };
                  };
               };
            };
         };


         //If a unit accomplish the requirements to be targeted
         if (!isNull _blanco) then 
         {
            //Now we have a target
            mando_lockedon=_blanco;
            publicVariable "mando_lockedon";

            if (_disp getVariable "mando_missileattacker_radio") then
            {
               if (_targetmissile) then
               {
                  _unit sideChat format["%1 lock on incomming missile!", _disp]; 
               }
               else
               { 
                  _unit sideChat format["%1 lock on %2", _disp, typeOf _blanco];
               };
            };

            //Add here anyother target validation rule before launching the missile
         
            //Missile is fired
            _dird = getDir _disp;
            _posfoe = getPos _blanco;
            _posdisp = getPos _disp;

            if (!_fixeddir) then
            { 
               _ang = ((_posfoe select 0) - (_posdisp select 0)) atan2 ((_posfoe select 1) - (_posdisp select 1));
               (gunner _disp) doWatch _posfoe;
               _angv = _missparams select 4;
               sleep 1;
            }
            else
            {
               _ang = _dird;
               _angv = asin(vectorDir _disp select 2);  
            };
            sleep 1;

            _posl = _firingpos;
            if ((abs(_firingpos select 0) > 0) && ((_posdisp select 2) > 1.5)) then
            {
               _firingPos set [0, -(_firingpos select 0)];
            };

            if ((alive _disp) && (alive _unit)) then 
            {
               _missparams set [0,_disp];
               _missparams set [2,_posl];
               _missparams set [3,_ang];
               _missparams set [4,_angv];
               _missparams set [8,_blanco];
               _missparams set [12,(_missparams select 12) + (getPosASL _disp select 2)];
               _missparams execVM"mando_missiles\mando_missile.sqf";

               _disparado = true;
               _quantity = _quantity - 1;
  
               if (_disp getVariable "mando_missileattacker_radio") then
               {
                  if (_quantity != 1) then
                  {
                     _unit sideChat format["%1 Fox One! %2 missiles left", _disp, _quantity];
                  }
                  else
                  {
                     _unit sideChat format["%1 Fox One! 1 missile left", _disp];
                  };
               };
            };
         };
      };
   };

   if ((_quantity == 0) && (alive _disp) && (alive _unit)) then
   {
      _ammos = nearestObjects [_disp, ["Truck5tReammo", "UralReammo"], 12];


      if (count _ammos > 0) then
      {
         if (damage (_ammos select 0) < 0.5) then 
         {
            if (_disp getVariable "mando_missileattacker_radio") then
            {
               if (alive _unit) then
               {
                  _unit sideChat "Reloading missiles";
               };
            };
            Sleep 5;
            _quantity = _quantityini;
            if (alive _disp) then
            {
               if (_disp getVariable "mando_missileattacker_radio") then
               {
                  if (alive _unit) then
                  {
                     _unit sideChat "Missiles reloaded";
                  };
               };
            };
         };
      }; 
      Sleep 3;
   };
};

if (_disp getVariable "mando_missileattacker_radio") then
{
   if ((alive _unit) && (_unit in _disp)) then
   {
      _unit sideChat format["%1 switching off MCC", _disp];
   };
};

if (((getPos _disp select 2) < 10) && _createtrigger) then
{
   mando_radar_off = _disp;publicVariable "mando_radar_off";
};


if (_radaroffsound != "") then {_disp say _radaroffsound;};

deleteVehicle _logdir;
if (_createtrigger) then
{
   deleteVehicle _trigger;
};