// mando_move.sqf v0.2
// Jan 2008 Mandoble
// 
// Purpose: Moves a vehicle accurately through provided array of positions.
// 
// Arguments:
// vehicle
// Max speed in km/h (> 0 Km/h)
// acceleration factor (use values between 0.05 and 0.2)
// agility factor (1 to 10)
// Array of move positions and delays (at least one must exist), each member is an array [position, delay after reaching position, min distance to position to accomplish].
// Array of classes to be considered obstacles, [] if no obstacle avoidance.
//
// Example:
//
// A car moving from maker mk_1 to marker mk_2 and then mk_3, waiting 10 seconds after reaching mk_2
// and each position will be completed if car is closer than 2m + current time acceleration factor
//
// res = [car, 40, 0.1, [[getMarkerPos "mk_1", 0, 2],[getMarkerPos "mk_2", 10,2],[getMarkerPos "mk_3", 0, 2]], ["House", "Man"]] execVM "mando_move.sqf";
//


private["_veh", "_speed0", "_acc", "_agility", "_wps", "_tdir", "_delay", "_deltah", "_vh", "_turn", "_dir", "_ang", "_dif", "_difabs", "_posp", "_post", "_driver", "_timeini", "_vdir", "_i", "_vx", "_vy", "_vz", "_speed", "_up", "_ur", "_ux", "_uy", "_uz", "_continue", "_distance", "_distance_old", "_evade", "_obstacles", "_checkpoints", "_posw", "_evading", "_dmg", "_obstacletypes", "_mindist"];

_veh      = _this select 0;
_speed0   = _this select 1;
_acc      = _this select 2;
_agility  = _this select 3;
_wps      = _this select 4;
_obstacletypes = _this select 5;

_speed0   = _speed0 / 3.6;

_delay    = 0.002;
_deltah   = 120 * 4 * _delay;
_vh       = (speed _veh) / 3.6;
_turn     = 0;
_dir      = 0;
_ang      = 0;
_dif      = 0;
_difabs   = 0;
_posp     = [0,0,0];
_post     = [0,0,0];
_crew     = [];
_log = "logic" createVehicleLocal [0,0,0];
_checkpoints = [[10,20,0],[20,20,0],[20,10,0],[20,0,0],[-10,20,0],[-20,20,0],[-20,10,0],[-20,0,0]];

_driver = driver _veh;
_veh engineOn true;
_driver action ["ENGINEON", _veh];
_veh action ["LIGHTON", _veh];

_veh setVariable ["mando_move", 1];
_timeini = dayTime * 3600;
_vdir = vectorDir _veh;

_taxispd = _speed0;
_evade = false;
_evading = false;
_dmg = damage _veh;
for [{_i=0},{_i < (count _wps)},{_i = _i+1}] do
{
   _dir = getDir _veh;
   _post = (_wps select _i) select 0;
   _mindist = (_wps select _i) select 2;
   _log setPos _post;

   _continue = true;
   _distance_old = 999999;
   while {_continue} do
   {
      _posp = getPos _veh;

      if (count _obstacletypes > 0) then
      {
         _obstacles = nearestObjects [_veh modelToWorld [0,20,0],_obstacletypes,10];
         if (count _obstacles > 0) then
         {
            _evade = false;
            {
               if (!_evade) then
               {
                  _obstacles = nearestObjects [(_veh modelToWorld _x),_obstacletypes,10];
                  if (count _obstacles == 0) then
                  {  
                     _post = _veh modelToWorld [(_x select 0),(_x select 1),0];
                     _evade = true;
                     _evading = true;
                  };
               };
            } forEach _checkpoints;
         };
      };

      if (damage _veh != _dmg) then
      {
         if (damage _veh > _dmg) then
         {
            _evading = true;
            _post = _veh modelToWorld (_checkpoints select random ((count _checkpoints) - 1));
         };
         _dmg = damage _veh;     
      };
    

      _distance = sqrt(((_posp select 0)-(_post select 0))^2 + ((_posp select 1)-(_post select 1))^2);

      if ((_distance > _distance_old) && (_distance < _mindist)) then
      {
         if (_evading) then
         {
            _evading = false;
            _post = getPos _log;
         } 
         else
         {
            _continue = false;
         };
      };
      _distance_old = _distance;

      if ((damage _veh > 0.2) || (vehicle _driver != _veh)) then
      {
         _continue = false;
      };

      if ((vectorUp _veh) select 2 < 0.5) then
      {
         Sleep 10;
         if ((vectorUp _veh) select 2 < 0.5) then
	 {
            _continue = false;
         };
      };

      if (!_continue) exitWith {};

      if (!isEngineOn _veh) then 
      { 
         _veh engineOn true;
         _driver action ["ENGINEON", _veh];
      };

      if (_vh < _taxispd) then
      {
         _vh = _vh + (_acc * accTime) / 2.0;  
      };
      if (_vh > _taxispd) then
      {
         _vh = _vh - (_acc * accTime) / 2.0;  
      };

      _posw = _veh worldToModel _post;
      _dif = (_posw select 0) atan2 (_posw select 1);
      _difabs = abs(_dif);
  
      if (_difabs > 0.01) then
      {
         _turn = _dif/_difabs;
      }
      else
      {
         _turn = 0;
      };

      if (_difabs > 45) then
      {
         _taxispd = _speed0 / 5;
      }
      else
      {
         _taxispd = _speed0;
      };
      _dir = getDir _veh;
      _dirt = _dir + (_turn * ((_deltah * accTime) min _difabs))*_agility;
      _dir = _dirt;
      _vx = (sin _dir)*_vh;
      _vy = (cos _dir)*_vh;
      if ((_posp select 2) > 0.1) then
      {
         _vz = -0.5;
      }
      else
      {
         _vz = velocity _veh select 2;

      };
      _veh setVectorDir[_vx/_vh, _vy/_vh, _vz/_vh];
      _veh setVelocity [_vx, _vy, _vz];
      Sleep _delay;
   };
   if ((damage _veh >= 0.2) || (vehicle _driver != _veh)) exitWith {};
   
   Sleep ((_wps select _i) select 1);
};

deleteVehicle _log;