/*
  Use this function to create new yomie spawns at runtime.
  usage: [position, size, mixed] call fCreateSpawn;
    position: array of coordinates of the spawn area center (can be provided in the form of string)
        size: size definition array [width,height] of the spawn area center (can be provided in the form of string)
       mixed: array of prameters to define the spawn area behavior.
              Can be in the form of string or array, and its elements must be like following, while the first element 
              must be the number of yomies and other elements can be in any order:
                [10, "REPEAT", "C","R"]
                10 - number of yomies to spawn
                "REPEAT" - the type of spawn ("ONCE"/"REPEAT"/"INFINITE")
                "C","R" - types of yomies to spawn, at least one must be given.
                          possible values are 'C','R','E','W' 
*/
private ["_i","_m","_pos","_size","_text"];
_pos = _this select 0;
_size = _this select 1;
_text = _this select 2;

// wait until any running spawns initialization is done (if there is any running) 
if (not isNil "spawnsReady") then {
  waitUntil {spawnsReady};
};
spawnsReady = false;

if (typeName _pos == "STRING") then {
  _pos = call compile _pos;
};
if (typeName _size == "STRING") then {
  _size = call compile _size;
};
if (typeName _text != "STRING") then {
  _text = format ["%1", _text];
};

_i = count Spawns; 
_m = format ["yomie_spawn_%1", _i];
_m = CreateMarkerLocal [_m, _pos];
_m setMarkerShapeLocal "icon";
_m setMarkerTypeLocal "empty";
_m setMarkerSizeLocal _size;
_m setMarkerTextLocal _text;

_initSpawns = execVM "init_spawn_triggers.sqf";
spawnsReady = true;
