/*
  Choose random destination for wandering units inside area defined by [_x,_y]
  coordinates and _radius.
  When a bulding is near the choosen position, an attempt is made to return
  a position inside one of the buildings.
  usage: [_x,_y,_radius] call fSetDest;
  result: random world 3D, or building 3D position coordinates. 
*/
private ["_x", "_y", "_z", "_r", "_aBlds", "_bld", "_pos"];
_x = _this select 0;
_y = _this select 1;
_r = _this select 2;
_z = 0;

_x = _x + _r - Random (_r*2);
_y = _y + _r - Random (_r*2);

_aBlds = [_x,_y] nearObjects ["House", 40];
While {Count _aBlds > 0} do {
  _bld = _aBlds select Floor Random Count _aBlds;
  _pos = _bld call fRandomBldPos;
  if (isNil "_pos") then {
    _aBlds = _aBlds - [_bld];
  } else {
    _x = _pos select 0;
    _y = _pos select 1;
    _z = _pos select 2;
    _aBlds = [];
  };
};
[_x,_y,_z]