// initialize game settings and mission environment
_initGame = execVM "yomies\init_game.sqf";
waitUntil {scriptDone _initGame};

// precompile functions
fCreateSpawn = compile preprocessFile "yomies\funcs\create_new_spawn.sqf";
fClearSpawn = compile preprocessFile "yomies\funcs\clear_spawn.sqf";
fDamageTarget = compile preprocessFile "yomies\funcs\damage_target.sqf";
fGetDirToPos = compile preprocessFile "yomies\funcs\get_dir_to_position.sqf";
fGetRBldPos = compile preprocessFile "yomies\funcs\get_random_building_pos.sqf";
fGetYoSpawn = compile preprocessFile "yomies\funcs\get_yomie_spawn_area.sqf";
fGetYoTarget = compile preprocessFile "yomies\funcs\get_yomie_target.sqf";
fGetNearestSpawn = compile preprocessFile "yomies\funcs\get_nearest_spawn.sqf";
fMoveSpawn = compile preprocessFile "yomies\funcs\move_spawn_area.sqf";
fSetYoDest = compile preprocessFile "yomies\funcs\set_yomie_destination.sqf";
fSpawnYomie = compile preprocessFile "yomies\funcs\spawn_yomie.sqf";

// precompile scripts
ehYoKilled = compile preprocessFile "yomies\yomie_eh_killed.sqf";
scSpawnOn = compile preprocessFile "yomies\yomie_spawn_on.sqf";
scSpawnOff = compile preprocessFile "yomies\yomie_spawn_off.sqf";

// initialize spawn area triggers
_initSpawns = execVM "yomies\init_spawn_triggers.sqf";
waitUntil {scriptDone _initSpawns};

if (isServer) then {
  _shSrvLoop = execVM "yomies\srv_loop.sqf";
  _shBodies = execVM "yomies\srv_loop_body_removing.sqf";
};

if (local player) then {
  _shPlrLoop = execVM "yomies\plr_loop.sqf";
};
