/*
  Generates yomie spawns triggers and deletes the markers.
  Markers must be named 'yomie_spawn', 'yomie_spawn_1', 'yomie_spawn_2', ...
*/
private ["_classes","_count","_dir","_i","_m","_mode","_mText","_pos","_rules","_size","_spawn","_vars"];

// wait until the previously run spawns initialization is done (if there is any running) 
if (not isNil "spawnsReady") then {waitUntil {spawnsReady}};
spawnsReady = false;

// spawns init is run from the mission init, but can be run again later if needed.
if (isNil "Spawns") then {
  Spawns = [];
  _m = "yomie_spawn";
} else {
  _m = Format["yomie_spawn_%1",_i];
};
_i = count Spawns;

_mText = markerText _m;
while {_mText != ""} do {
  _vars = call compile _mText;
  _count = _vars select 0;
  _classes = [];
  if ('C' in _vars) then { _classes = _classes + ['C'] };
  if ('E' in _vars) then { _classes = _classes + ['E'] };
  if ('R' in _vars) then { _classes = _classes + ['R'] };
  if ('W' in _vars) then { _classes = _classes + ['W'] };

  // determine the spawn mode ('ONCE'/'REPEAT'/'INFINITE')
  _mode = "ONCE";
  {if (aYSpawnModes find _x > -1) then {_mode = _x}} forEach _vars;

  _pos = getMarkerPos _m;
  _size = (getMarkerSize _m) select 0;
  _dir = markerDir _m;

  // create the trigger on the server only
  if (isServer) then {
    _spawn = createTrigger ["EmptyDetector", _pos];
    _spawn setTriggerArea [_size, _size, _dir, false];
    _spawn setTriggerActivation ["ANY", "PRESENT", true];
    // {side _x != resistance && ({alive _x && not captive _x}count crew _x > 0)} count thislist > 0
//    _rules = [format ["bSpawn%1 and {side _x != resistance && count crew _x > 0} count thisList > 0", _i]];
    _rules = [format ["bSpawn%1 and {{alive _x && not (_x isKindOf ""yomie_base"")} count crew _x > 0} count thisList > 0", _i]];
    _rules = _rules + [format ["SpawnOn%1=1; [%1,%2]spawn scSpawnOn",_i,_classes]];
    _rules = _rules + [format ["SpawnOff%1=1; [%1]spawn scSpawnOff",_i]];
    _spawn setTriggerStatements _rules;
    _spawn setTriggerType "SWITCH";
    Spawns = Spawns + [[_spawn,_size]];
    call compile Format["bSpawn%1=true; Yomies%1=[]; SpawnN%1=%2; SpawnMode%1=""%3""; SpawnGrps%1=[]", _i, _count, _mode];
  };

  deleteMarker _m;
  _i = _i + 1;
  _m = Format["yomie_spawn_%1",_i];
  _mText = markerText _m;
};

spawnsReady = true;
