/*
  Used to send the player reference to the server at the mission start,
  and as a listener & handler of various events.
*/
private ["_added"];

// send the player reference to the server, to fill array of players.
playerAdded = [objNull,-1];
while {bGame} do {
  scopeName "loop";
  _added = playerAdded;
  if (_added select 0 != player) then {
    addPlayer = player;
    publicVariable "addPlayer";
    // player globalChat "sending player";
  } else {
    playerIdx = _added select 1;
    // player globalChat format["pidx: %1", playerIdx];
    breakOut "loop";
  };
  Sleep 0.05;
};


// event listener & handler
// catch various events broadcasted from server, and react to these events
yHowl = objNull; // yomie which is about to howl (broadcasted over network, origin in yomie FSM files, used to make sure each player will hear the same yomie)
yAttk = objNull; // yomie which is about to attack (broadcasted over network, origin in yomie FSM files, used to make sure each player will hear the same yomie)
nYSndHowl = count aYSndHowl; // number of sounds in the 'aYSndHowl' array - we are using this variable instead of having 'count aYSndHowl' inside the loop (which is not necessary))
nYSndAttk = count aYSndAttk; // number of sounds in the 'aYSndAttk' array - we are using this variable instead of having 'count aYSndAttk' inside the loop (which is not necessary))
While {bGame} do { 

  if (not isNull yHowl) then {
    yHowl Say (aYSndHowl select floor random nYSndHowl);
    yHowl = objNull;
  };
  if (not isNull yAttk) then {
    yAttk Say (aYSndAttk select floor random nYSndAttk);
    yAttk = objNull;
  };

  Sleep 0.05;
};
