/*
  Script to delete spawned yomies when all non-yomie units leaves the location.
  Called from within a spawn area trigger.
*/
private ["_bAlive","_bChasing","_bDelete","_bRemove","_clearArea","_grp","_i","_nearUnits","_yomies","_spawnOff","_spawnOn","_spawn","_spawnIndex","_spawnMode","_yomie"];

_spawnIndex = _this select 0;
_spawnOn = format["SpawnOn%1", _spawnIndex];
_spawnOff = format["SpawnOff%1", _spawnIndex];

// we can't proceed while this spawn's process of spawning yomies is still running
waitUntil {isNil _spawnOn};

_spawn = (Spawns select _spawnIndex) select 0;
_spawnMode = call compile format ["SpawnMode%1", _spawnIndex];
_yomies = compile format ["Yomies%1", _spawnIndex];
_clearArea = format ["bClearSpawn%1", _spawnIndex];

_i = 0;
while {isNil _spawnOn && Count (call _yomies) > 0} do {
  scopeName "delete";

  _yomie = (call _yomies) select _i;
  _bDelete = false;
  _bRemove = false;
  _bAlive = (alive _yomie);
  _bChasing = (not isNil {_yomie getVariable "attack"});

  if (isNil _clearArea) then {
    if (_bAlive) then {
      if (not _bChasing) then {
        _bDelete = true;
        _bRemove = true;
        _nearUnits = nearestObjects [_yomie, ["SoldierWB","SoldierEB","Civilian","SoldierGB","LandVehicle","Air"], iViewDist*(1-fog)];
        _nearUnits = _nearUnits + aPlayers;
        {
          scopeName "nearUnitChk";
          _bDelete = (({alive _x && (side group _x != resistance || isPlayer _x)} count (crew _x)) < 1);
          _bRemove = _bDelete;
          if (not _bDelete) then {
            breakOut "nearUnitChk";
          };
        } forEach _nearUnits;
      };
    } else {
      _bDelete = false;
      _bRemove = true;
    };
  } else {
    _bDelete = _bAlive;
    _bRemove = true;
  };

  if (_bRemove) then {
    call compile format ["Yomies%1 = Yomies%1 - [_yomie]", _spawnIndex];
  };
  if (_bDelete) then {
    _grp = group _yomie;
    deleteVehicle _yomie;
    if ({alive _x} count units _grp == 0) then {
      deleteGroup _grp;
    };
  };

  _i = _i + 1;
  if (_i >= count (call _yomies)) then { _i = 0 };

  sleep 0.1;
};

// when _spawnMode is set to ONCE, the killed yomies aren't respawning back and
// SpawnN is decreasing with each killed zombie until it reaches zero,
// then it is pointless to have the now useless trigger.
if (call compile format ["SpawnN%1", _spawnIndex] < 1) then {
  deleteVehicle _spawn;
  Spawns set [_spawnIndex,objNull];
  call compile format ["SpawnOn%1=nil; SpawnOff%1=nil", _spawnIndex];
};

if (not isNil _clearArea) then {
  call compile format ["bClearSpawn%1=nil", _spawnIndex];
};

// let the 'spawn logic' know that deleting process has ended
call compile format["SpawnOff%1=nil", _spawnIndex];
