/*
  Script to spawn the yomies at the desired location.
  Called from within a spawn area trigger.
*/
private ["_cnt","_sizeInc","_spawnOff","_spawnOn","_spawn","_spawnN","_yomies","_bSpawn","_spawnIndex","_spawnMode","_spawnPos","_spawnSize","_spawnTypes","_yomie","_yomieGrp","_yomiePos","_yomieType"];

_spawnIndex = _this select 0;
_spawnTypes = _this select 1;

// check whether the spawn is enabled
_bSpawn = format ["bSpawn%1", _spawnIndex];
if (isNil _bSpawn) exitWith {};

_spawnOn = format["SpawnOn%1", _spawnIndex];
_spawnOff = format["SpawnOff%1", _spawnIndex];

// we can't proceed while this spawn's process of deleting yomies is still running
waitUntil {isNil _spawnOff};

_spawn = (Spawns select _spawnIndex) select 0;
_spawnN = compile format ["SpawnN%1", _spawnIndex];
_yomies = compile format ["Yomies%1", _spawnIndex];
_spawnMode = call compile format ["SpawnMode%1", _spawnIndex];
_spawnPos = getPos _spawn;
_spawnSize = (Spawns select _spawnIndex) select 1;
_sizeInc + 0;

// when _spawnMode is set to ONCE, the killed yomies aren't respawning back and
// _spawnN is decreasing with each killed zombie until it reaches zero.
if (call _spawnN < 1) exitWith {
  deleteVehicle _spawn;
  Spawns set [_spawnIndex,objNull];
  call compile format ["iSpawn%1on=nil", _spawnIndex];
};

_cnt = 0;
while {_spawnMode == 'INFINITE' or _cnt == 0 } do {
  scopeName "spawn";
  while {count call _yomies < (call _spawnN)} do {
  
    // get random position where to spawn the new yomie
    _yomiePos = [0,0,0];
    _sizeInc = 0;
    while {surfaceIsWater _yomiePos || ({alive _x && _yomiePos distance _x < iViewDist*(1-fog)} count aPlayers) > 0} do {
      _yomiePos = [(_spawnPos select 0) + (_spawnSize+_sizeInc) - random((_spawnSize+_sizeInc)*2),(_spawnPos select 1) + (_spawnSize+_sizeInc) - random((_spawnSize+_sizeInc)*2)];
      sleep 0.05;
      if (isNil _bSpawn or not isNil _spawnOff) then {
        breakOut "spawn"
      };
      _sizeInc = _sizeInc + 25;
    };
    //_m = createMarker [format["m%1_%2", _spawnIndex, _cnt], _yomiePos]; _m setMarkerType "dot";
  
    // spawn the yomie
    _yomieType = call compile format["aYClass%1 select (floor random count aYClass%1)", _spawnTypes select (floor random count _spawnTypes)];
    _yomie = [_yomiePos,_yomieType,_spawnIndex] call fSpawnYomie;
    if (not isNull _yomie) then {
      _cnt =_cnt + 1;
    };
  
    Sleep 0.05;
  };
  sleep 0.3;
};

// let the 'spawn logic' know that spawning process has ended
call compile format["SpawnOn%1=nil", _spawnIndex];
