#define TEast 0
#define TWest 1
#define TGuerrila 2
#define TCivilian 3
#define TSideUnknown 4
#define TEnemy 5
#define TFriendly 6
#define TLogic 7

#define true 1
#define false 0

// type scope
#define private 0
#define protected 1
#define public 2

#define VSoft 0
#define VArmor 1
#define VAir 2

#include "CrewAnimations.hpp"

class CfgPatches
{
	class CH_M1Abrams
	{
		Units[]= {"CH_M1A1HC","CH_M1A1HC_NATO","CH_M1A1HC_DESERT","CH_M1","CH_M1_GREEN","CH_M1_REFORGER83","CH_M1_MERDC","CH_M1_GUER","CH_M1_RACS"};
		weapons[]= {"CH_M256_M1A1","CH_M68A1_M1","CH_M2_M1A1","CH_M240_loader_M1A1","CH_M240B_loader_M1A1","CH_M240C_veh_M1A1"};
		requiredVersion = 1.140000;
		requiredAddons[] = {CAData,CACharacters,CAWeapons,CASounds,CATracked,Extended_EventHandlers};
	};
};

class Extended_Init_EventHandlers
{
      class CH_M1A1HC {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\stuff.sqf"";CH_Panc = [_this select 0, ""unhide"", ""unhide"", ""hide""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""NATO""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""random"", ""random"", ""random"", ""random"", ""empty"", ""empty"", ""00"", ""00""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\markings.sqf"";";
                     };

      class CH_M1A1HC_NATO {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\stuff.sqf"";CH_Panc = [_this select 0, ""unhide"", ""unhide"", ""hide""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\panc.sqf"";"; 
	   textures = "CH_Textures = [_this select 0, ""NATO""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""random"", ""random"", ""random"", ""random"", ""empty"", ""empty"", ""00"", ""00""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\markings.sqf"";";
                     };

      class CH_M1A1HC_DESERT {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\stuff.sqf"";CH_Panc = [_this select 0, ""hide"", ""unhide"", ""unhide""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Desert""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""random"", ""random"", ""random"", ""random"", ""00"", ""00"", ""00"", ""01""] execVM ""\ch_m1abrams_cfg\scripts\m1a1\markings.sqf"";";
                     };

      class CH_M1 {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1\stuff.sqf"";CH_Panc = [_this select 0, ""unhide""] execVM ""\ch_m1abrams_cfg\scripts\m1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Green""] execVM ""\ch_m1abrams_cfg\scripts\m1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty""] execVM ""\ch_m1abrams_cfg\scripts\m1\markings.sqf"";";
                     };

      class CH_M1_GREEN {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1\stuff.sqf"";CH_Panc = [_this select 0, ""unhide""] execVM ""\ch_m1abrams_cfg\scripts\m1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Green""] execVM ""\ch_m1abrams_cfg\scripts\m1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty""] execVM ""\ch_m1abrams_cfg\scripts\m1\markings.sqf"";";
                     };

      class CH_M1_REFORGER83 {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1\stuff.sqf"";CH_Panc = [_this select 0, ""hide""] execVM ""\ch_m1abrams_cfg\scripts\m1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""REFORGER 83""] execVM ""\ch_m1abrams_cfg\scripts\m1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""random"", ""random"", ""empty"", ""empty"", ""00"", ""00"", ""empty"", ""empty""] execVM ""\ch_m1abrams_cfg\scripts\m1\markings.sqf"";";
                     };

      class CH_M1_MERDC {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1\stuff.sqf"";CH_Panc = [_this select 0, ""unhide""] execVM ""\ch_m1abrams_cfg\scripts\m1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""MERDC""] execVM ""\ch_m1abrams_cfg\scripts\m1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty""] execVM ""\ch_m1abrams_cfg\scripts\m1\markings.sqf"";";
                     };

      class CH_M1_GUER {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1\stuff.sqf"";CH_Panc = [_this select 0, ""hide""] execVM ""\ch_m1abrams_cfg\scripts\m1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""RACS""] execVM ""\ch_m1abrams_cfg\scripts\m1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty""] execVM ""\ch_m1abrams_cfg\scripts\m1\markings.sqf"";";
                     };

      class CH_M1_RACS {
           init = "CH_Stuff = [_this select 0, ""random""] execVM ""\ch_m1abrams_cfg\scripts\m1\stuff.sqf"";CH_Panc = [_this select 0, ""hide""] execVM ""\ch_m1abrams_cfg\scripts\m1\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""RACS""] execVM ""\ch_m1abrams_cfg\scripts\m1\textures.sqf"";";
	   markings = "CH_Markings = [_this select 0, ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty"", ""empty""] execVM ""\ch_m1abrams_cfg\scripts\m1\markings.sqf"";";
                     };

};

class Extended_Fired_EventHandlers
{
     class CH_M1A1HC {
           fired = "if (_this select 1 == ""CH_M256_M1A1"") then {CH_Recoil = [_this select 0] execVM ""\ch_m1abrams_cfg\scripts\maingunrecoil.sqf""};";
		    };

     class CH_M1 {
           fired = "if (_this select 1 == ""CH_M68A1_M1"") then {CH_Recoil = [_this select 0] execVM ""\ch_m1abrams_cfg\scripts\maingunrecoil.sqf""};";
		    };
};

#include <cfgWeapons.h>

class CfgVehicleClasses
{
	class CH_Armour_West
	{
		displayName = $STR_DN_CH_Armour_West;
	};

	class CH_Armour_Guer
	{
		displayName = $STR_DN_CH_Armour_Guer;
	};
};

class CfgVehicles
{
	class Land;
	
	class LandVehicle: Land 
	{
		class NewTurret;
		class ViewOptics;
	};

	class Tank: LandVehicle 
	{	
		class Turrets 
		{
			class MainTurret: NewTurret 
			{
				class Turrets 
				{
					class CommanderOptics: NewTurret {};
				};
			};
		};
				
		class ViewOptics : ViewOptics {};
	};

	class M1Abrams: Tank {};

//////// CH M1A1 HC //////////////////////////////////////////////////////////////////////////////////////

	class CH_M1A1HC: M1Abrams
	{
		vehicleClass = "CH_Armour_West";
		displayName = $STR_DN_CH_M1A1HC;
		displayNameShort = $STR_DN_CH_M1A1HC;
		model="\ch_m1abrams\ch_m1a1hc.p3d";

		scope=public;
		picture="\ca\tracked\Data\ico\M1_abrams_CA.paa";
		Icon="\Ca\tracked\Data\map_ico\icomap_m1a1_CA.paa";
		mapSize = 11;

		crew = SoldierWCrew;
		typicalCargo[]={SoldierWCrew,SoldierWCrew,SoldierWCrew,SoldierWCrew};
		side=TWest;
		nameSound="Abrams";
		accuracy=0.70;

		driverOutOpticsModel = "";
		driverForceOptics = 1;
		driverAction = Abrams_DriverOut;
		driverInAction = Abrams_Driver;

		castDriverShadow = 0;

		armor=700;
		armorHull = 1;
 		armorTurret = 0.8;
 		armorGun = 0.6;
 		armorEngine = 0.8;
 		armorTracks = 0.6;
		armorStructural=4;
		damageResistance=0.05;
		ejectDamageLimit = 0.2;
		camouflage="8.15*60";
		threat[]={1, 1, 0.3};
		cost=4000000;
		maxSpeed=67;

		hiddenSelections[]={"n1","n2","t1","t2","t3_l","t3_r","t4","t5","01_co","02_co","03_co","04_co","track_co"};
		class Library {libTextDesc = $STR_LIB_CH_M1A1HC;};

		type = 1;
		unitInfoType = "UnitInfoTank";
		unloadInCombat = false;

		soundEngine[]={\ch_m1abrams\Data\Sound\M1A1_engine.ogg,db22,0.75};
		soundEnviron[]={\ch_m1abrams\Data\Sound\M1A1_tracks.ogg,db20,0.95};
		soundGetOut[]={\ch_m1abrams\Data\Sound\HATCHOPN.ogg,db-40,1};
		soundGetIn[]={\ch_m1abrams\Data\Sound\HACHCLSD.ogg,db-40,1};

		class ViewOptics
		{
			initAngleX=0; minAngleX=-30; maxAngleX=+30;
			initAngleY=0; minAngleY=-100; maxAngleY=+100;
			initFov=0.9; minFov=0.9; maxFov=0.9;
		};
		class ViewPilot
		{
			initAngleX=0; minAngleX=0; maxAngleX=+20;
			initAngleY=0; minAngleY=-100; maxAngleY=+100;
			initFov=0.57; minFov=0.42; maxFov=0.64;
		};

		class HitHull
		{
			armor = 1.000000;
			material = 55;
			name = "telo";
			visual = "telo";
			passThrough = 1;
		};
		class HitLTrack
		{
			armor = 0.125000;
			material = 53;
			name = "pas_L";
			visual = "pas_L";
			passThrough = 1;
		};
		class HitRTrack
		{
			armor = 0.125000;
			material = 54;
			name = "pas_P";
			visual = "pas_P";
			passThrough = 1;
		};
		class HitEngine
		{
			armor = 1.000000;
			material = 55;
			name = "motor";
			visual = "hit_hull";
			passThrough = 1;
		};

		class Exhausts
		{
		   class Exhaust1
		   {
			   position = "vyfuk start";
			   direction = "vyfuk konec";
			   effect = "ExhaustsEffectBig";
		   };
		};
		
		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				weapons[]={CH_M256_M1A1,CH_M240C_veh_M1A1};
				magazines[]=
				{
					"CH_27Rnd_M829A2",
					"CH_13Rnd_M830A1",
					"CH_2800Rnd_762x51_M240", "CH_2800Rnd_762x51_M240", "CH_2800Rnd_762x51_M240", "CH_2800Rnd_762x51_M240"
				};

				soundServo[]={\ch_m1abrams\Data\Sound\M1A1_turret.ogg,db5,1.0};

				gunnerAction = Abrams_Gunner;
				gunnerInAction = Abrams_Gunner;
				gunnerOpticsModel = "\ch_m1abrams\optika_tank_gunner.p3d";
				gunnerOutOpticsModel = "";
				gunnerOpticsColor[] = {1,1,1,1};
				gunnerForceOptics = 1;
				forceHideGunner = 1;

				maxHorizontalRotSpeed = 0.750000;
				maxVerticalRotSpeed = 0.450000;
				minElev=-9; maxElev=+20; initElev=0;

				primaryGunner = 1;
				primaryObserver = 0;

				startEngine = 0;
				commanding = 1;

				lockWhenDriverOut=1;

				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.12800; minFov=0.032000; maxFov=0.333333;
				};
				class ViewGunner
				{
					initAngleX = 0; minAngleX = -30; maxAngleX = 30;
					initAngleY = 0; minAngleY = -100; maxAngleY = 100;
					initFov=0.57; minFov=0.42; maxFov=0.64;
				};

				class HitTurret
				{
					armor = 0.400;
					material = 51;
					name = "vez";
					visual = "hit_mainturret";
					passThrough = 1;
				};
				class HitGun
				{
					armor = 0.125;
					material = 52;
					name = "zbran";
					visual = "hit_maingun";
					passThrough = 1;
				};

				class Turrets: Turrets
				{
					class CommanderOptics: CommanderOptics
					{
						weapons[] = {CH_M2_M1A1};
						magazines[] = {
								"CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2",
								"CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2", "CH_100Rnd_127x99_M2"
						};

						outGunnerMayFire = true;
						inGunnerMayFire = true;
						gunnerOutFireAlsoInInternalCamera = 1;
						gunnerOutOpticsShowCursor = 0;
						gunnerOpticsShowCursor = 0;
						gunnerAction = CH_Abrams_CommanderOut;
						gunnerInAction = Abrams_Commander;
						gunnerOpticsModel = "\ca\Tracked\optika_M1A1_commander";
						gunnerOutOpticsModel = "";
						gunnerForceOptics = 1;

						gunBeg = "gun_muzzle";
						gunEnd = "gun_chamber";
						minElev=-10; maxElev=+45; initElev=0;
						minTurn=-360; maxTurn=+360; initTurn=0;
						maxVerticalRotSpeed = 1.200000;

						primaryGunner = 0;
						primaryObserver = 1;

						startEngine = 0;
						commanding = 2;

						castGunnerShadow = 0;

						class ViewOptics
						{
							initAngleX = 0; minAngleX = -30; maxAngleX = 30;
							initAngleY = 0; minAngleY = -100; maxAngleY = 100;
							initFov = 0.332821; minFov = 0.102400; maxFov = 0.666666;
						};
						class ViewGunner
						{
							initAngleX=0; minAngleX=-30; maxAngleX=+30;
							initAngleY=0; minAngleY=-150; maxAngleY=+150;
							initFov=0.57; minFov=0.42; maxFov=0.64;
						};
					};

			class LoaderTurret: NewTurret
			{
				weapons[]={CH_M240B_loader_M1A1};
				magazines[]={
						"CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240",
						"CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240"
				};

				gunnerAction = CH_Abrams_LoaderOut;
				gunnerInAction = Abrams_Commander;
				gunnerOpticsModel = "\ch_m1abrams\optika_tank_driver.p3d";
				gunnerOutOpticsModel = \ca\Weapons\optika_empty;
				gunnerOpticsColor[] = {1,1,1,1};

				gunBeg = "loader_muzzle";
				gunEnd = "loader_chamber";
				viewGunnerInExternal = 0;

				proxyType="CPGunner";
				proxyIndex = 2;
				gunnerName = $STR_DN_CH_loader;
				primaryGunner = 0;
				primaryObserver = 0;
				hasGunner = 1;

				body = "LoaderTurret";
				gun = "LoaderGun";
				animationSourceBody = "LoaderTurret";
				animationSourceGun = "LoaderGun";
				animationSourceHatch = "hatchLoader";

				minElev=-15; maxElev=+50; initElev=-10;
				minTurn=-30; maxTurn=+180; initTurn=145;

				commanding = 0;
				outGunnerMayFire = true;
				inGunnerMayFire = false;
				gunnerFireAlsoInInternalCamera = 0;
				gunnerOutForceOptics = false;
				gunnerOutOpticsShowCursor = false;
				gunnerForceOptics = 1;

				memoryPointGunnerOutOptics = "loader_weapon_view";
				memoryPointGunnerOptics= "loaderview";
				memoryPointsGetInGunner= "pos loader";
				memoryPointsGetInGunnerDir= "pos loader dir";
				memoryPointGun = "loaderPointGun";
				selectionFireAnim = "zasleh_2";

				startEngine = 0;
    				castGunnerShadow = 0;

				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.57; minFov=0.42; maxFov=0.64;
				};
				class ViewGunner
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.57; minFov=0.42; maxFov=0.64;
				};
			};
				};
			};
		};

		class Damage
		{
			tex[]={};
			mat[]={
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_01_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_01_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_01_metal_destruct.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_02_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_02_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_02_metal_destruct.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_03_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_03_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_03_metal_destruct.rvmat",
				"ca\weapons\data\m2.rvmat",
				"ca\weapons\data\m2.rvmat",
				"ca\weapons\data\m2_destruct.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_track_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1a1\m1_abrams_track_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_track_metal_destruct.rvmat"	
			};
		};

		class AnimationSources
		{
			class t_stuff_hide
			{
				type="hide";
				source="user";
				selection="t_stuff";
				animPeriod=0;
			};
			class t_stuff_ammo1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_ammo1";
				animPeriod=0;
			};
			class t_stuff_ammo2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_ammo2";
				animPeriod=0;
			};
			class t_stuff_ammo3_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_ammo3";
				animPeriod=0;
			};
			class t_stuff_bag1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag1";
				animPeriod=0;
			};
			class t_stuff_bag2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag2";
				animPeriod=0;
			};
			class t_stuff_bag3_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag3";
				animPeriod=0;
			};
			class t_stuff_bag4_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag4";
				animPeriod=0;
			};
			class t_stuff_kolo1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_kolo1";
				animPeriod=0;
			};
			class t_stuff_kolo2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_kolo2";
				animPeriod=0;
			};
			class t_stuff_kolo3_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_kolo3";
				animPeriod=0;
			};
			class t_stuff_wor1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_wor1";
				animPeriod=0;
			};
			class t_stuff_wor2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_wor2";
				animPeriod=0;
			};
			class panc1_hide
			{
				type="hide";
				source="user";
				selection="panc1";
				animPeriod=0;
			};
			class panc2_hide
			{
				type="hide";
				source="user";
				selection="panc2";
				animPeriod=0;
			};
			class panc3_hide
			{
				type="hide";
				source="user";
				selection="panc3";
				animPeriod=0;
			};
			class panc4_hide
			{
				type="hide";
				source="user";
				selection="panc4";
				animPeriod=0;
			};
			class MainGunRecoil
			{
				type="translation";
				source="user";
				selection="maingun";
				memory=1;
				axis="maingunrecoil";
				begin="maingunrecoil_begin";
				end="maingunrecoil_end";
				minValue=0;
				maxValue="1";
				offset0=0;
				offset1=0.290000;
				animPeriod=0.15;
			};
			class belt_m240_rotation
			{
				source="reload";
				weapon="CH_M240B_loader_M1A1";
			};
			class belt_m2_rotation
			{
				source="reload";
				weapon="CH_M2_M1A1";
			};
		};

		class UserActions
		{
	        	class CH_FLIRon
			{
				displayName=$STR_DN_CH_FLIRon;
				OnlyForPlayer=true;
				position="window";
				showWindow= 0;
				default = false;
				radius=20;
				condition="(commander this == player && vehicle player == this && ch_m1abrams_TermicVision == 0 && this animationPhase ""HatchCommander"" == 0) || (gunner this == player && vehicle player == this && ch_m1abrams_TermicVision == 0)";
				statement="ch_m1abrams_TermicVision = 1";
			};
		
			class CH_FLIRoff
			{
				displayName=$STR_DN_CH_FLIRoff;
				OnlyForPlayer=true;
				showWindow= 0;
				position="window";
				default = false;
				radius=20;
				condition="(commander this == player && vehicle player == this && ch_m1abrams_TermicVision == 1 && this animationPhase ""HatchCommander"" == 0) || (gunner this == player && vehicle player == this && ch_m1abrams_TermicVision == 1)";
				statement="ch_m1abrams_TermicVision = 0";
			};

	        	class CH_Smoke
			{
				displayName=$STR_DN_CH_Smoke;
				OnlyForPlayer=true;
				position="window";
				showWindow= 0;
				default = false;
				radius=20;
				condition="(gunner this == player && vehicle player == this && ch_m1abrams_ThrowSmoke == 0)";
				statement="ch_m1abrams_ThrowSmoke = 1";
			};
		};
	};

	class CH_M1A1HC_NATO: CH_M1A1HC
	{
		displayName = $STR_DN_CH_M1A1HC_NATO;
	};
	class CH_M1A1HC_DESERT: CH_M1A1HC
	{
		displayName = $STR_DN_CH_M1A1HC_DESERT;
	};

//////// CH M1 ///////////////////////////////////////////////////////////////////////////////////////////

	class CH_M1: CH_M1A1HC
	{
		displayName = $STR_DN_CH_M1;
		displayNameShort = $STR_DN_CH_M1;
		model="\ch_m1abrams\ch_m1.p3d";

		armor=600;
		armorHull = 1;
 		armorTurret = 0.8;
 		armorGun = 0.6;
 		armorEngine = 0.8;
 		armorTracks = 0.6;
		armorStructural=3;
		damageResistance=0.05;
		cost=3500000;
		maxSpeed=72.5;

		class Library {libTextDesc = $STR_LIB_CH_M1;};

		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				weapons[]={CH_M68A1_M1,CH_M240C_veh_M1A1};
				magazines[]=
				{
					"CH_30Rnd_M735",
					"CH_25Rnd_M456",
					"CH_2800Rnd_762x51_M240", "CH_2800Rnd_762x51_M240", "CH_2800Rnd_762x51_M240", "CH_2800Rnd_762x51_M240"
				};

				startEngine = 1;

				class Turrets: Turrets
				{
					class CommanderOptics: CommanderOptics 
					{

					};

			class LoaderTurret: LoaderTurret
			{
				weapons[]={CH_M240_loader_M1A1};
				magazines[]={
						"CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240",
						"CH_200Rnd_762x51_M240","CH_200Rnd_762x51_M240"
				};
			};
				};
			};
		};

		class Damage
		{
			tex[]={};
			mat[]={
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_01_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_01_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_01_metal_destruct.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_02_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_02_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_02_metal_destruct.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_03_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_03_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_03_metal_destruct.rvmat",
				"ca\weapons\data\m2.rvmat",
				"ca\weapons\data\m2.rvmat",
				"ca\weapons\data\m2_destruct.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_track_metal.rvmat",
				"ch_m1abrams\data\detailmapy\m1\m1_abrams_track_metal.rvmat",
				"ca\tracked\data\detailmapy\m1_abrams_track_metal_destruct.rvmat"	
			};
		};

		class AnimationSources
		{
			class t_stuff_hide
			{
				type="hide";
				source="user";
				selection="t_stuff";
				animPeriod=0;
			};
			class t_stuff_bag1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag1";
				animPeriod=0;
			};
			class t_stuff_bag2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag2";
				animPeriod=0;
			};
			class t_stuff_bag3_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag3";
				animPeriod=0;
			};
			class t_stuff_bag4_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_bag4";
				animPeriod=0;
			};
			class t_stuff_kolo1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_kolo1";
				animPeriod=0;
			};
			class t_stuff_kolo2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_kolo2";
				animPeriod=0;
			};
			class t_stuff_wor1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_wor1";
				animPeriod=0;
			};
			class t_stuff_wor2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_wor2";
				animPeriod=0;
			};
			class t_stuff_track1_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_track1";
				animPeriod=0;
			};
			class t_stuff_track2_hide
			{
				type="hide";
				source="user";
				selection="t_stuff_track2";
				animPeriod=0;
			};
			class panc1_hide
			{
				type="hide";
				source="user";
				selection="panc1";
				animPeriod=0;
			};
			class MainGunRecoil
			{
				type="translation";
				source="user";
				selection="maingun";
				memory=1;
				axis="maingunrecoil";
				begin="maingunrecoil_begin";
				end="maingunrecoil_end";
				minValue=0;
				maxValue="1";
				offset0=0;
				offset1=0.290000;
				animPeriod=0.15;
			};
			class belt_m240_rotation
			{
				source="reload";
				weapon="CH_M240_loader_M1A1";
			};
			class belt_m2_rotation
			{
				source="reload";
				weapon="CH_M2_M1A1";
			};
		};
	};

	class CH_M1_GREEN: CH_M1
	{
		displayName = $STR_DN_CH_M1_GREEN;
	};

	class CH_M1_REFORGER83: CH_M1
	{
		displayName = $STR_DN_CH_M1_REFORGER83;
	};

	class CH_M1_MERDC: CH_M1
	{
		displayName = $STR_DN_CH_M1_MERDC;
	};

	class CH_M1_GUER: CH_M1
	{
		vehicleClass = "CH_Armour_Guer";
		displayName = $STR_DN_CH_M1_GUER;

		crew = SoldierGCrew;
		typicalCargo[]={SoldierGCrew,SoldierGCrew,SoldierGCrew,SoldierGCrew};
		side=TGuerrila;
	};

	class CH_M1_RACS: CH_M1_GUER
	{
		displayName = $STR_DN_CH_M1_RACS;
	};
};