class CfgAmmo
{
	class BulletCore ;
	class BulletBase : BulletCore {};
	class B_762x51_Ball : BulletBase {};

	class CH_B_762x51_Ball : B_762x51_Ball
	{
		hit=13;indirectHit=0;indirectHitRange=0;
		typicalSpeed = 750;
		airFriction = -0.001050;
		visibleFire=22;
		audibleFire=18;
		visibleFireTime=3;
		cost = 1.2;
		airLock=0;
	};

	class B_127x99_Ball: BulletBase {};

	class CH_B_127x99_Ball : B_127x99_Ball
	{
		hit=26;indirectHit=3;indirectHitRange=0.01;
		visibleFire=22;
		audibleFire=22;
		visibleFireTime=3;
		cost = 20;
		airLock=0;
	};

	class ShellCore ;
	class ShellBase : ShellCore {};
	class Sh_120_SABOT: ShellBase {};

////////M1A1////////////////////////////////////////////////

	class CH_Sh_M829A2 : Sh_120_SABOT // M829A2 APFSDS-T
	{
		hit=710;indirectHit=0;indirectHitRange=0;
		typicalSpeed = 1675;
		airFriction = -0.0000375;
		deflecting = 15;
		explosive = 0.01;
		cost = 300;
		model= \ca\Weapons\shell;

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 2.5;
	};

////////M1//////////////////////////////////////////////////

	class CH_Sh_M735 : Sh_120_SABOT // M735 APFSDS-T
	{
		hit=500;indirectHit=0;indirectHitRange=0;
		typicalSpeed = 1502;
		airFriction = -0.0000375;
		deflecting = 15;		
		explosive = 0.01;
		cost = 300;
		model= \ca\Weapons\shell;

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 2.5;
	};

	class CH_Sh_M392A2 : Sh_120_SABOT // M392A2 APDS-T
	{
		hit = 430;indirectHit=0;indirectHitRange=0;
		simulationStep = 0.0050000;
		typicalSpeed = 1440;
		airFriction = -0.000180;
		explosive = 0.01;
		deflecting = 0;
		cost = 300;
		model= \ca\Weapons\shell;

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 2.5;
	};

	class Sh_120_HE: ShellBase {};

////////M1A1////////////////////////////////////////////////

	class CH_Sh_M830 : Sh_120_HE // M830 HEAT-T
	{
		hit = 425;
		indirectHit=20;indirectHitRange=6;
		typicalSpeed = 1100;
		airFriction = -0.000275;
		explosive = 0.800000;
		deflecting = 0;
		cost = 300;
		model = "\ca\Weapons\shell";

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 4;
	};
	class CH_Sh_M830A1 : Sh_120_HE // M830A1 HEAT-MP-T
	{
		hit = 300;
		indirectHit=100;indirectHitRange=5;
		simulationStep = 0.0050000;
		typicalSpeed = 1400;
		airFriction = -0.000180;
		explosive = 0.500000;
		deflecting = 0;
		cost = 300;
		model = "\ca\Weapons\shell";

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 4;
	};
	class CH_Sh_M908 : Sh_120_HE // M908 HE-OR-T
	{
		hit = 200;
		indirectHit = 80;indirectHitRange = 8;
		typicalSpeed = 1400;
		airFriction = -0.000180;
		explosive = 1.00000;
		deflecting = 0;
		cost = 300;
		model = "\ca\Weapons\shell";

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 4;
	};

////////M1//////////////////////////////////////////////////

	class CH_Sh_M456 : Sh_120_HE // M456 HEAT-T 
	{
		hit = 350;indirectHit=20;indirectHitRange=6; 		
		typicalSpeed = 1140;
		airFriction = -0.000275;
		explosive = 0.800000;
		deflecting = 0;
		cost = 300;
		model = "\ca\Weapons\shell";

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 4;		
	};

	class CH_Sh_M393A1 : Sh_120_HE // M393A1 HEP-T
	{
		hit = 180;indirectHit = 80;indirectHitRange = 8;
		typicalSpeed = 720;
		airFriction = -0.000180;
		explosive = 1.00000;
		deflecting = 0;
		cost = 300;
		model = "\ca\Weapons\shell";

		SIX_tracerEnable = 1;
		SIX_tracerColor = "R";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 4;
	};
};

class CfgMagazines
{
	class Default ;
	class CA_Magazine : Default {};
	class VehicleMagazine : CA_Magazine {};

	class 1200Rnd_762x51_M240 : VehicleMagazine {};
	class CH_2800Rnd_762x51_M240 : 1200Rnd_762x51_M240
	{
		ammo = "CH_B_762x51_Ball";
		count = 2800;
	};

	class CH_200Rnd_762x51_M240 : VehicleMagazine
	{
		initSpeed = 900;
		ammo = "CH_B_762x51_Ball";
		count = 200;
	};

	class 100Rnd_127x99_M2: VehicleMagazine {};
	class CH_100Rnd_127x99_M2: 100Rnd_127x99_M2
	{
		ammo = "CH_B_127x99_Ball";
		count = 100;
	};

////////M1A1////////////////////////////////////////////////

	class CH_27Rnd_M829A2 : VehicleMagazine
	{
		displayName = $STR_DN_CH_27Rnd_M829A2;
		ammo = "CH_Sh_M829A2";
		count = 27;
		initSpeed = 1676;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_2Rnd_M830 : VehicleMagazine
	{
		displayName = $STR_DN_CH_2Rnd_M830;
		ammo = "CH_Sh_M830";
		count = 2;
		initSpeed = 1140;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_3Rnd_M830A1 : VehicleMagazine
	{
		displayName = $STR_DN_CH_3Rnd_M830A1;
		ammo = "CH_Sh_M830A1";
		count = 3;
		initSpeed = 1410;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_13Rnd_M830A1 : VehicleMagazine
	{
		displayName = $STR_DN_CH_13Rnd_M830A1;
		ammo = "CH_Sh_M830A1";
		count = 13;
		initSpeed = 1410;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_5Rnd_M908 : VehicleMagazine
	{
		displayName = $STR_DN_CH_5Rnd_M908;
		ammo = "CH_Sh_M908";
		count = 5;
		initSpeed = 1410;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

////////M1//////////////////////////////////////////////////

	class CH_30Rnd_M735 : VehicleMagazine
	{
		displayName = $STR_DN_CH_30Rnd_M735;
		ammo = "CH_Sh_M735";
		count = 30;
		initSpeed = 1501;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_25Rnd_M456 : VehicleMagazine
	{
		displayName = $STR_DN_CH_25Rnd_M456;
		ammo = "CH_Sh_M456";
		count = 25;
		initSpeed = 1173;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_20Rnd_M392A2 : VehicleMagazine
	{
		displayName = $STR_DN_CH_20Rnd_M392A2;
		ammo = "CH_Sh_M392A2";
		count = 20;
		initSpeed = 1478;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};

	class CH_15Rnd_M393A1 : VehicleMagazine
	{
		displayName = $STR_DN_CH_15Rnd_M393A1;
		ammo = "CH_Sh_M393A1";
		count = 15;
		initSpeed = 732;
		maxLeadSpeed = 72;
		nameSound = "cannon";
	};
};

class cfgWeapons
{
	class Default ;
	class MGun ;
	class M240_veh : MGun {};

	class CH_M240C_veh_M1A1 : M240_veh
	{
		displayName = $STR_DN_CH_M240C_veh_M1A1;
		reloadTime = 0.0650000;
		dispersion = 0.001900;
		magazineReloadTime = 120;
		magazines[] = {CH_2800Rnd_762x51_M240};
		minRange = 1;
		minRangeProbab = 0.100000;
		midRange = 200;
		midRangeProbab = 0.700000;
		maxRange = 1800;
		maxRangeProbab = 0.010000;
		aiRateOfFire = 0;
		aiRateOfFireDistance = 800;
		aiDispersionCoefX = 4.000000;
		aiDispersionCoefY = 2.000000;
		canLock = 2;
		autoReload = 0;

		sound[] = {\ch_m1abrams\Data\Sound\m240coax.ogg,db20,1};
		reloadSound[]={"",db0,1};
		reloadMagazineSound[]={\ch_m1abrams\Data\Sound\m249_reload_1p.ogg,db0,1};
	};

	class CH_M240_loader_M1A1: M240_veh
	{
		scope = protected;
		displayName = $STR_DN_CH_M240_loader_M1A1;
		reloadTime = 0.075;
		autoFire = 1;
		soundContinuous = false;
		dispersion=0.003;
		minRange=2;minRangeProbab=0.10;
		midRange=200;midRangeProbab=0.7;
		maxRange=600;maxRangeProbab=0.01;
		aiDispersionCoefY=4.0;
		aiDispersionCoefX=2.0;
		magazines[] = {CH_200Rnd_762x51_M240};
		magazineReloadTime=7;
		maxLeadSpeed = 600;
		canLock = 0;
		autoReload = 0;

		sound[] = {\ch_m1abrams\Data\Sound\m240.ogg,db20,1};
		reloadSound[]={"",db0,1};
		reloadMagazineSound[]={\ch_m1abrams\Data\Sound\m249_reload_1p.ogg,db0,1};
	};

	class CH_M240B_loader_M1A1: CH_M240_loader_M1A1
	{
		displayName = $STR_DN_CH_M240B_loader_M1A1;
	};

	class M2 : MGun {};

	class CH_M2_M1A1 : M2
	{
		displayName = $STR_DN_CH_M2_M1A1;
		magazines[] = {CH_100Rnd_127x99_M2};
		reloadTime = 0.110000;
		magazineReloadTime = 20;
		canLock = 0;
		autoReload = 0;

		sound[]={\ch_m1abrams\Data\Sound\m2_50cal.ogg,db10,1};
		reloadSound[]={"",db0,1};
		reloadMagazineSound[]={\ch_m1abrams\Data\Sound\m249_reload_1p.ogg,db0,1};
	};

	class CannonCore ;
	class M256 : CannonCore {};

	class CH_M256_M1A1 : M256
	{
		scope = protected;
		displayName = $STR_DN_CH_M256_M1A1;
		magazines[] = {"CH_27Rnd_M829A2","CH_3Rnd_M830A1","CH_13Rnd_M830A1", "CH_2Rnd_M830","CH_5Rnd_M908"};
		reloadTime = 6;
		magazineReloadTime = 6;
		maxLeadSpeed = 72;
		canLock = 2;
		autoReload = 0;
		minRange = 1;
		minRangeProbab = 0.100000;
		midRange = 1200;
		midRangeProbab = 0.700000;
		maxRange = 4000;
		maxRangeProbab = 0.100000;
		dispersion = 0.000100;

		sound[]={\ch_m1abrams\Data\Sound\M1A1_fire_3p.ogg,db60,1};
		reloadSound[]={\ch_m1abrams\Data\Sound\AmoClsd.ogg,db0,1};
		reloadMagazineSound[]={"",db0,1};
	};

	class CH_M68A1_M1 : M256
	{
		scope = protected;
		displayName = $STR_DN_CH_M68A1_M1;
		magazines[] = {"CH_30Rnd_M735","CH_25Rnd_M456","CH_20Rnd_M392A2", "CH_15Rnd_M393A1"};
		reloadTime = 7;
		magazineReloadTime = 7;
		maxLeadSpeed = 72;
		canLock = 2;
		autoReload = 0;
		minRange = 1;
		minRangeProbab = 0.100000;
		midRange = 1000;
		midRangeProbab = 0.700000;
		maxRange = 3500;
		maxRangeProbab = 0.100000;

		sound[]={\ch_m1abrams\Data\Sound\M1A1_fire_3p.ogg,db60,1};
		reloadSound[]={\ch_m1abrams\Data\Sound\AmoClsd.ogg,db0,1};
		reloadMagazineSound[]={"",db0,1};
	};
};