#define TEast 0
#define TWest 1
#define TGuerrila 2
#define TCivilian 3
#define TSideUnknown 4
#define TEnemy 5
#define TFriendly 6
#define TLogic 7

#define true 1
#define false 0

// type scope
#define private 0
#define protected 1
#define public 2

#define VSoft 0
#define VArmor 1
#define VAir 2

class CfgPatches
{
	class CH_T72
	{
		Units[]= {CH_T72M, CH_T72A, CH_T72_SLA, CH_T72_SOVIET, CH_T72_MODERN, CH_T72_DESERT, CH_T72M_GUER, CH_T72_RACS, CH_T72M1V, CH_T72AV, CH_T72_2_SLA, CH_T72_2_SOVIET, CH_T72_2_MODERN, CH_T72_2_DESERT, CH_T72M1V_GUER, CH_T72_2_RACS};
		weapons[]= {CH_D81_T72, CH_PKT_T72, CH_DSHKM_T72};
		requiredVersion = 1.140000;
		requiredAddons[] = {CAData,CACharacters,CAWeapons,CASounds,CATracked,Extended_EventHandlers};
	};
};

#include <cfgWeapons.h>

class CfgVehicleClasses
{
	class CH_Armour_East
	{
		displayName = $STR_DN_CH_Armour_East;
	};

	class CH_Armour_Guer
	{
		displayName = $STR_DN_CH_Armour_Guer;
	};
};

class Extended_Init_EventHandlers
{
      class CH_T72M {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""SLA""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72A {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Soviet""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_SLA {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""SLA""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_SOVIET {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Soviet""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_MODERN {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Modern""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_DESERT {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Desert""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72M_GUER {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""RACS""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_RACS {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""RACS""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72M1V {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""SLA""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72AV {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Soviet""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_2_SLA {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""SLA""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_2_SOVIET {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Soviet""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_2_MODERN {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Modern""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_2_DESERT {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""Desert""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72M1V_GUER {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""RACS""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };

      class CH_T72_2_RACS {
           init = "CH_Panc = [_this select 0, ""random"", ""random"", ""random""] execVM ""\ch_t72_cfg\scripts\t-72\panc.sqf"";";
	   textures = "CH_Textures = [_this select 0, ""RACS""] execVM ""\ch_t72_cfg\scripts\t-72\textures.sqf"";";
                     };
};

class Extended_Fired_EventHandlers
{
     class CH_T72M {
           fired = "if (_this select 1 == ""CH_D81_T72"") then {CH_Recoil = [_this select 0] execVM ""\ch_t72_cfg\scripts\maingunrecoil.sqf""};";
		    };
};

class CfgVehicles
{
	class Land;
	
	class LandVehicle: Land 
	{
		class NewTurret;
		class ViewOptics;
	};

	class Tank: LandVehicle 
	{
		class Turrets 
		{
			class MainTurret: NewTurret 
			{
				class Turrets 
				{
					class CommanderOptics: NewTurret {};
				};
			};
		};
				
		class ViewOptics : ViewOptics {};
	};

	class T72: Tank {};

	class CH_T72M: T72
	{
		vehicleClass = "CH_Armour_East";
		displayName = $STR_DN_CH_T72M;
		displayNameShort = $STR_DN_CH_T72M;
		model="\ch_t72\ch_t72.p3d";

		scope=public;
		picture="\ca\tracked\Data\ico\t72_CA.paa";
		Icon="\Ca\tracked\Data\map_ico\icomap_t72_CA.paa";
		mapSize = 12;
		side=TEast;
		crew = SoldierECrew;
		nameSound="t72";
		accuracy=0.80;
		hiddenSelections[] = {"pruh","01_co","02_co","03_co","04_co","track_co"};

		armor=480;
		armorHull = 1;
 		armorTurret = 0.8;
 		armorGun = 0.6;
 		armorEngine = 0.8;
 		armorTracks = 0.6;
		armorStructural=3.2;
		damageResistance=0.05;
		ejectDamageLimit = 0.2;
		cost=3500000;

		camouflage = "6.79*60";

		castDriverShadow = 0;

		soundEngine[]={\ch_t72\Data\Sound\Engine.ogg,db22,0.75};
		soundEnviron[]={\ch_t72\Data\Sound\Tracks.ogg,db20,0.95};

		class ViewOptics
		{
			initAngleX=0; minAngleX=-30; maxAngleX=+30;
			initAngleY=0; minAngleY=-100; maxAngleY=+100;
			initFov=0.9; minFov=0.9; maxFov=0.9;
		};
		class ViewPilot
		{
			initAngleX=0; minAngleX=0; maxAngleX=+25;
			initAngleY=0; minAngleY=-100; maxAngleY=+100;
			initFov=0.57; minFov=0.42; maxFov=0.64;
		};

		class HitHull 
		{
			armor=1.000000;
			material=55;
			name="telo";
			visual="telo";
			passThrough=1;
		};
		class HitLTrack
		{
			armor = 0.125000;
			material = 53;
			name = "pas_L";
			visual = "pas_L";
			passThrough = 1;
		};
		class HitRTrack
		{
			armor = 0.125000;
			material = 54;
			name = "pas_P";
			visual = "pas_P";
			passThrough = 1;
		};
		class HitEngine
		{
			armor = 1.000000;
			material = 55;
			name = "motor";
			visual = "hit_hull";
			passThrough = 1;
		};

		maxSpeed=60;
		typicalCargo[]={SoldierECrew,SoldierECrew,SoldierECrew};

		forceHideDriver = 0;
		driverForceOptics = 1;
		driverAction = T72_DriverOut;
		driverInAction = T72_Driver;

		class Exhausts
		{
			class Exhaust1
			{
			position = "vyfuk start";
			direction = "vyfuk konec";
			effect = "ExhaustsEffectBig";
			};
		};

		type = 1;
		unitInfoType = "UnitInfoTank";
		threat[]={0.9, 0.8, 0.2};

		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				gunnerAction = T72_GunnerOut;
				gunnerInAction = T72_Gunner;
				weapons[]={CH_D81_T72,CH_PKT_T72};
				magazines[]={CH_13Rnd_3VBM17,CH_17Rnd_3VOF36,CH_14Rnd_3VBK17,CH_2000Rnd_762x54_PKT};

				soundServo[]={\ch_t72\Data\Sound\TurretRotation.ogg,db5,1.0};

				gunnerOpticsModel = \ca\Tracked\optika_T72_gunner;
				gunnerOutOpticsModel = "\ca\weapons\optika_empty";
				minElev=-6; maxElev=+14; initElev=0;
				initTurn = 0;

				lockWhenDriverOut=1;
				maxHorizontalRotSpeed = 0.650000;
				maxVerticalRotSpeed = 0.120000;

				castGunnerShadow = 0;

				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.13; minFov=0.039385; maxFov=0.300000;
				};
				class ViewGunner
				{
					initAngleX = 0; minAngleX = -30; maxAngleX = 30;
					initAngleY = 0; minAngleY = -100; maxAngleY = 100;
					initFov=0.57; minFov=0.42; maxFov=0.64;
				};

				class HitTurret
				{
					armor = 0.15;
					material = 51;
					name = "vez";
					visual = "hit_mainturret";
					passThrough = 1;
				};
				class HitGun
				{
					armor = 0.10;
					material = 52;
					name = "zbran";
					visual = "hit_maingun";
					passThrough = 1;
				};
				class Turrets: Turrets
				{
					class CommanderOptics: CommanderOptics
					{
						weapons[]={CH_DSHKM_T72};
						magazines[]={CH_50Rnd_127x107_DSHKM,CH_50Rnd_127x107_DSHKM,CH_50Rnd_127x107_DSHKM,CH_50Rnd_127x107_DSHKM,CH_50Rnd_127x107_DSHKM,CH_50Rnd_127x107_DSHKM};
						gunBeg = "gun_muzzle";
						gunEnd = "gun_chamber";
						body = "ObsTurret";
						gun = "ObsGun";
						gunnerAction = T72_CommanderOut;
						gunnerInAction = T72_Commander;
						minElev=-10; maxElev=+45; initElev=0;
						minTurn=-360; maxTurn=+360; initTurn=0;
						gunnerOpticsModel = "\ca\Tracked\optika_T72_commander";
						gunnerOutOpticsModel = "";

						outGunnerMayFire = 1;
						inGunnerMayFire = 1;

						startengine = false;
						maxVerticalRotSpeed = 1.000000;
						viewGunnerInExternal = 0;
						gunnerOpticsShowCursor = 0;
						gunnerOutOpticsShowCursor = 0;
						gunnerUsesPilotView = 0;

						castGunnerShadow = 0;

						class ViewOptics
						{
							initAngleX = 0; minAngleX = -30; maxAngleX = 30;
							initAngleY = 0; minAngleY = -100; maxAngleY = 100;
							initFov = 0.301333; minFov = 0.064000; maxFov = 0.666666;
						};
						class ViewGunner
						{
							initAngleX=0; minAngleX=-30; maxAngleX=+30;
							initAngleY=0; minAngleY=-150; maxAngleY=+150;
							initFov=0.57; minFov=0.42; maxFov=0.64;
						};
					};
				};
			};
		};

		class Damage
		{
			tex[]={};
			mat[]={
				"ch_t72\data\detailmapy\t-72\t72_metal.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_metal.rvmat",
				"ca\tracked\data\detailmapy\t72_metal_destruct.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_metal_2.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_metal_2.rvmat",
				"ca\tracked\data\detailmapy\t72_metal_2_destruct.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_metal_small.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_metal_small.rvmat",
				"ca\tracked\data\detailmapy\t72_metal_small_destruct.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_pasy.rvmat",
				"ch_t72\data\detailmapy\t-72\t72_pasy.rvmat",
				"ca\tracked\data\detailmapy\t72_pasy_destruct.rvmat",
				"ca\weapons\data\dshk.rvmat",
				"ca\weapons\data\dshk.rvmat",
				"ca\weapons\data\dshk_destruct.rvmat"
			};
		};

		class Library {libTextDesc = $STR_LIB_CH_T72;};

		class AnimationSources
		{
			class panc1_hide
			{
				type="hide";
				source="user";
				selection="panc1";
				animPeriod=0;
			};
			class panc2_hide
			{
				type="hide";
				source="user";
				selection="panc2";
				animPeriod=0;
			};
			class panc3_hide
			{
				type="hide";
				source="user";
				selection="panc3";
				animPeriod=0;
			};

			class MainGunRecoil
			{
				type="translation";
				source="user";
				selection="maingun";
				memory=1;
				axis="maingunrecoil";
				begin="maingunrecoil_begin";
				end="maingunrecoil_end";
				minValue=0;
				maxValue="1";
				offset0=0;
				offset1=0.290000;
				animPeriod=0.15;
			};

			class belt_dshkm_rotation
			{
				source="reload";
				weapon="CH_DSHKM_T72";
			};
		};

		class UserActions
		{
	        	class CH_Smoke
			{
				displayName=$STR_DN_CH_Smoke;
				OnlyForPlayer=true;
				position="window";
				showWindow= 0;
				default = false;
				radius=20;
				condition="(gunner this == player && vehicle player == this && ch_t72_ThrowSmoke == 0)";
				statement="ch_t72_ThrowSmoke = 1";
			};
		};
	};

	class CH_T72A: CH_T72M
	{
		displayName = $STR_DN_CH_T72A;
	};

	class CH_T72_SLA: CH_T72M
	{
		displayName = $STR_DN_CH_T72_SLA;
	};

	class CH_T72_SOVIET: CH_T72M
	{
		displayName = $STR_DN_CH_T72_SOVIET;
	};

	class CH_T72_MODERN: CH_T72M
	{
		displayName = $STR_DN_CH_T72_MODERN;
	};

	class CH_T72_DESERT: CH_T72M
	{
		displayName = $STR_DN_CH_T72_DESERT;
	};

	class CH_T72M_GUER: CH_T72M
	{
		vehicleClass = "CH_Armour_Guer";
		displayName = $STR_DN_CH_T72M_GUER;

		side=TGuerrila;
		typicalCargo[]={SoldierGCrew,SoldierGCrew,SoldierGCrew};
		crew = SoldierGCrew;
	};

	class CH_T72_RACS: CH_T72M_GUER
	{
		displayName = $STR_DN_CH_T72_RACS;
	};

	class CH_T72M1V: CH_T72M
	{
		displayName = $STR_DN_CH_T72M1V;
		displayNameShort = $STR_DN_CH_T72M1V;
		model="\ch_t72\ch_t72_2.p3d";

		armor=580;
		armorHull = 1;
 		armorTurret = 0.8;
 		armorGun = 0.6;
 		armorEngine = 0.8;
 		armorTracks = 0.6;
		armorStructural=3.3;
		damageResistance=0.05;
		cost=3500000;

		class HitHull 
		{
			armor=1.100000;
			material=55;
			name="telo";
			visual="telo";
			passThrough=1;
		};
		class HitLTrack
		{
			armor = 0.130000;
			material = 53;
			name = "pas_L";
			visual = "pas_L";
			passThrough = 1;
		};
		class HitRTrack
		{
			armor = 0.130000;
			material = 54;
			name = "pas_P";
			visual = "pas_P";
			passThrough = 1;
		};
		class HitEngine
		{
			armor = 0.500000;
			material = 55;
			name = "motor";
			visual = "hit_hull";
			passThrough = 1;
		};

		maxSpeed=68;

		class Library {libTextDesc = $STR_LIB_CH_T72;};
	};

	class CH_T72AV: CH_T72M1V
	{
		displayName = $STR_DN_CH_T72AV;
	};

	class CH_T72_2_SLA: CH_T72M1V
	{
		displayName = $STR_DN_CH_T72_2_SLA;
	};

	class CH_T72_2_SOVIET: CH_T72M1V
	{
		displayName = $STR_DN_CH_T72_2_SOVIET;
	};

	class CH_T72_2_MODERN: CH_T72M1V
	{
		displayName = $STR_DN_CH_T72_2_MODERN;
	};

	class CH_T72_2_DESERT: CH_T72M1V
	{
		displayName = $STR_DN_CH_T72_2_DESERT;
	};

	class CH_T72M1V_GUER: CH_T72M1V
	{
		vehicleClass = "CH_Armour_Guer";
		displayName = $STR_DN_CH_T72M1V_GUER;

		side=TGuerrila;
		typicalCargo[]={SoldierGCrew,SoldierGCrew,SoldierGCrew};
		crew = SoldierGCrew;
	};

	class CH_T72_2_RACS: CH_T72M1V_GUER
	{
		displayName = $STR_DN_CH_T72_2_RACS;
	};
};