class CfgAmmo
{
	class BulletCore ;
	class BulletBase : BulletCore {};
	class B_762x54_Ball: BulletBase {};

	class CH_B_762x54_Ball: B_762x54_Ball
	{
		hit=12;indirectHit=0;indirectHitRange=0;
		visibleFire=22;
		audibleFire=18;
		visibleFireTime=3;
		cost = 1.2;
		airLock=0;
	};

	class B_127x107_Ball: BulletBase {};
	class CH_B_127x107_Ball: B_127x107_Ball
	{
		hit=28;indirectHit=3;indirectHitRange=0.01;
		visibleFire=22;
		audibleFire=22;
		visibleFireTime=3;
		cost = 20;
		airLock=1;
	};

	class ShellCore ;
	class ShellBase : ShellCore {};
	class Sh_125_SABOT : ShellBase {};

	class CH_3BM42 : Sh_125_SABOT // 3BM-42 APFSDS
	{
		hit = 500;
		indirectHit = 0;
		indirectHitRange = 0;
		typicalSpeed = 1700;
		airFriction = -0.0000500;
		deflecting = 15;
		explosive = 0.01;

		SIX_tracerEnable = 1;
		SIX_tracerColor = "G";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 2;
	};

	class Sh_125_HE: ShellBase {};

	class CH_3OF26 : Sh_125_HE // 3OF-26 HEF-FS
	{
		hit = 150;
		indirectHit = 80;
		indirectHitRange = 9;
		typicalSpeed = 850;
		airFriction = -0.000150;
		explosive = 1.000000;
		deflecting = 0;

		SIX_tracerEnable = 1;
		SIX_tracerColor = "G";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 3;
	};

	class CH_3BK21 : Sh_125_HE // 3BK-21 HEAT-FS
	{
		hit = 400;
		indirectHit = 20;
		indirectHitRange = 6;
		typicalSpeed = 905;
		airFriction = -0.0002625;
		explosive = 0.800000;
		deflecting = 0;
		model = "\ca\Weapons\shell";

		SIX_tracerEnable = 1;
		SIX_tracerColor = "G";
		SIX_tracerPer = 1;
		SIX_tracerSize = "Big";
		SIX_tracerLife = 3;
	};
};

class CfgMagazines
{
	class Default ;
	class CA_Magazine : Default {};
	class VehicleMagazine : CA_Magazine {};

	class 1500Rnd_762x54_PKT: VehicleMagazine {};
	class CH_2000Rnd_762x54_PKT: VehicleMagazine
	{
		count=2000;
		ammo = "CH_B_762x54_Ball";
		nameSound = "mgun";
	};

	class 50Rnd_127x107_DSHKM: VehicleMagazine {};
	class CH_50Rnd_127x107_DSHKM: 50Rnd_127x107_DSHKM
	{
		count=50;
		ammo= "CH_B_127x107_Ball";
	};

	class CH_13Rnd_3VBM17 : VehicleMagazine
	{
		displayName = $STR_DN_CH_13Rnd_3VBM17;
		ammo = "CH_3BM42";
		count = 13;
		initSpeed = 1700;
		maxLeadSpeed = 50;
		nameSound = "cannon";
	};

	class CH_17Rnd_3VOF36 : VehicleMagazine
	{
		displayName = $STR_DN_CH_17Rnd_3VOF36;
		ammo = "CH_3OF26";
		count = 17;
		initSpeed = 850;
		maxLeadSpeed = 50;
		nameSound = "cannon";
	};

	class CH_14Rnd_3VBK17 : VehicleMagazine
	{
		displayName = $STR_DN_CH_14Rnd_3VBK17;
		ammo = "CH_3BK21";
		count = 14;
		initSpeed = 905;
		maxLeadSpeed = 50;
		nameSound = "cannon";
	};
};

class cfgWeapons
{
	class Default ;
	class MGun ;
	class PKT: MGun {};

	class CH_PKT_T72: PKT
	{
		displayName = $STR_DN_CH_PKT_T72;
		reloadTime = 0.075;
		autoFire = 1;
		dispersion=0.003;
		minRange=2;minRangeProbab=0.10;
		midRange=200;midRangeProbab=0.7;
		maxRange=600;maxRangeProbab=0.01;
		aiDispersionCoefY=7.0;
		aiDispersionCoefX=7.0;
		magazines[] = {CH_2000Rnd_762x54_PKT};
		magazineReloadTime=7;
		maxLeadSpeed = 600;
		canLock = 2;
		autoReload = 0;

		sound[]={\ch_t72\Data\Sound\PKT_B.ogg,db10,1};
		reloadSound[]={"",db0,1};
		reloadMagazineSound[]={\ch_t72\Data\Sound\PKM_reload_1p.ogg,db0,1};
	};

	class DSHKM: MGun {};
	class CH_DSHKM_T72: DSHKM
	{
		displayName = $STR_DN_CH_DSHKM_T72;
		autoFire = 1;
		magazines[] = {CH_50Rnd_127x107_DSHKM};
		reloadTime = 0.1;
		magazineReloadTime = 10;
		dispersion=0.002;
		minRange=1;minRangeProbab=0.10;
		midRange=400;midRangeProbab=0.7;
		maxRange=1200;maxRangeProbab=0.04;
		aiDispersionCoefY=7.0;
		aiDispersionCoefX=7.0;
		aiRateOfFire=0.3; // delay between shots at given distance
		aiRateOfFireDistance=1500; // at shorter distance delay goes lineary to zero
		maxLeadSpeed = 600;
		canLock = 0;
		autoReload = 0;

		sound[]={\ch_t72\Data\Sound\Dshk.ogg,db10,1};
		reloadSound[]={"",db0,1};
		reloadMagazineSound[]={\ch_t72\Data\Sound\PKM_reload_1p.ogg,db0,1};
	};

	class CannonCore ;
	class D81 : CannonCore {};

	class CH_D81_T72 : D81
	{
		displayName = $STR_DN_CH_D81_T72;
		magazines[] = {"CH_13Rnd_3VBM17", "CH_17Rnd_3VOF36", "CH_14Rnd_3VBK17"};
		reloadTime = 7;
		magazineReloadTime = 0;
		maxLeadSpeed = 60;
		autoReload = 0;
		minRange = 1;
		minRangeProbab = 0.100000;
		midRange = 1200;
		midRangeProbab = 0.700000;
		maxRange = 4000;
		maxRangeProbab = 0.100000;
		dispersion = 0.000500;

		sound[]={\ch_t72\Data\Sound\T72_main_gun.ogg,db60,1};
		reloadSound[]={\ch_t72\Data\Sound\Reload.ogg,db0,1};
		reloadMagazineSound[]={"",db0,1};
	};
};