require 'fileutils'
require 'find'

FOLDERS =
[
	'bin', 
	'build',
	'config',
	'doc',
	'lib',
	'manual',
	'nbproject',
	'test',
	'visitor_templates',
]

FILES =
[
	'COPYING.txt', 
	'Rakefile',
	'README.txt',
]

puts '--- Building Roller release ---'
puts

puts 'Enter release version:'
RELEASE_VERSION = gets.chomp

RELEASE_DIR = "../release/roller_v#{RELEASE_VERSION.gsub(/\./, '_')}"

FileUtils.rmtree RELEASE_DIR

FileUtils.makedirs RELEASE_DIR

FOLDERS.each do |dir|
	FileUtils.cp_r "../#{dir}", RELEASE_DIR
end

FILES.each do |file|
	FileUtils.cp "../#{file}", RELEASE_DIR
end

# Remove .svn crud.
Find.find(RELEASE_DIR) do |path|
  if File.basename(path) == '.svn'
    FileUtils.rmtree path
    Find.prune
  end
end

puts
puts 'Making ZIP'
system "7z a -tzip \"#{RELEASE_DIR}.zip\" #{RELEASE_DIR}"

puts
puts 'Making 7z'
system "7z a \"#{RELEASE_DIR}.7z\" #{RELEASE_DIR}"