# To change this template, choose Tools | Templates
# and open the template in the editor.

$:.unshift File.join(File.dirname(__FILE__),'..','lib')

require 'test/unit'
require 'roller'
require 'fileutils'

class Test_cli_export < Test::Unit::TestCase
  OBJECTS = 'eden_ofp_unbin_objects.txt'
  WRP = 'eden_ofp_unbin_export.wrp'
  XYZ = 'eden_ofp_unbin.xyz'
  UNIQUE_OBJECTS = 'eden_ofp_unbin_unique_objects.txt'

  def test_replace
    Dir.chdir 'test_data'
    
    files = [OBJECTS, WRP, XYZ, UNIQUE_OBJECTS]

    files.each { |file| File.delete(file) if File.exist?(file) }

    ARGV.clear
    ARGV.push 'eden_ofp_unbin.wrp'
    ARGV.push '--objects', OBJECTS
    ARGV.push '--wrp', WRP
    ARGV.push '--xyz', XYZ
    ARGV.push '--e', '-99'
    ARGV.push '--unique-objects', UNIQUE_OBJECTS
    ARGV.push '-f'

    CWrp::Cli.process

    files.each { |file| assert File.exist?(file), "#{file} created" }

    files.each { |file| assert File.size(file) > 0, "#{file} empty" }
  end
end
