# To change this template, choose Tools | Templates
# and open the template in the editor.

$:.unshift File.join(File.dirname(__FILE__),'..','lib')

require 'test/unit'
require 'roller'
require 'fileutils'

class Test_cli_replace_objects < Test::Unit::TestCase
  OBJECTS = "eden_ofp_unbin_objects.txt"

  def test_replace
    Dir.chdir "test_data"
    
    files = [OBJECTS]

    files.each { |file| File.delete(file) if File.exist?(file) }

    ARGV.clear
    ARGV.push "eden_ofp_unbin.wrp"
    ARGV.push "--replace-objects", "../config/ofp_objects_to_arma_objects,../config/ofp_objects_to_aceip_objects.yaml,ofp_vegetation_to_arma_vegetation,ofp_vegetation_to_aceip_vegetation.yaml"
    ARGV.push "--replace-forests", "ofp_forest_blocks_to_arma_single_object_forest,ofp_forest_blocks_to_aceip_single_object_forest.yaml"
    ARGV.push "--objects", OBJECTS
    ARGV.push "-f"
    ARGV.push '-p'

    CWrp::Cli.process

    files.each { |file| assert File.exist?(file), "#{file} created" }

    files.each { |file| assert File.size(file) > 0, "#{file} empty" }
  end
end
