# To change this template, choose Tools | Templates
# and open the template in the editor.

$:.unshift File.join(File.dirname(__FILE__),'..','lib')

require 'test/unit'
require 'roller'
require 'fileutils'

class Test_cli_resize_terrain < Test::Unit::TestCase
  XYZ = 'eden_ofp.xyz'

  def test_resize
    Dir.chdir 'test_data'
    
    files = [XYZ]

    files.each { |file| File.delete(file) if File.exist?(file) }

    ARGV.clear
    ARGV.push 'eden_ofp_unbin.wrp'
    ARGV.push '--terrain-cell-size', '12.5' # 50m originally, so: 100, 25, 12.5, 6.25, 3.125, etc.
    ARGV.push '--terrain-bumpiness', '1'
    ARGV.push '--xyz', XYZ
    ARGV.push '-f'
    ARGV.push '-p'

    CWrp::Cli.process

    files.each { |file| assert File.exist?(file), "#{file} created" }

    files.each { |file| assert File.size(file) > 0, "#{file} empty" }
  end
end
