KRON_StrLen     = compile preprocessFile "KRON_String_Lib\KRON_StrLen.sqf";
KRON_StrLeft    = compile preprocessFile "KRON_String_Lib\KRON_StrLeft.sqf";
KRON_StrToArray = compile preprocessFile "KRON_String_Lib\KRON_StrToArray.sqf"; // dependent on KRON_StrLeft
KRON_StrMid     = compile preprocessFile "KRON_String_Lib\KRON_StrMid.sqf";     // dependent on KRON_StrLeft and KRON_StrToArray
KRON_StrRight   = compile preprocessFile "KRON_String_Lib\KRON_StrRight.sqf";   // dependent on KRON_StrLeft and KRON_StrToArray
KRON_StrInStr   = compile preprocessFile "KRON_String_Lib\KRON_StrInStr.sqf";   // dependent on KRON_StrLen, KRON_StrLeft and KRON_StrToArray



ParticleEffectRunning = [true, false, false, false, false];
ParticleEffectSource = [];

ParticleEffectAttached = false;

CurrentEffect = 0;
NextActionID = 9999;
PrevActionID = 9999;
AttachActionID = 9999;
StartStopActionID = 9999;


// initialise particle effect
[] execVM "InitDefaults.sqf";


sleep 0.1;

//Valid shapenames, straight from the wiki
ValidShapeNamesArray =
[
	["\Ca\Data\Cl_basic.p3d",1,0,1,0],
	["\Ca\Data\Cl_fire",16,0,16,0],
	["\Ca\Data\Cl_fired",1,0,1,0],
	["\Ca\Data\Cl_water",1,0,1,0],
	["\ca\data\cl_exp",1,0,1,0],
	["\ca\data\cl_feathers2",1,0,1,1],
	["\ca\data\cl_fireball_02",1,0,1,0],
	["\ca\data\cl_firetest",1,0,1,0],
	["\ca\data\cl_grenade2",1,0,1,0],
	["\ca\data\cl_grass1",1,0,1,1],
	["\ca\data\cl_grass2",1,0,1,1],
	["\ca\data\cl_leaf",1,0,1,1],
	["\ca\data\cl_leaf2",1,0,1,1],
	["\ca\data\cl_leaf3",1,0,1,1],
	["\ca\data\cl_rock1",1,0,1,1],
	["\Ca\Data\ParticleEffects\Blood\Blood.p3d",1,0,1,0],
	["\Ca\Data\ParticleEffects\CloudletSand\CloudletSand.p3d",4,0,1,0],
	["\Ca\Data\ParticleEffects\CloudletWater\CloudletWater.p3d",4,0,1,0],
	["\Ca\Data\ParticleEffects\FireAndSmokeAnim\FireAnim.p3d",8,0,8,0],
	["\Ca\Data\ParticleEffects\RocketSmoke\RocketSmoke.p3d",1,0,1,0],
	["\Ca\Data\ParticleEffects\FireAndSmokeAnim\SmokeAnim.p3d",8,0,8,0],
	["\Ca\Data\ParticleEffects\Pstone\Pstone.p3d",1,0,1,1],
	["\Ca\Data\ParticleEffects\SparksEffect\SparksEffect.p3d",1,0,1,0],
	["\Ca\Data\ParticleEffects\Watereffects\WaterEffects.p3d",1,0,1,0],
	["\Ca\Data\kouleSvetlo",1,0,1,0],
	["\Ca\Data\krater_po_kulce",1,0,1,1],
	["\Ca\Data\missileSmoke",1,0,1,0],
	["\Ca\Data\RainDrop",1,0,1,0],
	["\ca\data\blesk1",1,0,1,1],
	["\ca\data\blesk2",1,0,1,1],
	["\ca\Data\colision",1,0,1,1],
	["\ca\data\horizont",1,0,1,1],
	["\ca\data\krater",1,0,1,1],
	["\ca\data\koule",1,0,1,1],
	["\ca\weapons\kusplechu",1,0,1,1],
	["\ca\weapons\kusplechu2",1,0,1,1],
	["\ca\weapons\sutr2",1,0,1,1],
	["\ca\weapons\sutr3",1,0,1,1],
	["\ca\misc\kusplechu3",1,0,1,1],
	["\ca\data\obloha",1,0,1,1],
	["\ca\air\obrysove svetlo",1,0,1,0],
	["\ca\Data\papauto",1,0,1,1],
	["\ca\data\ParticleTest",1,0,1,0],
	["\ca\data\rainbow",1,0,1,1],
	["\ca\data\rect",1,0,1,0]
];

// Either "Billboard" or "SpaceObject", straight from the wiki
ValidTypesArray =
[
	"Billboard",
	"SpaceObject"
];

[0] execVM "SmokeRefresh.sqf";
[1] execVM "SmokeRefresh.sqf";
[2] execVM "SmokeRefresh.sqf";
[3] execVM "SmokeRefresh.sqf";
[4] execVM "SmokeRefresh.sqf";

player addaction ["Edit Particle Params",                 "ParticleParams\EditParticleParams.sqf"];
player addaction ["Edit Drop Interval And Object Height", "MiscChanges\EditMiscChanges.sqf"];
player addaction ["Edit Particle Circle",                 "ParticleCircle\EditParticleCircle.sqf"];
player addaction ["Edit Particle Random",                 "ParticleRandom\EditParticleRandom.sqf"];
player addaction ["Show Fully Formatted Commands",        "Export\Export.sqf"];
player addaction ["Import Parameters",                    "Import\Import.sqf"];
player addaction ["Reset To Defaults",                    "ActionMenuMisc\Defaults.sqf"];

AttachActionID    = player addaction ["Attach Effects To Squadmate",                           "ActionMenuMisc\AttachEffect.sqf"];
NextActionID      = player addaction [format["Change to Particle Effect %1", CurrentEffect+2], "ActionMenuMisc\NextEffect.sqf"];
StartStopActionID = player addaction [format["Stop Particle Effect %1",      CurrentEffect+1], "ActionMenuMisc\Stop.sqf"];

hint "Use the action menu to manipulate particle effect";